/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;

public abstract class AbstractDulisticOpExpr
extends AbstractOpExpr {
    private static final int[] STRING_PAIR = new int[]{1, 1};
    private static final int[] NUMBER_PAIR = new int[]{2, 2};
    private static final int[] UNSURE_PAIR = new int[]{0, 0};

    public AbstractDulisticOpExpr(IExpr left, IExpr right) throws ParserException {
        super(new IExpr[]{left, right});
    }

    protected final IExpr getLeftExpr() {
        return this.getSubExprs()[0];
    }

    protected final IExpr getRightExpr() {
        return this.getSubExprs()[1];
    }

    @Override
    public String encode() {
        boolean isRightLower;
        boolean isLeftLower;
        StringBuilder sb = new StringBuilder();
        boolean bl = isLeftLower = this.getLeftExpr().getPriority() < this.getPriority();
        if (isLeftLower) {
            sb.append('(');
        }
        sb.append(this.getLeftExpr().encode());
        if (isLeftLower) {
            sb.append(')');
        }
        sb.append(this.encodeOp());
        boolean bl2 = isRightLower = this.getRightExpr().getPriority() <= this.getPriority();
        if (isRightLower) {
            sb.append('(');
        }
        sb.append(this.getRightExpr().encode());
        if (isRightLower) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected abstract String encodeOp();

    public static class OpLessEqual
    extends AbstractRelationOpExpr {
        public OpLessEqual(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(11);
        }

        @Override
        protected String encodeOp() {
            return "<=";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpLessEqual) {
                OpLessEqual another = (OpLessEqual)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value <= 0;
        }

        @Override
        protected void allowNullComparison() throws ExecuteException {
            throw ExecuteException.nullParamException(this);
        }
    }

    public static class OpLess
    extends AbstractRelationOpExpr {
        public OpLess(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(11);
        }

        @Override
        protected String encodeOp() {
            return "<";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpLess) {
                OpLess another = (OpLess)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value < 0;
        }

        @Override
        protected void allowNullComparison() throws ExecuteException {
            throw ExecuteException.nullParamException(this);
        }
    }

    public static class OpLargerEqual
    extends AbstractRelationOpExpr {
        public OpLargerEqual(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(11);
        }

        @Override
        protected String encodeOp() {
            return ">=";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpLargerEqual) {
                OpLargerEqual another = (OpLargerEqual)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value >= 0;
        }

        @Override
        protected void allowNullComparison() throws ExecuteException {
            throw ExecuteException.nullParamException(this);
        }
    }

    public static class OpLarger
    extends AbstractRelationOpExpr {
        public OpLarger(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(11);
        }

        @Override
        protected String encodeOp() {
            return ">";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpLarger) {
                OpLarger another = (OpLarger)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected void allowNullComparison() throws ExecuteException {
            throw ExecuteException.nullParamException(this);
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value > 0;
        }
    }

    public static class OpNotEqual
    extends AbstractRelationOpExpr {
        public OpNotEqual(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(10);
        }

        @Override
        protected String encodeOp() {
            return "<>";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpNotEqual) {
                OpNotEqual another = (OpNotEqual)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value != 0;
        }
    }

    public static class OpEqual
    extends AbstractRelationOpExpr {
        public OpEqual(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(10);
        }

        @Override
        protected String encodeOp() {
            return "=";
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpEqual) {
                OpEqual another = (OpEqual)obj;
                return this.isEquals(another);
            }
            return false;
        }

        @Override
        protected boolean checkCompareValue(int value) {
            return value == 0;
        }
    }

    private static abstract class AbstractRelationOpExpr
    extends AbstractDulisticOpExpr {
        public AbstractRelationOpExpr(IExpr left, IExpr right) throws ParserException {
            super(left, right);
        }

        @Override
        public final Object execute(IExecuteContext ctx) throws ExecuteException {
            Object leftValue = this.getLeftExpr().execute(ctx);
            Object rightValue = this.getRightExpr().execute(ctx);
            Integer compareValue = null;
            int dataType = AbstractRelationOpExpr.determineDataType(this.getLeftExpr().getReturnDataType(), this.getRightExpr().getReturnDataType());
            if (leftValue == null || rightValue == null) {
                this.allowNullComparison();
                int left = leftValue == null ? 0 : 1;
                int right = rightValue == null ? 0 : 1;
                compareValue = left - right;
            } else {
                switch (dataType) {
                    case 6: {
                        Boolean leftBool = (Boolean)leftValue;
                        Boolean rightBool = (Boolean)rightValue;
                        compareValue = leftBool.compareTo(rightBool);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        compareValue = AbstractRelationOpExpr.convertToDate(leftValue, this.getLeftExpr()).compareTo(AbstractRelationOpExpr.convertToDate(rightValue, this.getRightExpr()));
                        break;
                    }
                    case 2: {
                        compareValue = AbstractRelationOpExpr.convertToNumber(leftValue, this.getLeftExpr()).compareTo(AbstractRelationOpExpr.convertToNumber(rightValue, this.getRightExpr()));
                        break;
                    }
                    case 1: {
                        compareValue = AbstractRelationOpExpr.convertToString(leftValue, this.getLeftExpr().getReturnDataType()).compareTo(AbstractRelationOpExpr.convertToString(rightValue, this.getRightExpr().getReturnDataType()));
                        break;
                    }
                    case 0: {
                        throw ExecuteException.unmatchedParamValTypeException(this);
                    }
                }
            }
            return this.checkCompareValue(compareValue);
        }

        protected void allowNullComparison() throws ExecuteException {
        }

        private static int determineDataType(int leftReturnDataType, int rightReturnDataType) {
            int dataType1 = 0;
            int dateType2 = 0;
            if (AbstractRelationOpExpr.isDataTypeCompatible(leftReturnDataType, rightReturnDataType)) {
                dataType1 = leftReturnDataType;
            }
            if (AbstractRelationOpExpr.isDataTypeCompatible(rightReturnDataType, leftReturnDataType)) {
                dateType2 = rightReturnDataType;
            }
            return Math.max(dataType1, dateType2);
        }

        @Override
        public final int getReturnDataType() {
            return 6;
        }

        @Override
        protected final void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, UNSURE_PAIR);
        }

        protected abstract boolean checkCompareValue(int var1);
    }

    public static class OpDivide
    extends AbstractMathOpExpr {
        public OpDivide(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(21);
        }

        @Override
        protected String encodeOp() {
            return "/";
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal rightValue = OpDivide.getNumber(this.getRightExpr(), ctx);
            if (BigDecimal.ZERO.compareTo(rightValue) == 0) {
                throw new ExecuteException(18, this.getRightExpr());
            }
            BigDecimal leftValue = OpDivide.getNumber(this.getLeftExpr(), ctx);
            return OpDivide.divide(leftValue, rightValue);
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpDivide) {
                OpDivide another = (OpDivide)obj;
                return this.isEquals(another);
            }
            return false;
        }
    }

    public static class OpMultiply
    extends AbstractMathOpExpr {
        public OpMultiply(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(21);
        }

        @Override
        protected String encodeOp() {
            return "*";
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal leftValue = OpMultiply.getNumber(this.getLeftExpr(), ctx);
            BigDecimal rightValue = OpMultiply.getNumber(this.getRightExpr(), ctx);
            return leftValue.multiply(rightValue);
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpMultiply) {
                OpMultiply another = (OpMultiply)obj;
                return this.isEquals(another);
            }
            return false;
        }
    }

    public static class OpMinus
    extends AbstractMathOpExpr {
        public OpMinus(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(20);
        }

        @Override
        protected String encodeOp() {
            return "-";
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Object leftValue = this.getLeftExpr().execute(ctx);
            Object rightValue = this.getRightExpr().execute(ctx);
            if (leftValue == null && rightValue == null) {
                return null;
            }
            BigDecimal number1 = leftValue == null ? BigDecimal.ZERO : OpMinus.convertToNumber(leftValue, this.getLeftExpr());
            BigDecimal number2 = rightValue == null ? BigDecimal.ZERO : OpMinus.convertToNumber(rightValue, this.getRightExpr());
            return number1.subtract(number2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpMinus) {
                OpMinus another = (OpMinus)obj;
                return this.isEquals(another);
            }
            return false;
        }
    }

    public static class OpPlus
    extends AbstractMathOpExpr {
        public OpPlus(IExpr left, IExpr right) throws ParserException {
            super(left, right);
            this.setPriority(20);
        }

        @Override
        protected String encodeOp() {
            return "+";
        }

        @Override
        public int getReturnDataType() {
            if (OpPlus.isDataTypeCompatible(2, this.getLeftExpr().getReturnDataType()) && OpPlus.isDataTypeCompatible(2, this.getRightExpr().getReturnDataType())) {
                return 2;
            }
            return 1;
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, STRING_PAIR);
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Object leftValue = this.getLeftExpr().execute(ctx);
            Object rightValue = this.getRightExpr().execute(ctx);
            if (leftValue == null && rightValue == null) {
                return null;
            }
            switch (this.getReturnDataType()) {
                case 2: {
                    BigDecimal number1 = leftValue == null ? BigDecimal.ZERO : OpPlus.convertToNumber(leftValue, this.getLeftExpr());
                    BigDecimal number2 = rightValue == null ? BigDecimal.ZERO : OpPlus.convertToNumber(rightValue, this.getRightExpr());
                    return number1.add(number2);
                }
                case 1: {
                    String str1 = leftValue == null ? "" : OpPlus.convertToString(leftValue, this.getLeftExpr().getReturnDataType());
                    String str2 = rightValue == null ? "" : OpPlus.convertToString(rightValue, this.getRightExpr().getReturnDataType());
                    return str1 + str2;
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpPlus) {
                OpPlus another = (OpPlus)obj;
                return this.isEquals(another);
            }
            return false;
        }
    }

    private static abstract class AbstractMathOpExpr
    extends AbstractDulisticOpExpr {
        public AbstractMathOpExpr(IExpr left, IExpr right) throws ParserException {
            super(left, right);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, NUMBER_PAIR);
        }
    }
}

