/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.util.ArrayList;

public class StringTypeFunctions {
    private static final int[] PARAMS_STRING = new int[]{1};
    private static final int[] PARAMS_STRING_STRING = new int[]{1, 1};
    private static final int[] PARAMS_STRING_STRING_STRING = new int[]{1, 1, 1};
    private static final int[] PARAMS_STRING_NUMBER = new int[]{1, 2};
    private static final int[] PARAMS_STRING_NUMBER_NUMBER_STING = new int[]{1, 2, 2, 1};
    private static final int[] PARAMS_STRING_STRING_NUMBER = new int[]{1, 1, 2};
    private static final int[] PARAMS_STRING_STRING_STRING_NUMBER = new int[]{1, 1, 1, 2};
    private static final int[] PARAMS_STRING_STRING_NUMBER_NUMBER = new int[]{1, 1, 2, 2};
    private static final int[] PARAMS_STRING_NUMBER_NUMBER = new int[]{1, 2, 2};

    public static class SPLIT
    extends AbstractFunctionExpr {
        public SPLIT() {
            super("SPLIT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_STRING_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        private String handleSpecialChar(String splitToken) {
            StringBuilder sb = new StringBuilder();
            int length = splitToken.length();
            for (int i = 0; i < length; ++i) {
                char ch = splitToken.charAt(i);
                if (".$|()[{^?*+\\".indexOf(ch) != -1) {
                    sb.append('\\').append(ch);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int location;
            String value = this.getStringValue(this.getSubExprs()[0], ctx);
            String splitToken = this.getStringValue(this.getSubExprs()[1], ctx);
            int index = this.getIntValue(this.getSubExprs()[2], ctx);
            if (0 == index) {
                return "";
            }
            if (splitToken == null || splitToken.length() == 0) {
                return index > 1 ? "" : value;
            }
            String[] splitResults = value.split(this.handleSpecialChar(splitToken));
            int n = location = index > 0 ? index - 1 : index + splitResults.length;
            if (location > -1 && location < splitResults.length) {
                return splitResults[location];
            }
            return "";
        }
    }

    public static class REPT
    extends AbstractFunctionExpr {
        public REPT() {
            super("REPT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String str = this.getStringValue(this.getSubExprs()[0], ctx);
            int times = this.getIntValue(this.getSubExprs()[1], ctx);
            if (times <= 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(str);
            }
            return sb.toString();
        }
    }

    public static class REPLACE
    extends AbstractFunctionExpr {
        public REPLACE() {
            super("REPLACE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_NUMBER_NUMBER_STING});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String str = this.getStringValue(this.getSubExprs()[0], ctx);
            int fromPos = this.getIntValue(this.getSubExprs()[1], ctx) - 1;
            int len = this.getIntValue(this.getSubExprs()[2], ctx);
            String subStr = this.getStringValue(this.getSubExprs()[3], ctx);
            if (fromPos > str.length()) {
                throw ExecuteException.fromPosTooLargeException(this.getSubExprs()[1]);
            }
            int actualEnd = Math.min(str.length(), fromPos + len);
            return str.substring(0, fromPos) + subStr + str.substring(actualEnd);
        }
    }

    public static class INDEXOF
    extends AbstractFunctionExpr {
        public INDEXOF() {
            super("INDEXOF");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length == 2) {
                this.checkSubExprsCommonImpl(subExprs, PARAMS_STRING_STRING);
            } else {
                this.checkSubExprsCommonImpl(subExprs, PARAMS_STRING_STRING_NUMBER_NUMBER, PARAMS_STRING_STRING_NUMBER);
            }
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] subExprs = this.getSubExprs();
            int start = 1;
            int rept = 1;
            String term = this.getStringValue(subExprs[0], ctx);
            String withinText = this.getStringValue(subExprs[1], ctx);
            if (this.getSubExprs().length > 2) {
                IExpr var = subExprs[2];
                start = ((BigDecimal)var.execute(ctx)).intValue();
                if (start < 1) {
                    return this.getNumberTypeErrorValue();
                }
                if (subExprs.length > 3 && (rept = this.getIntValue(var = subExprs[3], ctx)) < 1) {
                    return this.getNumberTypeErrorValue();
                }
            }
            if (withinText.length() <= start) {
                return this.getNumberTypeErrorValue();
            }
            withinText = withinText.substring(start - 1);
            int idx = 0;
            for (int i = 1; i <= rept; ++i) {
                if ((idx = withinText.indexOf(term, idx)) < 0) {
                    return this.getNumberTypeErrorValue();
                }
                if (i == rept) {
                    return new BigDecimal(idx + start);
                }
                idx += term.length();
            }
            return this.getNumberTypeErrorValue();
        }
    }

    public static class SEARCH
    extends AbstractFunctionExpr {
        public SEARCH() {
            super("SEARCH");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_STRING_STRING, PARAMS_STRING_STRING_NUMBER);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String term = this.getStringValue(this.getSubExprs()[0], ctx);
            String withinText = this.getStringValue(this.getSubExprs()[1], ctx);
            int startFrom = this.getParamIntValueUseDefaultIfNotExist(ctx, 2, 1);
            if (startFrom <= 0) {
                throw ExecuteException.negativeOrZeroNumberException(this.getSubExprs()[2]);
            }
            term = term.toLowerCase();
            withinText = withinText.toLowerCase();
            return new BigDecimal(withinText.indexOf(term, startFrom - 1) + 1);
        }
    }

    public static class SUBSTITUTE
    extends AbstractFunctionExpr {
        public SUBSTITUTE() {
            super("SUBSTITUTE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_STRING_STRING_STRING, PARAMS_STRING_STRING_STRING_NUMBER);
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            String oldStr = this.getStringValue(this.getSubExprs()[1], ctx);
            String newStr = this.getStringValue(this.getSubExprs()[2], ctx);
            int times = this.getParamIntValueUseDefaultIfNotExist(ctx, 3, -1);
            int offset = 0;
            for (int i = 1; i <= times && (offset = strValue.indexOf(oldStr, offset)) >= 0; ++i) {
                if (i == times) {
                    return strValue.substring(0, offset) + newStr + strValue.substring(offset + oldStr.length());
                }
                offset += oldStr.length();
            }
            if (times < 0) {
                ArrayList<Integer> replaceIdxArray = new ArrayList<Integer>(10);
                StringBuilder sb = new StringBuilder();
                int fromIndex = 0;
                while ((fromIndex = strValue.indexOf(oldStr, fromIndex)) >= 0) {
                    replaceIdxArray.add(fromIndex);
                    fromIndex += oldStr.length();
                }
                replaceIdxArray.add(0, -1 * oldStr.length());
                replaceIdxArray.add(strValue.length());
                for (int i = 0; i < replaceIdxArray.size() - 1; ++i) {
                    int from = (Integer)replaceIdxArray.get(i) + oldStr.length();
                    int to = (Integer)replaceIdxArray.get(i + 1);
                    sb.append(strValue.substring(from, to));
                    if (i + 1 == replaceIdxArray.size() - 1) break;
                    sb.append(newStr);
                }
                strValue = sb.toString();
            }
            return strValue;
        }
    }

    public static class FIND
    extends AbstractFunctionExpr {
        public FIND() {
            super("FIND");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_STRING_STRING, PARAMS_STRING_STRING_NUMBER);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String term = this.getStringValue(this.getSubExprs()[0], ctx);
            String withinText = this.getStringValue(this.getSubExprs()[1], ctx);
            int startFrom = this.getParamIntValueUseDefaultIfNotExist(ctx, 2, 1);
            if (startFrom <= 0) {
                throw ExecuteException.negativeOrZeroNumberException(this.getSubExprs()[2]);
            }
            return new BigDecimal(withinText.indexOf(term, startFrom - 1) + 1);
        }
    }

    public static class UPPER
    extends AbstractFunctionExpr {
        public UPPER() {
            super("UPPER");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            return strValue.toUpperCase();
        }
    }

    public static class LOWER
    extends AbstractFunctionExpr {
        public LOWER() {
            super("LOWER");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            return strValue.toLowerCase();
        }
    }

    public static class TRIM
    extends AbstractFunctionExpr {
        public TRIM() {
            super("TRIM");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            return strValue.trim();
        }
    }

    public static class RIGHT
    extends AbstractFunctionExpr {
        public RIGHT() {
            super("RIGHT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            int length = this.getIntValue(this.getSubExprs()[1], ctx);
            if (length <= 0) {
                throw ExecuteException.negativeOrZeroNumberException(this);
            }
            length = Math.min(strValue.length(), length);
            return strValue.substring(strValue.length() - length, strValue.length());
        }
    }

    public static class MID
    extends AbstractFunctionExpr {
        public MID() {
            super("MID");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_NUMBER_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String originalString = this.getStringValue(this.getSubExprs()[0], ctx);
            int start = this.getIntValue(this.getSubExprs()[1], ctx) - 1;
            int length = this.getIntValue(this.getSubExprs()[2], ctx);
            int endIdx = Math.min(originalString.length(), start + length);
            if (start < 0 || endIdx < 0) {
                throw ExecuteException.negativeOrZeroNumberException(this.getSubExprs()[1]);
            }
            if (start >= originalString.length()) {
                return "";
            }
            return originalString.substring(start, endIdx);
        }
    }

    public static class LEFT
    extends AbstractFunctionExpr {
        public LEFT() {
            super("LEFT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int length;
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            boolean lengthParamGiven = this.getSubExprs().length == 2;
            int n = length = lengthParamGiven ? this.getIntValue(this.getSubExprs()[1], ctx) : 1;
            if (length <= 0) {
                throw ExecuteException.negativeOrZeroNumberException(this);
            }
            length = Math.min(strValue.length(), length);
            return strValue.substring(0, length);
        }
    }

    public static class LEN
    extends AbstractFunctionExpr {
        public LEN() {
            super("LEN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_STRING});
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            String strValue = this.getStringValue(this.getSubExprs()[0], ctx);
            return new BigDecimal(strValue.length());
        }
    }
}

