/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.init;

import com.kingdee.bos.qing.common.extension.api.IQingInitializeService;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionConfig;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionLoader;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Iterator;
import java.util.List;

public class QingInitializeHelper {
    private static volatile boolean isStarted = false;
    private static String QING_INITIALIZE_SERVICE_KEY = "QING_SERVICE_INITIALIZER";

    private QingInitializeHelper() {
    }

    public static boolean isInitializationFinished() {
        return isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeOnStart() {
        if (isStarted) {
            return;
        }
        Iterator initializeServiceListIterator = null;
        Class<QingInitializeHelper> clazz = QingInitializeHelper.class;
        synchronized (QingInitializeHelper.class) {
            try {
                QingExtensionConfig extensionConfig;
                QingExtensionLoader loader;
                List initializeServiceList;
                if (isStarted) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                String initialiseServiceKey = System.getProperty("qing.initialize.service.key");
                if (StringUtils.isEmpty(initialiseServiceKey)) {
                    initialiseServiceKey = QING_INITIALIZE_SERVICE_KEY;
                }
                if ((initializeServiceList = (loader = QingExtensionLoader.getExtensionLoader(extensionConfig = new QingExtensionConfig(IQingInitializeService.class))).getAllExtensions(initialiseServiceKey)) != null) {
                    initializeServiceListIterator = initializeServiceList.iterator();
                    while (initializeServiceListIterator.hasNext()) {
                        IQingInitializeService internalInitializeService = (IQingInitializeService)initializeServiceListIterator.next();
                        try {
                            internalInitializeService.initialize();
                            LogUtil.info("QingInitializeService " + internalInitializeService.getClass() + " success.");
                        }
                        catch (Throwable e) {
                            LogUtil.error("QingInitializeService " + internalInitializeService.getClass() + " failed.", e);
                        }
                        finally {
                            initializeServiceListIterator.remove();
                        }
                    }
                }
            }
            catch (Throwable e) {
                LogUtil.error(e.getMessage(), e);
            }
            isStarted = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

