/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.trace;

import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TraceSpansCache;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MessageDigestUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class TraceSpansCacheUtil {
    private static final String TRACE_SPANS_CACHE_TAG_LOCK_KEY = "TRACE_SPANS_CACHE_TAG_LOCK_KEY_";
    private static final int LIMIT_MAX_SIZE = 10;
    private static final String KEY_PREFIX = "qing.tracespans.";
    private static ThreadLocal<String> tagTL = new ThreadLocal();

    public static void setTag(String tag) {
        tagTL.set(tag);
    }

    public static void appendToCache(TraceSpansCacheTypeEnum type, TraceSpan traceSpan) {
        TraceSpansCacheUtil.appendToCache(type, traceSpan, false, false);
    }

    public static void appendToCacheLimitMax(TraceSpansCacheTypeEnum type, TraceSpan traceSpan, boolean isKeepFirst) {
        TraceSpansCacheUtil.appendToCache(type, traceSpan, true, isKeepFirst);
    }

    public static List<TraceSpan> getCacheTraceSpans(String tag, TraceSpansCacheTypeEnum type) {
        String cacheKey = TraceSpansCacheUtil.getCacheKey(tag, type);
        TraceSpansCache traceSpansCache = QingSessionUtil.getCache(cacheKey, TraceSpansCache.class);
        if (traceSpansCache != null) {
            return traceSpansCache.getTraceSpans();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendToCache(TraceSpansCacheTypeEnum type, TraceSpan traceSpan, boolean isLimitMax, boolean isKeepFirst) {
        String tag = TraceSpansCacheUtil.getTag();
        if (StringUtils.isBlank(tag)) {
            return;
        }
        if (traceSpan == null) {
            return;
        }
        ILock lock = null;
        try {
            String method;
            String safeTag = MessageDigestUtil.getUniqueCode(tag);
            lock = LockFactory.createLock(TRACE_SPANS_CACHE_TAG_LOCK_KEY + safeTag);
            lock.lock();
            String cacheKey = TraceSpansCacheUtil.getCacheKey(tag, type);
            TraceSpansCache traceSpansCache = QingSessionUtil.getCache(cacheKey, TraceSpansCache.class);
            if (traceSpansCache == null) {
                traceSpansCache = new TraceSpansCache();
            }
            List<TraceSpan> traceSpans = traceSpansCache.getTraceSpans();
            int seriesNum = 1;
            if (!traceSpans.isEmpty()) {
                seriesNum = traceSpans.get(traceSpans.size() - 1).getSeriesNum() + 1;
            }
            traceSpan.setSeriesNum(seriesNum);
            traceSpans.add(traceSpan);
            if (isLimitMax && StringUtils.isNotBlank(method = traceSpan.getAttributeMap().get("\u7c7b\u65b9\u6cd5"))) {
                int count = 0;
                int removeIndex = 0;
                for (int i = 0; i < traceSpans.size(); ++i) {
                    TraceSpan ts = traceSpans.get(i);
                    if (!method.equals(ts.getAttributeMap().get("\u7c7b\u65b9\u6cd5"))) continue;
                    if (!isKeepFirst && ++count == 1 || isKeepFirst && count == 2) {
                        removeIndex = i;
                    }
                    if (count <= 10) continue;
                    traceSpans.remove(removeIndex);
                    break;
                }
            }
            traceSpansCache.setCacheKey(cacheKey);
            QingSessionUtil.setCache(traceSpansCache);
        }
        catch (Exception e) {
            LogUtil.error("appendToCache error", e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static String getTag() {
        return tagTL.get();
    }

    private static String getCacheKey(String tag, TraceSpansCacheTypeEnum type) {
        return KEY_PREFIX + type.name().toLowerCase() + "." + tag;
    }

    public static enum TraceSpansCacheTypeEnum {
        EXECUTE,
        JOIN;

    }
}

