/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.meta;

import com.kingdee.bos.qing.util.NameUtil;

public class DSFieldKey {
    private String _entityName;
    private String _propertyName;
    private String _fullName;

    public DSFieldKey(String entityName, String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("PropertyName must be not null.");
        }
        this._entityName = entityName;
        this._propertyName = propertyName;
    }

    public DSFieldKey(String propertyName) {
        this(null, propertyName);
    }

    public void setEntityName(String entityName) {
        this._entityName = entityName;
    }

    public String getEntityName() {
        return this._entityName;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String toFullName() {
        if (this._fullName == null) {
            this._fullName = NameUtil.encodeFullName(this._entityName, this._propertyName);
        }
        return this._fullName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DSFieldKey) {
            DSFieldKey another = (DSFieldKey)obj;
            if (this._entityName == null && another.getEntityName() == null || this._entityName != null && this._entityName.equals(another.getEntityName())) {
                return this._propertyName.equals(another.getPropertyName());
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this._entityName == null ? 0 : this._entityName.hashCode();
        hash = hash * 31 + this._propertyName.hashCode();
        return hash;
    }

    public String toString() {
        return this.toFullName();
    }
}

