/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model.graph;

import com.kingdee.bos.qing.datasource.model.graph.Edge;
import com.kingdee.bos.qing.datasource.model.graph.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class DirectedGraph<E, T> {
    private Map<E, Vertex<E, T>> vertexMap = new HashMap<E, Vertex<E, T>>();

    public Set<E> getVertexs() {
        return new HashSet<E>(this.vertexMap.keySet());
    }

    public void addVertex(E vertexData) {
        if (!this.vertexExists(vertexData)) {
            this.vertexMap.put(vertexData, new Vertex(vertexData));
        }
    }

    public void addVertexs(Collection<E> vertexDatas) {
        if (vertexDatas != null && !vertexDatas.isEmpty()) {
            for (E vertexData : vertexDatas) {
                this.addVertex(vertexData);
            }
        }
    }

    public void removeVertex(E vertexData) {
        if (this.vertexExists(vertexData)) {
            Map<E, T> to = this.edgesFrom(vertexData);
            Map<E, T> from = this.edgesTo(vertexData);
            for (E key : to.keySet()) {
                this.removeEdge(vertexData, key);
            }
            for (E key : from.keySet()) {
                this.removeEdge(key, vertexData);
            }
            this.vertexMap.remove(vertexData);
        }
    }

    public void mergeVertex(E vertexData, E mergeVertexData) {
        T data;
        E key;
        Map<E, T> to = this.edgesFrom(vertexData);
        Map<E, T> from = this.edgesTo(vertexData);
        this.removeVertex(vertexData);
        for (Map.Entry<E, T> entry : to.entrySet()) {
            key = entry.getKey();
            data = entry.getValue();
            if (key.equals(mergeVertexData)) continue;
            this.addEdge(mergeVertexData, key, data);
        }
        for (Map.Entry<E, T> entry : from.entrySet()) {
            key = entry.getKey();
            data = entry.getValue();
            if (key.equals(mergeVertexData)) continue;
            this.addEdge(key, mergeVertexData, data);
        }
    }

    public boolean vertexExists(E vertexData) {
        return this.vertexMap.containsKey(vertexData);
    }

    public void addEdge(E fromVertexData, E toVertexData, T edgedata) {
        Edge<E, T> tempEdge;
        Vertex<E, T> fromVertex = this.vertexMap.get(fromVertexData);
        Vertex<E, T> toVertex = this.vertexMap.get(toVertexData);
        if (fromVertex == null) {
            throw new NoSuchElementException("The start Vertex does not exist in the graph.");
        }
        if (toVertex == null) {
            throw new NoSuchElementException("The destination Vertex does not exist in the graph.");
        }
        if (this.edgeExists(fromVertexData, toVertexData)) {
            return;
        }
        Edge<E, T> edge = new Edge<E, T>(edgedata, fromVertex, toVertex);
        if (fromVertex.getFirstOut() == null) {
            fromVertex.setFirstOut(edge);
        } else {
            tempEdge = fromVertex.getFirstOut();
            edge.setNextSameFromVertex(tempEdge);
            fromVertex.setFirstOut(edge);
        }
        fromVertex.addOutDegree();
        if (toVertex.getFirstIn() == null) {
            toVertex.setFirstIn(edge);
        } else {
            tempEdge = toVertex.getFirstIn();
            edge.setNextSameToVertex(tempEdge);
            toVertex.setFirstIn(edge);
        }
        toVertex.addInDegree();
    }

    public void removeEdge(E fromVertexData, E toVertexData) {
        Edge edgeInHead;
        Vertex<E, T> fromVertex = this.vertexMap.get(fromVertexData);
        Vertex<E, T> toVertex = this.vertexMap.get(toVertexData);
        if (fromVertex == null) {
            throw new NoSuchElementException("The start Vertex does not exist in the graph.");
        }
        if (toVertex == null) {
            throw new NoSuchElementException("The destination Vertex does not exist in the graph.");
        }
        if (!this.edgeExists(fromVertexData, toVertexData)) {
            return;
        }
        Edge edgeOutHead = fromVertex.getFirstOut();
        if (edgeOutHead != null) {
            Vertex<E, T> toVertexTemp = edgeOutHead.getToVertex();
            if (toVertex.getData().equals(toVertexTemp.getData())) {
                fromVertex.setFirstOut(edgeOutHead.getNextSameFromVertex());
                edgeOutHead.setNextSameFromVertex(null);
            } else {
                Edge edgeOutCurrent;
                Edge edgeOutPreview = null;
                for (edgeOutCurrent = edgeOutHead; edgeOutCurrent != null; edgeOutCurrent = edgeOutCurrent.getNextSameFromVertex()) {
                    toVertexTemp = edgeOutCurrent.getToVertex();
                    if (toVertex.getData().equals(toVertexTemp.getData())) break;
                    edgeOutPreview = edgeOutCurrent;
                }
                if (edgeOutCurrent != null) {
                    if (edgeOutPreview != null) {
                        edgeOutPreview.setNextSameFromVertex(edgeOutCurrent.getNextSameFromVertex());
                    }
                    edgeOutCurrent.setNextSameFromVertex(null);
                } else if (edgeOutPreview != null) {
                    edgeOutPreview.setNextSameFromVertex(null);
                }
            }
            fromVertex.minusOutDegree();
        }
        if ((edgeInHead = toVertex.getFirstIn()) != null) {
            Vertex<E, T> fromVertexTemp = edgeInHead.getFromVertex();
            if (fromVertex.getData().equals(fromVertexTemp.getData())) {
                toVertex.setFirstIn(edgeInHead.getNextSameToVertex());
                edgeInHead.setNextSameFromVertex(null);
            } else {
                Edge edgeInCurrent;
                Edge edgeInPreview = null;
                for (edgeInCurrent = edgeInHead; edgeInCurrent != null; edgeInCurrent = edgeInCurrent.getNextSameToVertex()) {
                    fromVertexTemp = edgeInCurrent.getFromVertex();
                    if (fromVertex.getData().equals(fromVertexTemp.getData())) break;
                    edgeInPreview = edgeInCurrent;
                }
                if (edgeInCurrent != null) {
                    if (edgeInPreview != null) {
                        edgeInPreview.setNextSameToVertex(edgeInCurrent.getNextSameToVertex());
                    }
                    edgeInCurrent.setNextSameToVertex(null);
                } else {
                    edgeInPreview.setNextSameFromVertex(null);
                }
            }
            toVertex.minusInDegree();
        }
    }

    public boolean edgeExists(E fromVertexData, E toVertexData) {
        return this.getEdge(fromVertexData, toVertexData) != null;
    }

    public T getEdge(E fromVertexData, E toVertexData) {
        Vertex<E, T> fromVertex = this.vertexMap.get(fromVertexData);
        for (Edge<E, T> edgeOut = fromVertex.getFirstOut(); edgeOut != null; edgeOut = edgeOut.getNextSameFromVertex()) {
            Vertex<E, T> toVertex = edgeOut.getToVertex();
            if (!toVertexData.equals(toVertex.getData())) continue;
            return edgeOut.getData();
        }
        return null;
    }

    public int getInDegree(E vertexData) {
        Vertex<E, T> vertex = this.vertexMap.get(vertexData);
        if (vertex == null) {
            throw new NoSuchElementException("Source Vertex does not exist.");
        }
        return vertex.getInDegree();
    }

    public int getOutDegree(E vertexData) {
        Vertex<E, T> vertex = this.vertexMap.get(vertexData);
        if (vertex == null) {
            throw new NoSuchElementException("Source Vertex does not exist.");
        }
        return vertex.getOutDegree();
    }

    public Map<E, T> edgesFrom(E fromVertexData) {
        if (!this.vertexExists(fromVertexData)) {
            return Collections.emptyMap();
        }
        Vertex<E, T> fromVertex = this.vertexMap.get(fromVertexData);
        LinkedHashMap<E, T> result = new LinkedHashMap<E, T>();
        for (Edge<E, T> edgeOut = fromVertex.getFirstOut(); edgeOut != null; edgeOut = edgeOut.getNextSameFromVertex()) {
            Vertex<E, T> toVertex = edgeOut.getToVertex();
            result.put(toVertex.getData(), edgeOut.getData());
        }
        return Collections.unmodifiableMap(result);
    }

    public Set<T> getEdges() {
        TreeSet<T> allRelationSet = new TreeSet<T>();
        Set<E> allEntityNames = this.getVertexs();
        for (E entityName : allEntityNames) {
            allRelationSet.addAll(this.edgesTo(entityName).values());
            allRelationSet.addAll(this.edgesFrom(entityName).values());
        }
        return allRelationSet;
    }

    public Map<E, T> edgesTo(E toVertexData) {
        if (!this.vertexExists(toVertexData)) {
            return Collections.emptyMap();
        }
        Vertex<E, T> toVertex = this.vertexMap.get(toVertexData);
        HashMap<E, T> result = new HashMap<E, T>();
        for (Edge<E, T> edgeIn = toVertex.getFirstIn(); edgeIn != null; edgeIn = edgeIn.getNextSameToVertex()) {
            Vertex<E, T> fromVertex = edgeIn.getFromVertex();
            result.put(fromVertex.getData(), edgeIn.getData());
        }
        return Collections.unmodifiableMap(result);
    }

    private DirectedGraph<E, T> buildSubGraph(DirectedGraph<E, T> subGraph, E oneVertexData, Set<E> allVertexData) {
        Map<E, T> from = this.edgesFrom(oneVertexData);
        for (Map.Entry<E, T> entry : from.entrySet()) {
            E key = entry.getKey();
            if (!allVertexData.contains(key)) continue;
            T value = entry.getValue();
            if (!subGraph.vertexExists(key)) {
                subGraph.addVertex(key);
                subGraph.addEdge(oneVertexData, key, value);
                this.buildSubGraph(subGraph, key, allVertexData);
                continue;
            }
            subGraph.addEdge(oneVertexData, key, value);
        }
        Map<E, T> to = this.edgesTo(oneVertexData);
        for (Map.Entry<E, T> entry : to.entrySet()) {
            E key = entry.getKey();
            if (!allVertexData.contains(key)) continue;
            T value = entry.getValue();
            if (!subGraph.vertexExists(key)) {
                subGraph.addVertex(key);
                subGraph.addEdge(key, oneVertexData, value);
                this.buildSubGraph(subGraph, key, allVertexData);
                continue;
            }
            subGraph.addEdge(key, oneVertexData, value);
        }
        return subGraph;
    }

    public List<DirectedGraph<E, T>> getSubGraph() {
        HashSet<E> allVertexData = new HashSet<E>(this.vertexMap.keySet());
        ArrayList<DirectedGraph<DirectedGraph<E, T>, T>> subGraphs = new ArrayList<DirectedGraph<DirectedGraph<E, T>, T>>(allVertexData.size());
        while (!allVertexData.isEmpty()) {
            DirectedGraph subGraph = new DirectedGraph();
            Object oneVertexData = allVertexData.iterator().next();
            subGraph.addVertex(oneVertexData);
            DirectedGraph<E, T> sub = this.buildSubGraph(subGraph, oneVertexData, allVertexData);
            allVertexData.removeAll(sub.getVertexs());
            subGraphs.add(sub);
        }
        return subGraphs;
    }

    public DirectedGraph<E, T> getSelectedVertexMinConnectedSubGrapgh(Set<E> selectedVertexs) {
        DirectedGraph<E, T> copyGraph = this.copy();
        boolean needTOLoop = true;
        block0: while (needTOLoop) {
            needTOLoop = false;
            Set<E> allVertexs = copyGraph.getVertexs();
            allVertexs.removeAll(selectedVertexs);
            for (E vertexData : allVertexs) {
                int outDegree;
                int inDegree = copyGraph.getInDegree(vertexData);
                if (inDegree + (outDegree = copyGraph.getOutDegree(vertexData)) <= 1) {
                    copyGraph.removeVertex(vertexData);
                    needTOLoop = true;
                    continue block0;
                }
                if (inDegree + outDegree != 2) continue;
                HashSet<E> relatedNode = new HashSet<E>();
                relatedNode.addAll(copyGraph.edgesTo(vertexData).keySet());
                relatedNode.addAll(copyGraph.edgesFrom(vertexData).keySet());
                if (relatedNode.size() >= 2) continue;
                copyGraph.removeVertex(vertexData);
                needTOLoop = true;
                continue block0;
            }
        }
        return copyGraph;
    }

    public DirectedGraph<E, T> copy() {
        DirectedGraph<E, T> copyGraph = new DirectedGraph<E, T>();
        Set<E> allVertexsData = this.getVertexs();
        for (E copyVertexData : allVertexsData) {
            copyGraph.addVertex(copyVertexData);
        }
        for (E copyVertexData : allVertexsData) {
            Map<E, T> to = this.edgesFrom(copyVertexData);
            for (Map.Entry<E, T> entry : to.entrySet()) {
                E copyToVertexData = entry.getKey();
                T edgeData = entry.getValue();
                copyGraph.addEdge(copyVertexData, copyToVertexData, edgeData);
            }
        }
        return copyGraph;
    }

    private Set<E> broadFindEdgTo(E target) {
        Map<E, T> from = this.edgesTo(target);
        HashSet<E> allStarts = new HashSet<E>();
        LinkedList queue = new LinkedList(from.keySet());
        HashSet visited = new HashSet(queue.size());
        visited.add(target);
        while (!queue.isEmpty()) {
            Object vertex = queue.poll();
            visited.add(vertex);
            HashSet temp = new HashSet(this.edgesTo(vertex).keySet());
            temp.removeAll(visited);
            if (!temp.isEmpty()) {
                for (Object vt : temp) {
                    queue.offer(vt);
                }
                continue;
            }
            allStarts.add(vertex);
        }
        if (allStarts.isEmpty()) {
            allStarts.add(target);
        }
        return allStarts;
    }

    private E getNotVisitedVertex(Set<E> visited) {
        for (E vertex : this.vertexMap.keySet()) {
            if (visited.contains(vertex)) continue;
            return vertex;
        }
        return null;
    }

    public boolean checkClosedCycle() {
        DirectedGraph<E, T> copyGraph = this.copy();
        HashSet visited = new HashSet();
        Set<E> allVertexs = copyGraph.getVertexs();
        while (!allVertexs.isEmpty()) {
            E vertex = allVertexs.iterator().next();
            if (!this.dfsCheckClosedCycle(copyGraph, allVertexs, vertex, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean dfsCheckClosedCycle(DirectedGraph<E, T> graph, Set<E> allVertexs, E vertex, Set<E> visited) {
        if (!visited.add(vertex)) {
            return true;
        }
        allVertexs.removeAll(visited);
        Map<E, T> from = graph.edgesFrom(vertex);
        Set<Map.Entry<E, T>> fromEntries = from.entrySet();
        for (Map.Entry<E, T> fromEntry : fromEntries) {
            E toVertex = fromEntry.getKey();
            if (graph.edgeExists(toVertex, vertex)) {
                graph.removeEdge(toVertex, vertex);
            }
            graph.removeEdge(vertex, toVertex);
            if (!this.dfsCheckClosedCycle(graph, allVertexs, toVertex, visited)) continue;
            return true;
        }
        Map<E, T> to = graph.edgesTo(vertex);
        Set<Map.Entry<E, T>> toEntries = to.entrySet();
        for (Map.Entry<E, T> toEntry : toEntries) {
            E fromVertex = toEntry.getKey();
            graph.removeEdge(fromVertex, vertex);
            if (!this.dfsCheckClosedCycle(graph, allVertexs, fromVertex, visited)) continue;
            return true;
        }
        return false;
    }
}

