/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.util;

import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.DetailCombinationFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.util.DateUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterUtil {
    public static boolean isMatchFilter(Set<IPushdownFilter> filters, Map<String, ?> rowValues) {
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        for (IPushdownFilter filter : filters) {
            if (filter instanceof AbstractUnderDSFilter) {
                String fieldFullName = ((AbstractUnderDSFilter)filter).getField().toFullName();
                Object value = null;
                if (rowValues != null) {
                    value = rowValues.get(fieldFullName);
                }
                if (FilterUtil.isMatchFilter((AbstractUnderDSFilter)filter, value)) continue;
                return false;
            }
            if (filter instanceof DetailCombinationFilter) {
                if (FilterUtil.isMatchFilter((DetailCombinationFilter)filter, rowValues)) continue;
                return false;
            }
            throw new RuntimeException("Something must be wrong.");
        }
        return true;
    }

    public static boolean isMatchFilter(AbstractUnderDSFilter filter, Object value) {
        if (filter instanceof UnderDSDiscreteFilter) {
            return FilterUtil.isMatch((UnderDSDiscreteFilter)filter, value);
        }
        if (filter instanceof UnderDSContinuousFilter) {
            return FilterUtil.isMatch((UnderDSContinuousFilter)filter, value);
        }
        throw new RuntimeException("Modify here.");
    }

    private static boolean isMatch(UnderDSDiscreteFilter filter, Object value) {
        boolean isAccept;
        if (filter.getPartValue() != null && value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            value = UnderDSDiscreteFilter.PartValue.DATE_EXACT == filter.getPartValue() ? String.valueOf(calendar.getTimeInMillis()) : DateUtil.getPartValue(filter.getPartValue(), calendar, filter.getFiscalYearStart());
        }
        if (filter.isFullValue() && filter.isExclude() || filter.getSelected().isEmpty() && !filter.isExclude()) {
            return false;
        }
        boolean isContains = false;
        isContains = value instanceof BigDecimal ? filter.getSelectedBigDecimal().contains(value) : filter.getSelected().contains(value);
        boolean bl = isAccept = filter.isExclude() && !isContains || !filter.isExclude() && isContains;
        return isAccept;
    }

    private static boolean isMatch(UnderDSContinuousFilter filter, Object value) {
        if (value == null && !filter.isContainNull()) {
            return false;
        }
        if (!(value instanceof Comparable)) {
            return false;
        }
        Comparable v = (Comparable)value;
        if (filter.getFloor() != null && v.compareTo(filter.getFloor()) < 0) {
            return false;
        }
        return filter.getCeiling() == null || v.compareTo(filter.getCeiling()) <= 0;
    }

    private static boolean isMatchFilter(DetailCombinationFilter filter, Map<String, ?> rowValues) {
        List<DSFieldKey> fields = filter.getFields();
        int fieldSize = fields.size();
        Set<List<String>> filterItems = filter.getItems();
        for (List<String> filterItem : filterItems) {
            boolean isFilterItemMatch = true;
            for (int i = 0; i < fieldSize; ++i) {
                boolean isFieldValueEqual;
                String comparingValue = filterItem.get(i);
                DSFieldKey dsFieldKey = fields.get(i);
                Object value = rowValues.get(dsFieldKey.toFullName());
                boolean bl = isFieldValueEqual = value == null && comparingValue == null || value != null && value.equals(comparingValue);
                if (isFieldValueEqual) continue;
                isFilterItemMatch = false;
                break;
            }
            if (!isFilterItemMatch) continue;
            return true;
        }
        return false;
    }
}

