/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.exceptionlog.domain;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.exceptionlog.dao.ExceptionLogDao;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import java.sql.SQLException;

public class ExceptionLogDomain {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private ExceptionLogDao exceptionLogDao;

    public ExceptionLogDomain(ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    private ExceptionLogDao getExceptionLogDao() {
        if (this.exceptionLogDao == null) {
            this.exceptionLogDao = new ExceptionLogDao(this.dbExcuter);
        }
        return this.exceptionLogDao;
    }

    public void insert(ExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getExceptionLogDao().insert(exceptionLog);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public ExceptionLog selectByBizIdAndBizType(String bizId, ExceptionLogBizTypeEnum bizTypeEnum) throws AbstractQingIntegratedException, SQLException {
        return this.getExceptionLogDao().selectByBizIdAndBizType(bizId, bizTypeEnum);
    }
}

