/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.util.Date;

public class QingFileWriterWraper
implements IQingFileWriter {
    private IFileResourceService _resourceService;
    private IQingFileWriter _qingFileWriter;
    private IQingFileVisitor _qingFile;
    private QingFileResourceInfo _resourceInfo;
    private QingOutputStream _outputStream;

    public QingFileWriterWraper(IFileResourceService resourceService, QingFileResourceInfo resourceInfo, IQingFileVisitor qingFile, IQingFileWriter qingFileWriter) {
        this._resourceService = resourceService;
        this._resourceInfo = resourceInfo;
        this._qingFileWriter = qingFileWriter;
        this._qingFile = qingFile;
    }

    @Override
    public QingOutputStream getOutputStream() throws IOException {
        this._outputStream = this._qingFileWriter.getOutputStream();
        return this._outputStream;
    }

    @Override
    public void close(Exception e) {
        this._qingFileWriter.close(e);
        if (e == null && this._resourceService != null) {
            QingFileInfo fileInfo = new QingFileInfo();
            fileInfo.setName(this._qingFile.getName());
            fileInfo.setFileType(this._qingFile.getFileType());
            fileInfo.setFileSize(this._outputStream.getFileSize());
            fileInfo.setCreateDate(new Date());
            if (this._resourceInfo != null) {
                try {
                    this._resourceService.saveFile(fileInfo, this._resourceInfo);
                }
                catch (Exception e1) {
                    LogUtil.error(e1.getMessage(), e1);
                }
            }
        }
    }
}

