/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class Updatable {
    private static final String TOKEN_PATH = "qing.version";
    protected long version;
    protected static String QINGSTORAGE_PATH = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator);
    protected static final String PERSISTENTDIR = "QingPersistent";
    protected static final String TEMPDIR = "QingTemp";

    public abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToken() {
        FileOutputStream fos = null;
        File fileDir = new File(QINGSTORAGE_PATH);
        fileDir.mkdirs();
        String tokenPath = QINGSTORAGE_PATH + TOKEN_PATH;
        File tokenFile = new File(tokenPath);
        if (tokenFile.exists()) {
            tokenFile.delete();
        }
        try {
            tokenFile.createNewFile();
            byte[] buffer = this.longToByteArr(this.version);
            fos = new FileOutputStream(tokenFile);
            fos.write(buffer);
        }
        catch (IOException e) {
            try {
                LogUtil.error("update fs version token failed", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(fos);
                throw throwable;
            }
            CloseUtil.close(fos);
        }
        CloseUtil.close(fos);
    }

    protected void setVersion(long version) {
        this.version = version;
    }

    private byte[] longToByteArr(long param) {
        byte[] arr = new byte[8];
        for (int i = 0; i < 8; ++i) {
            arr[i] = (byte)(param & 0xFFL);
            param >>= 8;
        }
        return arr;
    }
}

