/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.Updatable;
import com.kingdee.bos.qing.filesystem.manager.localimpl.updater.FileUpdater1;
import com.kingdee.bos.qing.filesystem.manager.localimpl.updater.FileUpdater2;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;

class UpdateHelper {
    private static LinkedList<Updatable> updaters = new LinkedList();
    private static final String TOKEN_PATH = "qing.version";
    private static String QINGSTORAGE_PATH;

    UpdateHelper() {
    }

    public void update() {
        byte[] token = UpdateHelper.getVersionToken();
        int pos = UpdateHelper.getUpdaterRank(token) + 1;
        if (pos < 0 || pos > updaters.size()) {
            pos = 0;
        }
        while (pos < updaters.size()) {
            updaters.get(pos).update();
            updaters.get(pos).updateToken();
            ++pos;
        }
    }

    private static int getUpdaterRank(byte[] arr) {
        int pos = 0;
        for (int i = 0; i < arr.length; ++i) {
            byte part = arr[i];
            for (int j = 0; j < 8 && (part & 1) != 1; ++j) {
                part = (byte)(part >> 1);
                ++pos;
            }
            if ((part & 1) == 1) break;
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getVersionToken() {
        byte[] arr = new byte[8];
        FileInputStream fis = null;
        String absolutePath = QINGSTORAGE_PATH + TOKEN_PATH;
        File file = new File(absolutePath);
        if (file.exists() && file.length() == 8L) {
            try {
                fis = new FileInputStream(file);
                fis.read(arr);
            }
            catch (IOException e) {
                try {
                    LogUtil.error("read version token failed", e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close(fis);
                    throw throwable;
                }
                CloseUtil.close(fis);
            }
            CloseUtil.close(fis);
        }
        return arr;
    }

    static {
        updaters.add(new FileUpdater1());
        updaters.add(new FileUpdater2());
        QINGSTORAGE_PATH = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator);
    }
}

