/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl.updater;

import com.kingdee.bos.qing.filesystem.manager.localimpl.DirUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.Updatable;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import java.io.File;

public class FileUpdater1
extends Updatable {
    private static final long VERSION = 1L;

    @Override
    public void update() {
        FileUpdater1.movePersistentFiles();
        FileUpdater1.cleanOldTemp();
    }

    public FileUpdater1() {
        super.setVersion(1L);
    }

    private static void movePersistentFiles() {
        String rootDirPath = QINGSTORAGE_PATH;
        String oldUploadPath = rootDirPath + "user-upload";
        String newUploadPath = rootDirPath + "QingPersistent" + File.separator + QingPersistentFileType.DATAMODELING_DS.getSubFolder();
        FileUpdater1.movePersistentFile(oldUploadPath, newUploadPath);
        String oldExtractPath = rootDirPath + "data-modeling";
        String newExtractPath = rootDirPath + "QingPersistent" + File.separator + QingPersistentFileType.DATAMODELING_QS.getSubFolder();
        FileUpdater1.movePersistentFile(oldExtractPath, newExtractPath);
        String oldFormPath = rootDirPath + "form-store";
        String newFormPath = rootDirPath + "QingPersistent" + File.separator + QingPersistentFileType.EMBEDDED_PUB_QS.getSubFolder();
        FileUpdater1.movePersistentFile(oldFormPath, newFormPath);
        String oldDemoPath = rootDirPath + "qing_demos";
        String newDemoPath = rootDirPath + "QingPersistent" + File.separator + "qing_demos";
        FileUpdater1.movePersistentFile(oldDemoPath, newDemoPath);
    }

    private static void movePersistentFile(String oldDirName, String newDirName) {
        File dir = new File(oldDirName);
        File newDir = new File(newDirName);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        newDir.mkdirs();
        File[] files = dir.listFiles();
        int movedNum = 0;
        for (File file : files) {
            String name = file.getName();
            if (!file.renameTo(new File(newDirName + File.separator + name))) continue;
            ++movedNum;
        }
        if (movedNum == files.length) {
            dir.delete();
        }
    }

    private static void cleanOldTemp() {
        File[] files;
        String rootDirPath = QINGSTORAGE_PATH;
        File rootDir = new File(rootDirPath);
        if (!rootDir.exists()) {
            return;
        }
        for (File file : files = rootDir.listFiles()) {
            if (file.isDirectory()) {
                String fileName = file.getName();
                if (fileName.equals("QingPersistent") || fileName.equals("QingTemp")) continue;
                DirUtil.delFolder(rootDirPath + fileName, null);
                continue;
            }
            file.delete();
        }
    }
}

