/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.manage;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.msgbus.dispatch.MessageDispatcher;
import com.kingdee.bos.qing.msgbus.model.external.ExternalContinuousFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalDateRangeFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalDiscreteFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalFilterType;
import com.kingdee.bos.qing.msgbus.model.message.FilterActionMessage;
import com.kingdee.bos.qing.msgbus.model.message.RefreshActionMessage;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackage;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

public class MessageManager {
    private QingContext qingContext;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public int receiveMsgPack(MsgPackage msgPack) {
        String packageId = this.cacheMsgPack(msgPack);
        MessageDispatcher msgDispatcher = new MessageDispatcher(this.qingContext);
        msgDispatcher.dispatch(packageId);
        return 2000;
    }

    public void receiveFilterAction(List<String> receiverNodeIds, String filterType, Object ... params) {
        FilterActionMessage message = new FilterActionMessage();
        ExternalFilterItem discreteFilterItem = this.createExternalFilterItem(filterType, params);
        message.setExternalFilterItem(discreteFilterItem);
        MsgPackage msgPackage = new MsgPackage();
        msgPackage.setMessage(message);
        msgPackage.setReceiverIds(receiverNodeIds);
        this.receiveMsgPack(msgPackage);
    }

    public void receiveRefreshAction(List<String> receiverNodeIds) {
        RefreshActionMessage message = new RefreshActionMessage();
        MsgPackage msgPackage = new MsgPackage();
        msgPackage.setMessage(message);
        msgPackage.setReceiverIds(receiverNodeIds);
        this.receiveMsgPack(msgPackage);
    }

    private ExternalFilterItem createExternalFilterItem(String filterType, Object[] params) {
        ExternalFilterType type = ExternalFilterType.valueOf(filterType);
        switch (type) {
            case discrete: {
                return this.createDiscreteFilterItem(params);
            }
            case continuous: {
                return this.createContinuousFilterItem(params);
            }
            case dateRange: {
                return this.createDateRangeFilterItem(params);
            }
        }
        return new ExternalDiscreteFilterItem();
    }

    private ExternalDiscreteFilterItem createDiscreteFilterItem(Object[] params) {
        ExternalDiscreteFilterItem discreteFilterItem = new ExternalDiscreteFilterItem();
        try {
            discreteFilterItem.setFieldName((String)params[0]);
            discreteFilterItem.setValues((List)params[1]);
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus create discrete filter item failed", e);
        }
        return discreteFilterItem;
    }

    private ExternalDateRangeFilterItem createDateRangeFilterItem(Object[] params) {
        ExternalDateRangeFilterItem filterItem = new ExternalDateRangeFilterItem();
        try {
            filterItem.setFieldName((String)params[0]);
            filterItem.setStartDate((Long)params[1]);
            filterItem.setEndDate((Long)params[2]);
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus create date range filter item failed", e);
        }
        return filterItem;
    }

    private ExternalContinuousFilterItem createContinuousFilterItem(Object[] params) {
        ExternalContinuousFilterItem continuousFilterItem = new ExternalContinuousFilterItem();
        try {
            continuousFilterItem.setFieldName((String)params[0]);
            continuousFilterItem.setFloor((BigDecimal)params[1]);
            continuousFilterItem.setCeiling((BigDecimal)params[2]);
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus create date range filter item failed", e);
        }
        return continuousFilterItem;
    }

    private String cacheMsgPack(MsgPackage msgPack) {
        String packageId = UUID.randomUUID().toString();
        msgPack.setCacheKey(packageId);
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        qingSession.setCache(msgPack);
        return packageId;
    }
}

