/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.model;

import com.kingdee.bos.qing.msgbus.model.external.ExternalContinuousFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalDateRangeFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalDiscreteFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalFilterItem;
import com.kingdee.bos.qing.msgbus.model.external.ExternalFilterType;
import com.kingdee.bos.qing.msgbus.model.message.CustomMessage;
import com.kingdee.bos.qing.msgbus.model.message.FilterActionMessage;
import com.kingdee.bos.qing.msgbus.model.message.Message;
import com.kingdee.bos.qing.msgbus.model.message.MessageType;
import com.kingdee.bos.qing.util.JsonUtil;

public class MsgBusDecoder {
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();

    public static <T> T decode(String jsonString, Class<T> clz) {
        return JsonUtil.decodeFromString(customJsonParser, jsonString, clz);
    }

    static {
        customJsonParser.addCustomDecoder(Message.class, new MessageDecoder());
        customJsonParser.addCustomDecoder(ExternalFilterItem.class, new ExternalFilterItemDecoder());
    }

    private static class ExternalFilterItemDecoder
    extends JsonUtil.AbstractJsonDecoder<ExternalFilterItem> {
        private ExternalFilterItemDecoder() {
        }

        @Override
        protected ExternalFilterItem decode(JsonUtil.AbstractJsonDecoder.Json json) {
            ExternalFilterType type = ExternalFilterType.valueOf(json.getAttrValue("type"));
            switch (type) {
                case discrete: {
                    return (ExternalFilterItem)this.fromJson(json, ExternalDiscreteFilterItem.class);
                }
                case dateRange: {
                    return (ExternalFilterItem)this.fromJson(json, ExternalDateRangeFilterItem.class);
                }
                case continuous: {
                    return (ExternalFilterItem)this.fromJson(json, ExternalContinuousFilterItem.class);
                }
            }
            return null;
        }
    }

    private static class MessageDecoder
    extends JsonUtil.AbstractJsonDecoder<Message> {
        private MessageDecoder() {
        }

        @Override
        protected Message decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("msgType")) {
                String msgType = json.getAttrValue("msgType");
                MessageType type = MessageType.valueOf(msgType);
                switch (type) {
                    case filterAction: {
                        return (Message)this.fromJson(json, FilterActionMessage.class);
                    }
                    case customEvent: {
                        return (Message)this.fromJson(json, CustomMessage.class);
                    }
                }
            }
            return (Message)this.fromJson(json, CustomMessage.class);
        }
    }
}

