/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class LogUtil {
    private static ILogger _impl;

    public static boolean isDebugEnabled() {
        return LogUtil.getImpl().isDebugEnabled();
    }

    public static void debug(String message) {
        LogUtil.getImpl().debug(message);
    }

    public static void debug(String message, Throwable ex) {
        if (ex != null) {
            LogUtil.getImpl().debug(message, ex);
        } else {
            LogUtil.getImpl().debug(message);
        }
    }

    public static void info(String message) {
        LogUtil.getImpl().info(message);
    }

    public static void error(String message) {
        LogUtil.getImpl().error(message);
    }

    public static void error(Throwable ex) {
        if (ex instanceof AbstractQingException && ((AbstractQingException)ex).isExpectedStatus()) {
            return;
        }
        if (ex != null) {
            LogUtil.getImpl().error(ex);
        }
    }

    public static void error(String message, Throwable ex) {
        if (ex instanceof AbstractQingException && ((AbstractQingException)ex).isExpectedStatus()) {
            return;
        }
        if (ex != null) {
            LogUtil.getImpl().error(message, ex);
        } else {
            LogUtil.getImpl().error(message);
        }
    }

    public static void warn(String message) {
        LogUtil.getImpl().warn(message);
    }

    public static void setImpl(ILogger impl) {
        _impl = impl;
    }

    private static ILogger getImpl() {
        if (_impl == null) {
            _impl = new DefaultLogger();
        }
        return _impl;
    }

    public static class DebugLogger
    implements ILogger {
        private PrintStream out;
        private PrintStream err;
        private Level _level;

        public DebugLogger(PrintStream out, PrintStream err) {
            this(out, err, Level.DEBUG);
        }

        public DebugLogger(PrintStream out, PrintStream err, Level level) {
            this.out = out;
            this.err = err;
            this._level = level;
        }

        @Override
        public boolean isDebugEnabled() {
            return this._level == Level.DEBUG;
        }

        @Override
        public void debug(String message) {
            if (this._level.ordinal() >= Level.DEBUG.ordinal()) {
                this.out.println(message);
            }
        }

        @Override
        public void debug(String message, Throwable ex) {
            if (this._level.ordinal() >= Level.DEBUG.ordinal()) {
                this.out.println(message);
                ex.printStackTrace(this.err);
            }
        }

        @Override
        public void info(String message) {
            if (this._level.ordinal() >= Level.INFO.ordinal()) {
                this.out.println(message);
            }
        }

        @Override
        public void error(String message) {
            if (this._level.ordinal() >= Level.ERROR.ordinal()) {
                this.err.println(message);
            }
        }

        @Override
        public void error(String message, Throwable ex) {
            if (this._level.ordinal() >= Level.ERROR.ordinal()) {
                this.err.println(message);
                ex.printStackTrace(this.err);
            }
        }

        @Override
        public void error(Throwable ex) {
            if (this._level.ordinal() >= Level.ERROR.ordinal()) {
                ex.printStackTrace(this.err);
            }
        }

        @Override
        public void warn(String message) {
            if (this._level.ordinal() >= Level.WARN.ordinal()) {
                this.out.println(message);
            }
        }

        public static enum Level {
            ERROR,
            INFO,
            DEBUG,
            WARN;

        }
    }

    private static class DefaultLogger
    implements ILogger {
        private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.qing");

        private DefaultLogger() {
        }

        @Override
        public boolean isDebugEnabled() {
            return logger.isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            logger.debug((Object)message);
        }

        @Override
        public void debug(String message, Throwable ex) {
            logger.debug((Object)message, ex);
        }

        @Override
        public void info(String message) {
            logger.info((Object)message);
        }

        @Override
        public void error(String message) {
            logger.error((Object)message);
        }

        @Override
        public void error(String message, Throwable ex) {
            logger.error((Object)message, ex);
        }

        @Override
        public void error(Throwable ex) {
            logger.error((Object)ex);
        }

        @Override
        public void warn(String message) {
            logger.warn((Object)message);
        }
    }

    public static interface ILogger {
        public boolean isDebugEnabled();

        public void error(Throwable var1);

        public void debug(String var1);

        public void debug(String var1, Throwable var2);

        public void info(String var1);

        public void error(String var1);

        public void error(String var1, Throwable var2);

        public void warn(String var1);
    }
}

