/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.brief;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.brief.AbstractExecutor;
import com.kingdee.bos.qing.core.brief.WarningRule;
import com.kingdee.bos.qing.core.brief.WarningRuleFunctions;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.exception.WarningRuleException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WarningRuleExecutor
extends AbstractExecutor {
    private WarningRuleDefinition _definition;
    private boolean _preview;
    private IEngineOutput _engineOutput;
    private List<BriefItem> _brief;
    private int _dimensionCount;
    private int _measureCount;

    public void setDefinition(WarningRuleDefinition definition) {
        this._definition = definition;
    }

    public void setUsageContext(boolean preview) {
        this._preview = preview;
    }

    public void setEngineOutput(IEngineOutput engineOutput) {
        this._engineOutput = engineOutput;
    }

    public WarningRule pickCube() {
        this.confirmFieldCount();
        ConditionDependance cd = new ConditionDependance(this.getI18nContext());
        TreeParser treeParser = new TreeParser(cd);
        try {
            AbstractRuntimeCondition conditionRoot = treeParser.toRuntimeCondition(this._definition.getConditionItems());
            this.initCondition(conditionRoot);
            this.initBrief();
            this.filterBrief(conditionRoot);
            WarningRule warningRule = this.outputBrief();
            if (this._preview) {
                this.outputPreview(warningRule);
            }
            return warningRule;
        }
        catch (WarningRuleException ex) {
            return new WarningRule(ex.getErrorCode(), ex.getMessage());
        }
    }

    private void confirmFieldCount() {
        this._dimensionCount = this._engineOutput.getCuboid().getDimensionFields().size();
        this._measureCount = 0;
        List<AnalyticalField> measures = this._engineOutput.getCuboid().getMeasureFields();
        for (AnalyticalField field : measures) {
            if (field.getId() == null) break;
            ++this._measureCount;
        }
    }

    private void initCondition(AbstractRuntimeCondition conditionRoot) throws WarningRuleException {
        if (conditionRoot == null) {
            return;
        }
        LinkedList<AbstractRuntimeCondition> queue = new LinkedList<AbstractRuntimeCondition>();
        queue.add(conditionRoot);
        while (!queue.isEmpty()) {
            AbstractRuntimeCondition node = (AbstractRuntimeCondition)queue.remove(0);
            if (node instanceof LogicCondition) {
                queue.add(((LogicCondition)node).getLeft());
                queue.add(((LogicCondition)node).getRight());
                continue;
            }
            if (!(node instanceof RuntimeCondition)) continue;
            RuntimeCondition rc = (RuntimeCondition)node;
            AnalyticalField foundField = null;
            List<AnalyticalField> dimensions = this._engineOutput.getCuboid().getDimensionFields();
            int idx = WarningRuleExecutor.searchFieldIndex(dimensions, this._dimensionCount, rc.getFieldId());
            if (idx >= 0) {
                rc.setDimensionIndex(idx);
                foundField = dimensions.get(idx);
            } else {
                List<AnalyticalField> measures = this._engineOutput.getCuboid().getMeasureFields();
                idx = WarningRuleExecutor.searchFieldIndex(measures, this._measureCount, rc.getFieldId());
                if (idx >= 0) {
                    rc.setMeasureIndex(idx);
                    foundField = measures.get(idx);
                }
            }
            if (foundField == null) {
                String msg = "Field not found at condition row " + (rc.getDesignTimeRowIndex() + 1) + ".";
                throw WarningRuleException.createFieldNotFoundException(msg);
            }
            rc.setField(foundField);
        }
    }

    private static int searchFieldIndex(List<AnalyticalField> fields, int count, String fieldId) {
        for (int i = 0; i < count; ++i) {
            AnalyticalField field = fields.get(i);
            if (!fieldId.equals(field.getId())) continue;
            return i;
        }
        return -1;
    }

    private void initBrief() {
        this._brief = new LinkedList<BriefItem>();
        Cuboid cuboid = this._engineOutput.getCuboid();
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKey = it.next();
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            this._brief.add(new BriefItem(dimKey, aggs));
        }
    }

    private void filterBrief(AbstractRuntimeCondition conditionRoot) throws WarningRuleException {
        if (conditionRoot == null) {
            return;
        }
        Iterator<BriefItem> it = this._brief.iterator();
        try {
            while (it.hasNext()) {
                BriefItem briefItem = it.next();
                if (conditionRoot.isAccepted(briefItem)) continue;
                it.remove();
            }
        }
        catch (ConditionException ex) {
            if (ex.isCustom()) {
                throw this.createFormulaExecuteException(ex.getConditionExceptionMessage(), ex.getConditionWhich(), ex.getConditionScript());
            }
            throw this.createConditionComparingException(ex.getConditionExceptionMessage(), ex.getConditionWhich());
        }
    }

    private WarningRule outputBrief() throws WarningRuleException {
        boolean matched = true;
        IExpr script = this._definition.getPostScriptExpr();
        if (script == null) {
            matched = !this._brief.isEmpty();
        } else {
            PostScriptRuntimeContext ctx = new PostScriptRuntimeContext(this._brief);
            ctx.setI18nContext(this.getI18nContext());
            Object checked = null;
            try {
                checked = script.execute((IExecuteContext)ctx);
            }
            catch (ExecuteException ex) {
                String exMsg = "type:" + ex.getType();
                String which = this.getMLS("briefOutputPostScript", "\u540e\u5904\u7406\u811a\u672c");
                throw this.createFormulaExecuteException(exMsg, which, this._definition.getPostScript());
            }
            matched = checked instanceof Boolean && (Boolean)checked != false;
        }
        WarningRule warningRule = new WarningRule();
        warningRule.setMatched(matched);
        return warningRule;
    }

    private void outputPreview(WarningRule warningRule) {
        List<AnalyticalField> dimensions = this._engineOutput.getCuboid().getDimensionFields();
        List<AnalyticalField> measures = this._engineOutput.getCuboid().getMeasureFields();
        List<AnalyticalField> fields = dimensions.subList(0, this._dimensionCount);
        fields.addAll(measures.subList(0, this._measureCount));
        ArrayList<String> previewTitle = new ArrayList<String>();
        for (AnalyticalField field : fields) {
            previewTitle.add(field.getTitle(this.getI18nContext()));
        }
        int fieldCount = fields.size();
        int totalRows = this._brief.size();
        LinkedList<List<String>> previewMatrix = new LinkedList<List<String>>();
        int c = Math.min(10, totalRows);
        for (int i = 0; i < c; ++i) {
            BriefItem item = this._brief.get(i);
            ArrayList<String> oneRow = new ArrayList<String>(fieldCount);
            for (int j = 0; j < fieldCount; ++j) {
                String text;
                AnalyticalField field = fields.get(j);
                if (j < this._dimensionCount) {
                    Object member = item.getMember(j);
                    text = this.formatDimension(member, field);
                } else {
                    int aggIdx = j - this._dimensionCount;
                    Object value = item.getMeasure(aggIdx);
                    text = this.formatMeasure(value, field);
                }
                oneRow.add(text);
            }
            previewMatrix.add(oneRow);
        }
        warningRule.setPreviewMatrix(previewTitle, previewMatrix);
        warningRule.setFilteredRows(totalRows);
    }

    private WarningRuleException createFormulaExecuteException(String exMsg, String which, String script) {
        String who = this._definition.getName();
        String what = this.getMLS("briefOutputExecute", "\u6267\u884c\u8fc7\u7a0b");
        String message = who + " | " + which + " | " + what + " | " + exMsg + "\r\n" + script;
        return WarningRuleException.createFormulaExecuteException(message);
    }

    private WarningRuleException createConditionComparingException(String exMsg, String which) {
        String who = this._definition.getName();
        String what = this.getMLS("briefOutputExecute", "\u6267\u884c\u8fc7\u7a0b");
        String message = who + " | " + which + " | " + what + " | " + exMsg;
        return WarningRuleException.createConditionComparingException(message);
    }

    private static class PostScriptRuntimeContext
    extends AbstractExecuteContext
    implements WarningRuleFunctions.IWarningRulePostScriptContext {
        private List<BriefItem> _brief;

        public PostScriptRuntimeContext(List<BriefItem> brief) {
            this._brief = brief;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowsCount() {
            return this._brief.size();
        }
    }

    private static class CustomConditionRuntimeContext
    extends AbstractExecuteContext {
        private Object _value;

        private CustomConditionRuntimeContext() {
        }

        public void bindValue(Object value) {
            this._value = value;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            String name;
            if (expr instanceof VariantExpr && "VALUE".equalsIgnoreCase(name = ((VariantExpr)expr).getName())) {
                return this._value;
            }
            return null;
        }
    }

    private static class BriefItem {
        private CompositeKey _dimKey;
        private Aggregator[] _aggs;

        public BriefItem(CompositeKey dimKey, Aggregator[] aggs) {
            this._dimKey = dimKey;
            this._aggs = aggs;
        }

        public Object getMember(int idx) {
            return this._dimKey.getMember(idx);
        }

        public Object getMeasure(int idx) {
            return this._aggs[idx].getValue();
        }
    }

    private static class LogicCondition
    extends AbstractRuntimeCondition {
        private AbstractRuntimeCondition _left;
        private AbstractRuntimeCondition _right;
        private WarningRuleDefinition.Logic _op;

        public LogicCondition(AbstractRuntimeCondition left, WarningRuleDefinition.Logic op, AbstractRuntimeCondition right) {
            this._left = left;
            this._right = right;
            this._op = op;
        }

        public AbstractRuntimeCondition getLeft() {
            return this._left;
        }

        public AbstractRuntimeCondition getRight() {
            return this._right;
        }

        @Override
        public boolean isAccepted(BriefItem briefItem) throws ConditionException {
            boolean leftAccepted = this._left.isAccepted(briefItem);
            if (this._op == WarningRuleDefinition.Logic.AND) {
                if (leftAccepted) {
                    boolean rightAccepted = this._right.isAccepted(briefItem);
                    return rightAccepted;
                }
                return false;
            }
            if (this._op == WarningRuleDefinition.Logic.OR) {
                if (leftAccepted) {
                    return true;
                }
                boolean rightAccepted = this._right.isAccepted(briefItem);
                return rightAccepted;
            }
            throw new RuntimeException("Unknown logic operation: " + (Object)((Object)this._op));
        }
    }

    private static class RuntimeCondition
    extends AbstractRuntimeCondition {
        private ConditionDependance _dependance;
        private WarningRuleDefinition.AbstractCondition _condition;
        private int _designTimeRowIndex;
        private int _dimensionIdx = -1;
        private int _measureIdx = -1;
        private AnalyticalField _field;
        private CustomConditionRuntimeContext _customConditionRuntimeContext;

        public RuntimeCondition(ConditionDependance cd, WarningRuleDefinition.AbstractCondition condition, int designTimeRowIndex) {
            this._dependance = cd;
            this._condition = condition;
            this._designTimeRowIndex = designTimeRowIndex;
        }

        public int getDesignTimeRowIndex() {
            return this._designTimeRowIndex;
        }

        public String getFieldId() {
            return this._condition.getFieldId();
        }

        public void setDimensionIndex(int idx) {
            this._dimensionIdx = idx;
            this._measureIdx = -1;
        }

        public void setMeasureIndex(int idx) {
            this._dimensionIdx = -1;
            this._measureIdx = idx;
        }

        public void setField(AnalyticalField field) {
            this._field = field;
        }

        @Override
        public boolean isAccepted(BriefItem briefItem) throws ConditionException {
            Object value = this._dimensionIdx >= 0 ? briefItem.getMember(this._dimensionIdx) : briefItem.getMeasure(this._measureIdx);
            if (this._condition.getType() == WarningRuleDefinition.ConditionType.NORMAL) {
                WarningRuleDefinition.NormalCondition nc = (WarningRuleDefinition.NormalCondition)this._condition;
                boolean accepted = this.compare(value, nc.getOperation(), nc.getComparing());
                return accepted;
            }
            if (this._condition.getType() == WarningRuleDefinition.ConditionType.CUSTOM) {
                Object checked;
                WarningRuleDefinition.CustomCondition cc = (WarningRuleDefinition.CustomCondition)this._condition;
                IExpr expr = cc.getConditionExpr();
                if (this._customConditionRuntimeContext == null) {
                    this._customConditionRuntimeContext = new CustomConditionRuntimeContext();
                    this._customConditionRuntimeContext.setI18nContext(this._dependance.getI18nContext());
                }
                this._customConditionRuntimeContext.bindValue(value);
                try {
                    checked = expr.execute((IExecuteContext)this._customConditionRuntimeContext);
                }
                catch (ExecuteException ex) {
                    String which = "which=row" + (this._designTimeRowIndex + 1);
                    String exMsg = "type:" + ex.getType();
                    throw new ConditionException(which, exMsg, cc.getConditionScript());
                }
                boolean accepted = checked instanceof Boolean && (Boolean)checked != false;
                return accepted;
            }
            throw new RuntimeException("Modify here.");
        }

        private boolean compare(Object value, WarningRuleDefinition.Operation op, String comparing) throws ConditionException {
            switch (op) {
                case N: {
                    return this.isNull(value);
                }
                case NOT_N: {
                    return !this.isNull(value);
                }
                case E: {
                    return this.isEqual(value, comparing);
                }
                case NOT_E: {
                    return !this.isEqual(value, comparing);
                }
                case G: {
                    return this.isGreaterThan(value, comparing);
                }
                case GE: {
                    return this.isGreaterThan(value, comparing) || this.isEqual(value, comparing);
                }
                case L: {
                    return this.isLessThan(value, comparing);
                }
                case LE: {
                    return this.isLessThan(value, comparing) || this.isEqual(value, comparing);
                }
            }
            throw new RuntimeException("Modify here.");
        }

        private boolean isNull(Object value) {
            return value == null;
        }

        private boolean isEqual(Object value, String comparing) throws ConditionException {
            if (value == null) {
                return false;
            }
            DataType dataType = this._field.getDataType();
            switch (dataType) {
                case NUMBER: {
                    BigDecimal number = this.getNumberComparing(comparing);
                    return ((BigDecimal)value).compareTo(number) == 0;
                }
                case DATE: {
                    long time = this.getDateComparing(comparing);
                    return ((Calendar)value).getTimeInMillis() == time;
                }
            }
            return value.toString().equals(comparing);
        }

        private boolean isGreaterThan(Object value, String comparing) throws ConditionException {
            if (value == null) {
                return false;
            }
            DataType dataType = this._field.getDataType();
            switch (dataType) {
                case NUMBER: {
                    BigDecimal number = this.getNumberComparing(comparing);
                    return ((BigDecimal)value).compareTo(number) > 0;
                }
                case DATE: {
                    long time = this.getDateComparing(comparing);
                    return ((Calendar)value).getTimeInMillis() > time;
                }
            }
            String msg = "dataType is not matched '>'";
            throw this.createConditionException(msg);
        }

        private boolean isLessThan(Object value, String comparing) throws ConditionException {
            if (value == null) {
                return false;
            }
            DataType dataType = this._field.getDataType();
            switch (dataType) {
                case NUMBER: {
                    BigDecimal number = this.getNumberComparing(comparing);
                    return ((BigDecimal)value).compareTo(number) < 0;
                }
                case DATE: {
                    long time = this.getDateComparing(comparing);
                    return ((Calendar)value).getTimeInMillis() < time;
                }
            }
            String msg = "dataType is not matched '<'";
            throw this.createConditionException(msg);
        }

        private BigDecimal getNumberComparing(String comparing) throws ConditionException {
            try {
                return new BigDecimal(comparing);
            }
            catch (NumberFormatException ex) {
                String exMsg = "not number:" + comparing;
                throw this.createConditionException(exMsg);
            }
        }

        private long getDateComparing(String comparing) throws ConditionException {
            try {
                return Long.parseLong(comparing);
            }
            catch (NumberFormatException ex) {
                String exMsg = "not date:" + comparing;
                throw this.createConditionException(exMsg);
            }
        }

        private ConditionException createConditionException(String msg) {
            String which = "which=row" + (this._designTimeRowIndex + 1);
            return new ConditionException(which, msg);
        }
    }

    private static class ConditionDependance {
        private II18nContext _i18nCtx;

        public ConditionDependance(II18nContext i18nCtx) {
            this._i18nCtx = i18nCtx;
        }

        public II18nContext getI18nContext() {
            return this._i18nCtx;
        }
    }

    private static class ConditionException
    extends Exception {
        private final boolean _custom;
        private final String _which;
        private final String _exMsg;
        private final String _script;

        public ConditionException(String which, String exMsg) {
            this._custom = false;
            this._which = which;
            this._exMsg = exMsg;
            this._script = null;
        }

        public ConditionException(String which, String exMsg, String script) {
            this._custom = true;
            this._which = which;
            this._exMsg = exMsg;
            this._script = script;
        }

        public boolean isCustom() {
            return this._custom;
        }

        public String getConditionWhich() {
            return this._which;
        }

        public String getConditionExceptionMessage() {
            return this._exMsg;
        }

        public String getConditionScript() {
            return this._script;
        }
    }

    private static abstract class AbstractRuntimeCondition {
        private AbstractRuntimeCondition() {
        }

        public abstract boolean isAccepted(BriefItem var1) throws ConditionException;
    }

    private static class TreeParser {
        private static final int MEET_START = 0;
        private static final int MEET_LEFT_BARCKET = 1;
        private static final int MEET_LOGIC = 2;
        private static final int MEET_CONDITION = 3;
        private ConditionDependance _conditionDependance;
        private Deque<Object> _stack;

        public TreeParser(ConditionDependance cd) {
            this._conditionDependance = cd;
        }

        public AbstractRuntimeCondition toRuntimeCondition(List<WarningRuleDefinition.ConditionItem> items) throws WarningRuleException {
            AbstractRuntimeCondition root = null;
            if (!items.isEmpty()) {
                this._stack = new LinkedList<Object>();
                int idx = 0;
                try {
                    for (idx = 0; idx < items.size(); ++idx) {
                        WarningRuleDefinition.ConditionItem item = items.get(idx);
                        this.pushLeftBrackets(item.getLeftBrackets());
                        this.pushCondition(item.getCondition(), idx);
                        this.pushRightBrackets(item.getRightBrackets());
                        this.pushLogic(item.getLogic());
                    }
                    this.pushEnding();
                }
                catch (SyntaxErrorDescription ex) {
                    idx += idx < items.size() ? 0 : 1;
                    String msg = "Invalid definition at row " + ((idx += ex.getRowOffset()) + 1) + ": " + ex.getMessage();
                    throw WarningRuleException.createConditionSyntaxException(msg);
                }
                root = (AbstractRuntimeCondition)this._stack.pop();
            }
            return root;
        }

        private void pushEnding() throws SyntaxErrorDescription {
            int endingPriority = -1;
            int met = this.meet(endingPriority);
            switch (met) {
                case 0: {
                    throw new SyntaxErrorDescription("missing condition", 0);
                }
                case 1: {
                    throw new SyntaxErrorDescription("redundant left bracket", 0);
                }
                case 2: {
                    throw new SyntaxErrorDescription("missing condition", 0);
                }
            }
        }

        private void pushLeftBrackets(int count) throws SyntaxErrorDescription {
            Object top;
            Object object = top = this._stack.isEmpty() ? null : this._stack.peek();
            if (top instanceof AbstractRuntimeCondition) {
                throw new SyntaxErrorDescription("missing logic operation", -1);
            }
            for (int i = 0; i < count; ++i) {
                this._stack.push("(");
            }
        }

        private void pushCondition(WarningRuleDefinition.AbstractCondition condition, int idx) throws SyntaxErrorDescription {
            Object top;
            Object object = top = this._stack.isEmpty() ? null : this._stack.peek();
            if (top instanceof AbstractRuntimeCondition) {
                throw new SyntaxErrorDescription("missing logic operation", -1);
            }
            this._stack.push(new RuntimeCondition(this._conditionDependance, condition, idx));
        }

        private void pushRightBrackets(int count) throws SyntaxErrorDescription {
            int rightBracketPriority = -1;
            block6: for (int i = 0; i < count; ++i) {
                int met = this.meet(rightBracketPriority);
                switch (met) {
                    case 0: {
                        throw new SyntaxErrorDescription("redundant right bracket", 0);
                    }
                    case 2: {
                        throw new SyntaxErrorDescription("missing condition", 0);
                    }
                    case 1: {
                        continue block6;
                    }
                    case 3: {
                        Object asCondition = this._stack.pop();
                        Object asLeftBracket = this.tryToPop();
                        if (!"(".equals(asLeftBracket)) continue block6;
                        this._stack.push(asCondition);
                    }
                }
            }
        }

        private void pushLogic(WarningRuleDefinition.Logic logic) throws SyntaxErrorDescription {
            if (logic != null) {
                int met = this.meet(logic.getPriority());
                switch (met) {
                    case 0: 
                    case 1: 
                    case 2: {
                        throw new SyntaxErrorDescription("missing condition", 0);
                    }
                    case 3: {
                        this._stack.push((Object)logic);
                    }
                }
            }
        }

        private Object tryToPop() {
            return this._stack.isEmpty() ? null : this._stack.pop();
        }

        private void tryToPush(Object obj) {
            if (obj != null) {
                this._stack.push(obj);
            }
        }

        private int meet(int priority) {
            Object asRight = this.tryToPop();
            Object asOp = this.tryToPop();
            Object asLeft = this.tryToPop();
            if (asRight == null) {
                return 0;
            }
            if ("(".equals(asRight)) {
                return 1;
            }
            if (asRight instanceof WarningRuleDefinition.Logic) {
                return 2;
            }
            if (asOp == null || "(".equals(asOp)) {
                this.tryToPush(asLeft);
                this.tryToPush(asOp);
                this.tryToPush(asRight);
                return 3;
            }
            WarningRuleDefinition.Logic op = (WarningRuleDefinition.Logic)((Object)asOp);
            if (priority <= op.getPriority()) {
                AbstractRuntimeCondition left = (AbstractRuntimeCondition)asLeft;
                AbstractRuntimeCondition right = (AbstractRuntimeCondition)asRight;
                LogicCondition compositeCondition = new LogicCondition(left, op, right);
                this._stack.push(compositeCondition);
                this.meet(priority);
            } else {
                this.tryToPush(asLeft);
                this.tryToPush(asOp);
                this.tryToPush(asRight);
            }
            return 3;
        }

        private static class SyntaxErrorDescription
        extends Exception {
            private final int _rowOffset;

            public SyntaxErrorDescription(String message, int rowOffset) {
                super(message);
                this._rowOffset = rowOffset;
            }

            public int getRowOffset() {
                return this._rowOffset;
            }
        }
    }
}

