/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.square;

import com.kingdee.bos.qing.core.charttype.square.AbstractChartPreprocessor;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Line;
import java.util.List;

class LinePreprocessor
extends AbstractChartPreprocessor {
    LinePreprocessor() {
    }

    @Override
    protected void preprocessChart(AbstractChart chart) {
        Line line = (Line)chart;
        LinePreprocessor.washDimension(line.getXAxis(), 1);
        LinePreprocessor.washDimension(line.getSeries(), 1);
        LinePreprocessor.washMeasure(line.getYAxis(), line.getSeries().getFieldCount() > 0 ? 1 : 64);
        FieldSet xAxis = line.getXAxis();
        if (xAxis.getFieldCount() > 0) {
            LinePreprocessor.makeDateFieldContinuous(xAxis.getField(0));
        }
        RollFieldSet rollFieldSet = line.getRoll();
        for (int i = 0; i < rollFieldSet.getFieldCount(); ++i) {
            LinePreprocessor.makeDateFieldContinuous(rollFieldSet.getField(i));
        }
    }

    @Override
    protected FieldSet getBeRolledFieldSet(AbstractChart chart) {
        Line line = (Line)chart;
        return line.getXAxis();
    }

    @Override
    protected List<AnalyticalField> createBeRolledFieldSetFields(AnalyticalField insteadField, List<AnalyticalField> drillDownPathFields, AbstractChart chart) {
        if (LinePreprocessor.checkContainsCubeInterlineCalculation(((Line)chart).getYAxis())) {
            drillDownPathFields.add(0, insteadField);
            return drillDownPathFields;
        }
        return super.createBeRolledFieldSetFields(insteadField, drillDownPathFields, chart);
    }
}

