/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.DateProcesser;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceGreenChannel {
    private IDataSourceVisitor _dataSourceVisitor;

    public DataSourceGreenChannel(IDataSourceVisitor dataSourceVisitor) {
        this._dataSourceVisitor = dataSourceVisitor;
    }

    public Calendar[] getDateScope(AnalyticalField analyticalField) throws AbstractDataSourceException, UserStoppedException {
        MetaField mf = analyticalField.getMetaField();
        DSFieldKey dsField = new DSFieldKey(mf.getMetaTable().getName(), mf.getPureName());
        try {
            return this._dataSourceVisitor.getDateScope(dsField);
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
    }

    public BigDecimal[] getNumberScope(AnalyticalField analyticalField) throws AbstractDataSourceException, UserStoppedException {
        MetaField mf = analyticalField.getMetaField();
        DSFieldKey dsField = new DSFieldKey(mf.getMetaTable().getName(), mf.getPureName());
        try {
            return this._dataSourceVisitor.getNumberScope(dsField);
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
    }

    public void getDistinctValue(AnalyticalField analyticalField, AbstractValueCollecter valueCollecter) throws AbstractDataSourceException, UserStoppedException {
        List<AnalyticalField> analyticalFields = DataSourceGreenChannel.parseAnalyticalField(analyticalField);
        this.getDistinctValueWithFilter(analyticalFields, null, valueCollecter);
    }

    public void getDistinctValue(String metaFieldFullName, AbstractValueCollecter valueCollecter) throws AbstractDataSourceException, UserStoppedException {
        String[] parts = MetaField.decodeFullName(metaFieldFullName);
        DSFieldKey dsField = new DSFieldKey(parts[0], parts[1]);
        ArrayList<DSFieldKey> dsFields = new ArrayList<DSFieldKey>(1);
        dsFields.add(dsField);
        this.collectDistinctValueWithFilter(null, dsFields, null, valueCollecter);
    }

    public void getDistinctValue(Set<String> metaFieldFullNames, AbstractValueCollecter valueCollecter) throws AbstractDataSourceException, UserStoppedException {
        ArrayList<DSFieldKey> dsFields = new ArrayList<DSFieldKey>(metaFieldFullNames.size());
        for (String fullName : metaFieldFullNames) {
            String[] parts = MetaField.decodeFullName(fullName);
            DSFieldKey dsField = new DSFieldKey(parts[0], parts[1]);
            dsFields.add(dsField);
        }
        this.collectDistinctValueWithFilter(null, dsFields, null, valueCollecter);
    }

    public void getDistinctValueWithFilter(List<AnalyticalField> analyticalFields, Map<MetaField, List<String>> filters, AbstractValueCollecter valueCollecter) throws AbstractDataSourceException, UserStoppedException {
        int count = analyticalFields.size();
        ArrayList<DSFieldKey> dsFields = new ArrayList<DSFieldKey>(count);
        HashMap<String, DateProcesser> dateProcessers = null;
        for (int i = 0; i < count; ++i) {
            AnalyticalField field = analyticalFields.get(i);
            MetaField mf = field.getMetaField();
            DSFieldKey dsField = new DSFieldKey(mf.getMetaTable().getName(), mf.getPureName());
            dsFields.add(i, dsField);
            if (DataType.DATE != mf.getDataType()) continue;
            DateProcesser dp = new DateProcesser(field);
            if (dateProcessers == null) {
                dateProcessers = new HashMap<String, DateProcesser>();
            }
            dateProcessers.put(mf.getFullName(), dp);
        }
        Set<IPushdownFilter> dsFilters = DataSourceGreenChannel.parseFilters(filters);
        this.collectDistinctValueWithFilter(dsFilters, dsFields, dateProcessers, valueCollecter);
    }

    private void collectDistinctValueWithFilter(Set<IPushdownFilter> dsFilters, List<DSFieldKey> dsFields, final Map<String, DateProcesser> dateProcessers, final AbstractValueCollecter valueCollecter) throws AbstractDataSourceException, UserStoppedException {
        try {
            this._dataSourceVisitor.collectDistinctValue(new IDistinctValueCollecter(){

                public boolean isBreak() {
                    return valueCollecter.isBreak();
                }

                public void collect(Map<String, Object> values) {
                    if (dateProcessers != null) {
                        for (Map.Entry dateProcesserEntry : dateProcessers.entrySet()) {
                            String fieldFullName = (String)dateProcesserEntry.getKey();
                            DateProcesser dp = (DateProcesser)dateProcesserEntry.getValue();
                            Object value = values.get(fieldFullName);
                            value = dp.process(value);
                            values.put(fieldFullName, value);
                        }
                    }
                    valueCollecter.accept(values);
                }
            }, dsFields, dsFilters);
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
    }

    private static List<AnalyticalField> parseAnalyticalField(AnalyticalField field) {
        HashSet<String> existFieldChecker = new HashSet<String>();
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        fields.add(field);
        existFieldChecker.add(field.getName());
        if (field.isParentChildDimension()) {
            MetaField pcdIdMf = field.getParentChildDimensionIdField();
            MetaField pcdParentIdMf = field.getParentChildDimensionParentIdField();
            MetaField sortAccordingMf = field.getSortAccordingField();
            DataSourceGreenChannel.collectFields(pcdIdMf, fields, existFieldChecker);
            DataSourceGreenChannel.collectFields(pcdParentIdMf, fields, existFieldChecker);
            DataSourceGreenChannel.collectFields(sortAccordingMf, fields, existFieldChecker);
        } else if (field.getSortAccordingField() != null) {
            DataSourceGreenChannel.collectFields(field.getSortAccordingField(), fields, existFieldChecker);
        }
        return fields;
    }

    private static void collectFields(MetaField mf, List<AnalyticalField> fields, Set<String> existFieldChecker) {
        if (mf != null && !existFieldChecker.contains(mf.getFullName())) {
            AnalyticalField field = new AnalyticalField();
            field.setName(mf.getFullName());
            field.setRole("dimension");
            field.bindMetaField(mf);
            fields.add(field);
            existFieldChecker.add(mf.getFullName());
        }
    }

    private static Set<IPushdownFilter> parseFilters(Map<MetaField, List<String>> filters) {
        if (filters == null) {
            return null;
        }
        HashSet<IPushdownFilter> result = new HashSet<IPushdownFilter>(filters.size());
        for (Map.Entry<MetaField, List<String>> filterEntry : filters.entrySet()) {
            MetaField metaField = filterEntry.getKey();
            List<String> values = filterEntry.getValue();
            DSFieldKey dsField = new DSFieldKey(metaField.getMetaTable().getName(), metaField.getPureName());
            UnderDSDiscreteFilter underDSDiscreteFilter = new UnderDSDiscreteFilter(dsField);
            underDSDiscreteFilter.setFiscalYearStart(metaField.getFiscalYearStart());
            underDSDiscreteFilter.setPartValue(null);
            underDSDiscreteFilter.setExclude(false);
            underDSDiscreteFilter.setSelected(values);
            result.add((IPushdownFilter)underDSDiscreteFilter);
        }
        return result;
    }

    public static abstract class AbstractValueCollecter {
        public abstract void accept(Map<String, Object> var1);

        public boolean isBreak() {
            return false;
        }
    }
}

