/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.DiscretePreparedValueGainer;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.DiscreteSelectableValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class MultiValueGainer
extends DiscretePreparedValueGainer {
    private AnalyticalField _fieldForDisplay;
    private AnalyticalField _fieldForOrderBy;

    public MultiValueGainer(AnalyticalField fieldForValue, AnalyticalField fieldForDisplay, AnalyticalField fieldForOrderBy, II18nContext i18nCtx) {
        super(fieldForValue, i18nCtx);
        this._fieldForDisplay = fieldForDisplay;
        this._fieldForOrderBy = fieldForOrderBy;
    }

    @Override
    protected AnalyticalField getUsableDisplayField() {
        return this._fieldForDisplay == null ? this.getValueField() : this._fieldForDisplay;
    }

    @Override
    protected CommonComparator createComparator(Locale locale) {
        return new ValuePair.MyComparator(locale);
    }

    @Override
    protected FilterPreparedValueGainer.IPreparedValueFruit createListFruit(Formater formater, FilterPreparedValueGainer.IDateReprocessing reprocessing, Comparable<?>[] valueArray) {
        List<Comparable<?>> list = Arrays.asList(valueArray);
        ValuePair[] vps = list.toArray(new ValuePair[0]);
        return new MyListFruit(formater, reprocessing, vps);
    }

    public void gain(Object value, Object display, Object orderBy) {
        if (this.isTreeStructure()) {
            ParentChildDimensionMember member = (ParentChildDimensionMember)value;
            Object usableDisplay = this._fieldForDisplay == null ? member.getDisplayValue() : display;
            Object usableOrderBy = this._fieldForOrderBy == null ? member.getSortAccordingValue() : orderBy;
            member.setValue(member.getParentIdValue(), usableDisplay, usableOrderBy);
            super.doGain(member);
        } else {
            Object usableDisplay = this._fieldForDisplay == null ? value : display;
            Object usableOrderBy = this._fieldForOrderBy == null ? usableDisplay : orderBy;
            ValuePair pair = new ValuePair(value, usableDisplay, usableOrderBy);
            super.doGain(pair);
        }
    }

    private static class MyListFruit
    implements FilterPreparedValueGainer.IPreparedValueFruit {
        private ValuePair[] _values;
        private Formater _formater;
        private FilterPreparedValueGainer.IDateReprocessing _reprocessing;

        public MyListFruit(Formater formater, FilterPreparedValueGainer.IDateReprocessing reprocessing, ValuePair[] valueArray) {
            this._formater = formater;
            this._reprocessing = reprocessing;
            this._values = valueArray;
        }

        @Override
        public boolean isGainerInvalid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractPreparedValue getPreparedValue() {
            ArrayList<DiscreteSelectableValues.Item> items = new ArrayList<DiscreteSelectableValues.Item>(this._values.length);
            for (int i = 0; i < this._values.length; ++i) {
                ValuePair valuePair = this._values[i];
                Object value = valuePair.getValue();
                Object display = valuePair.getUsableDisplay();
                DiscreteSelectableValues.Item item = new DiscreteSelectableValues.Item();
                if (display == null) {
                    item.setText("");
                } else if (this._formater == null) {
                    item.setText(display.toString());
                } else {
                    String formattedValue = this._formater.format(display);
                    item.setText(formattedValue);
                }
                if (value == null) {
                    item.setValue(null);
                } else if (this._reprocessing == null) {
                    item.setValue(value.toString());
                } else {
                    item.setValue(this._reprocessing.toPromissoryValue(value));
                }
                item.setSelected(true);
                items.add(item);
            }
            DiscreteSelectableValues dsv = new DiscreteSelectableValues();
            dsv.setValues(items);
            return dsv;
        }
    }

    private static class ValuePair
    implements Comparable<ValuePair> {
        private Object _value;
        private Object _usableDisplay;
        private Object _usableOrderBy;

        public ValuePair(Object value, Object usableDisplay, Object usableOrderBy) {
            this._value = value;
            this._usableDisplay = usableDisplay;
            this._usableOrderBy = usableOrderBy;
        }

        public Object getValue() {
            return this._value;
        }

        public Object getUsableDisplay() {
            return this._usableDisplay;
        }

        public Object getUsableOrderBy() {
            return this._usableOrderBy;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode += this._value == null ? 0 : this._value.hashCode();
            hashCode *= 31;
            hashCode += this._usableDisplay == null ? 0 : this._usableDisplay.hashCode();
            hashCode *= 31;
            return hashCode += this._usableOrderBy == null ? 0 : this._usableOrderBy.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof ValuePair) {
                Object anotherValue = ((ValuePair)another).getValue();
                Object anotherDisplay = ((ValuePair)another).getUsableDisplay();
                Object anotherOrderBy = ((ValuePair)another).getUsableOrderBy();
                if ((this._value == null ? anotherValue == null : this._value.equals(anotherValue)) && (this._usableDisplay == null ? anotherDisplay == null : this._usableDisplay.equals(anotherDisplay)) && (this._usableOrderBy == null ? anotherOrderBy == null : this._usableOrderBy.equals(anotherOrderBy))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(ValuePair o) {
            return 0;
        }

        private static class MyComparator
        extends CommonComparator {
            public MyComparator(Locale locale) {
                super(locale);
            }

            @Override
            protected Comparable<?> getComparingValue(Comparable<?> o) {
                return (Comparable)((ValuePair)o).getUsableOrderBy();
            }
        }
    }
}

