/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SortableCompositeMember;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.flattening.common.ContinuousColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.DiscreteColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.flattening.longer.RatioConfirmer;
import com.kingdee.bos.qing.core.flattening.longer.SortingUniformDefine;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.analysis.common.Order;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.analysis.longer.SortingLane;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.NonstringValue;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.CrossHeader;
import com.kingdee.bos.qing.core.model.exhibition.longer.Diagonal;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.MergeBlock;
import com.kingdee.bos.qing.core.model.exhibition.longer.ShedTitle;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AbstractHeadCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AxisCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.MeasureTitleCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.NonstringCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.SubtotalCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.TreeNodeCell;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFlatBuilder {
    private static final String DEFAULT_GRAND_TOTAL = "When row or column has no dimention.";
    private static final int MAX_COLUMN = 257;
    private AnalyticalModel _analyticalModel;
    private ModelAssistantStructure _modelAssistantStructure;
    private int _rowDimCount;
    private int _colDimCount;
    private PrioritizedSortingDefines[] _rowsSortingDefines;
    private PrioritizedSortingDefines[] _columnsSortingDefines;
    private AbstractMarkParser _markParser;
    private int _drawingMeasureCount;
    private int _topRowAdded;
    private int _leftColumnAdded;
    private HeaderForMeasure _topHeaderForMeasure;
    private HeaderForMeasure _leftHeaderForMeasure;
    private IEngineOutput _engine;
    private boolean _isOutputtingLeftHeadMergeBlocks = true;
    private int _maxColumns = 257;
    private SortingDependence _sortingDependence = new SortingDependence();
    private Group _columnRoot = new Group("ROOT", null);
    private Group _rowRoot = new Group("ROOT", null);
    private Map<CompositeKey, Integer> _columnsIndex;
    private Map<CompositeKey, CompositeKey> _columnKeyPools = new HashMap<CompositeKey, CompositeKey>();
    private String[] _measureTitles;
    private MeasureTitleCell[] _measureTitleCells;
    private List<Scope> _measureScopes;
    private RatioConfirmer _ratioConfirmer;
    private ContinuousColorConfirmer _continuousColorConfirmer;
    private DiscreteColorConfirmer _discreteColorConfirmer;
    private Map<String, Formater> _mapFormater;
    private TableView _tableView;
    private II18nContext _i18nContext;
    private String _skinName;
    private ICorrespondent _correspondent;
    private int _treeNodeGroupInstanceCount = 0;
    private int _groupInstanceCount = 0;
    private int _groupItemInstanceCount = 0;
    private long _estimateMemoryForHeadCell = 0L;

    protected final ICorrespondent getCorrespondent() {
        return this._correspondent;
    }

    public final void setModel(AnalyticalModel analyticalModel, ModelAssistantStructure mas) {
        this._modelAssistantStructure = mas;
        this._rowDimCount = mas.getRowDimensionFieldCount();
        this._colDimCount = mas.getColumnDimensionFieldCount();
        this._rowsSortingDefines = new PrioritizedSortingDefines[this._rowDimCount];
        this._columnsSortingDefines = new PrioritizedSortingDefines[this._colDimCount];
        this._analyticalModel = analyticalModel;
        this._markParser = this.createMarkParser();
        this._markParser.setModel(analyticalModel.getMarkFieldSet());
    }

    protected final ModelAssistantStructure getModelAssistantStructure() {
        return this._modelAssistantStructure;
    }

    protected final ChartConfig getChartConfig() {
        return this._analyticalModel.getChartConfig();
    }

    private ChartConfig.TableConfig getTableConfig() {
        return this.getChartConfig() == null ? null : this.getChartConfig().getTableConfig();
    }

    public final void setEngineOutputer(IEngineOutput eo) {
        this._engine = eo;
    }

    protected final IEngineOutput getEngineOutputer() {
        return this._engine;
    }

    public final void setTableMaxColumns(int maxColumns) {
        this._maxColumns = maxColumns;
    }

    public final void setOutputtingLeftHeadMergeBlocks(boolean isOutputting) {
        this._isOutputtingLeftHeadMergeBlocks = isOutputting;
    }

    protected abstract HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout var1);

    protected abstract HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout var1);

    protected abstract AbstractMarkParser createMarkParser();

    protected final AbstractMarkParser getMarkParser() {
        return this._markParser;
    }

    protected final Cuboid getCuboid(SubCuboidKey tag) {
        if (tag == null) {
            return this._engine.getCuboid();
        }
        return this._engine.getSubCuboid(tag);
    }

    protected final CuboidSpliter createCuboidSpliter() {
        CuboidSpliter cuboidSpliter = new CuboidSpliter(this.getModelAssistantStructure());
        cuboidSpliter.setCorrespondent(this.getCorrespondent());
        return cuboidSpliter;
    }

    private ParallelMeasureLayout getParallelMeasureLayout() {
        ChartConfig.TableConfig tc = this.getTableConfig();
        ParallelMeasureLayout pml = tc == null ? null : tc.getParallelMeasureLayout();
        pml = pml == null ? ParallelMeasureLayout.AtColumn : pml;
        return pml;
    }

    public final void flat(ICorrespondent correspondent) throws AnalysisException {
        this._correspondent = correspondent;
        Cuboid mainCuboid = this.getCuboid(null);
        List<AnalyticalField> measureFields = mainCuboid.getMeasureFields();
        this._markParser.parse(measureFields, this._modelAssistantStructure.getMeasureFieldCountForCell());
        boolean[] whichMeasureToDraw = this._markParser.getWhichMeasureToDraw();
        this._measureTitles = new String[measureFields.size()];
        this._drawingMeasureCount = this._markParser.getDrawingMeasureCount();
        this._measureTitleCells = new MeasureTitleCell[this._drawingMeasureCount];
        this._measureScopes = new ArrayList<Scope>(measureFields.size());
        for (int i = 0; i < measureFields.size(); ++i) {
            this._measureScopes.add(new Scope());
            this._measureTitles[i] = measureFields.get(i).getTitle(this._i18nContext);
        }
        this._topHeaderForMeasure = this.getTopRowForMeasureName(this.getParallelMeasureLayout());
        this._leftHeaderForMeasure = this.getLeftColumnForMeasureName(this.getParallelMeasureLayout());
        this._topRowAdded = this._topHeaderForMeasure.getLanes();
        this._leftColumnAdded = this._leftHeaderForMeasure.getLanes();
        this.beforeFlatCuboid();
        this.flatCuboid(mainCuboid, null, whichMeasureToDraw);
        for (SubCuboidKey tag : this._engine.getSubCuboidTags()) {
            if (!tag.isVisible()) continue;
            Cuboid subCuboid = this.getCuboid(tag);
            this.flatCuboid(subCuboid, tag, whichMeasureToDraw);
        }
        this.afterFlatCuboid();
        this.output();
        ArrayList<String> lostMetaFields = new ArrayList<String>();
        if (this._analyticalModel.isAnyMetaFieldLost(lostMetaFields)) {
            String warning = Messages.getLangMessage(this._i18nContext, "fieldNotExist", "\u5b57\u6bb5\u201c#1\u201d\u4e0d\u5b58\u5728\u3002").replace("#1", (CharSequence)lostMetaFields.get(0));
            this.getTableView().setWarning(warning);
        }
    }

    private void flatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw) throws AnalysisException {
        int checkEveryCells = 100;
        int count = 0;
        Iterator<CompositeKey> it = this.prepareIteratorForFlatCuboid(cuboid, subCuboidTag);
        while (it.hasNext()) {
            if (this._correspondent != null && count % checkEveryCells == 0) {
                this._correspondent.checkStoppedByUser();
                long bytes = (long)(this._columnKeyPools.size() + 20) * (long)(OccupyByte.MAP_ENTRY * 2 + CompositeKey.HEAPSIZE_OVERHEAD);
                bytes += (long)((this._groupInstanceCount + 25) * Group.HEAPSIZE_OVERHEAD);
                bytes += (long)((this._treeNodeGroupInstanceCount + 25) * TreeNodeGroup.HEAPSIZE_OVERHEAD);
                this._correspondent.applyForMemory(6, bytes += (long)((this._groupItemInstanceCount + 100) * (GroupItem.HEAPSIZE_OVERHEAD + this.getCellHeapSize())));
            }
            ++count;
            CompositeKey dimKey = it.next();
            if (this._drawingMeasureCount == 0) {
                GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, -1);
                this.mapping(dimKey, groupItem, -1);
                continue;
            }
            this.flatCubeCell(subCuboidTag, whichMeasureToDraw, dimKey);
        }
    }

    protected void beforeFlatCuboid() {
    }

    protected abstract Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid var1, SubCuboidKey var2) throws AnalysisException;

    protected abstract void flatCubeCell(SubCuboidKey var1, boolean[] var2, CompositeKey var3);

    protected void afterFlatCuboid() {
    }

    public final TableView getTableView() {
        if (this._tableView == null) {
            this._tableView = new TableView();
            this._tableView.setDraw(new DrawInfo());
            this._tableView.setMergeBlocks(new ArrayList<MergeBlock>());
            this._tableView.setLeftTopHead(new CrossHeader());
            this._tableView.setTopHead(new ArrayList<Object[]>());
            this._tableView.setLeftHead(new ArrayList<Object[]>());
            this._tableView.setCells(new ArrayList<ICell[]>());
            this._tableView.setLegends(new Legends());
            this._tableView.setShedTitle(this.createShedTitle());
            this._tableView.getDraw().setType(this._analyticalModel.getChartType());
            this._tableView.getDraw().setSecondaryType(this._markParser.getSecondaryType());
            this._tableView.getDraw().setDirection(this._markParser.getDirection());
        }
        return this._tableView;
    }

    private Group getNotNullSubGroup(Group parentGroup, Object member, int dimensionIdx) {
        Group group = parentGroup.getSubGroup(member);
        if (group == null) {
            if (member instanceof ParentChildDimensionMember) {
                ParentChildDimensionMember pcdMember = (ParentChildDimensionMember)member;
                boolean askAsParent = dimensionIdx >= 0 && this._engine.searchPcdAsParent(dimensionIdx, pcdMember);
                group = new TreeNodeGroup(pcdMember, this._sortingDependence, askAsParent);
                ++this._treeNodeGroupInstanceCount;
            } else {
                group = new Group(member, this._sortingDependence);
                ++this._groupInstanceCount;
            }
            parentGroup.addSubElement(group);
        }
        return group;
    }

    protected final GroupItem createGroupItem(CompositeKey dimensionKey, SubCuboidKey subCuboidTag, int measureIndex) {
        GroupItem groupItem = new GroupItem(dimensionKey, subCuboidTag, measureIndex);
        ++this._groupItemInstanceCount;
        return groupItem;
    }

    protected final void mapping(CompositeKey dimKey, GroupItem groupItem, int measureIndexAtTable) {
        Group parentGroup = this._rowRoot;
        if (this._rowDimCount + this._leftColumnAdded == 0) {
            parentGroup = this.getNotNullSubGroup(parentGroup, DEFAULT_GRAND_TOTAL, -1);
        } else {
            for (int i = 0; i < this._rowDimCount; ++i) {
                Object dimValue = dimKey.getMember(i);
                parentGroup = this.getNotNullSubGroup(parentGroup, dimValue, i);
            }
            if (this._leftColumnAdded > 0) {
                AbstractHeadCell value;
                if (this._leftHeaderForMeasure.isAsAxis()) {
                    String display = this._drawingMeasureCount == 1 ? this.getMeasureTitle(groupItem.getMeasureIndex()) : null;
                    value = this.createAxisCell(this._leftHeaderForMeasure, display);
                } else {
                    value = this._leftHeaderForMeasure.isAsBlank() ? null : this.getMeasureTitleCell(groupItem.getMeasureIndex(), measureIndexAtTable);
                }
                parentGroup = this.getNotNullSubGroup(parentGroup, value, -1);
            }
        }
        Group topHeaderParentGroup = this._columnRoot;
        CompositeKey columnKey = new CompositeKey();
        if (this._colDimCount + this._topRowAdded == 0) {
            columnKey.addMember(DEFAULT_GRAND_TOTAL);
            this.getNotNullSubGroup(topHeaderParentGroup, DEFAULT_GRAND_TOTAL, -1);
        } else {
            for (int i = this._rowDimCount; i < this._rowDimCount + this._colDimCount; ++i) {
                Object dimValue = dimKey.getMember(i);
                columnKey.addMember(dimValue);
                topHeaderParentGroup = this.getNotNullSubGroup(topHeaderParentGroup, dimValue, i);
            }
            if (this._topRowAdded > 0) {
                AbstractHeadCell value;
                if (this._topHeaderForMeasure.isAsAxis()) {
                    String display = this._drawingMeasureCount == 1 ? this.getMeasureTitle(groupItem.getMeasureIndex()) : null;
                    value = this.createAxisCell(this._topHeaderForMeasure, display);
                } else {
                    value = this._topHeaderForMeasure.isAsBlank() ? null : this.getMeasureTitleCell(groupItem.getMeasureIndex(), measureIndexAtTable);
                }
                columnKey.addMember(value);
                this.getNotNullSubGroup(topHeaderParentGroup, value, -1);
            }
        }
        groupItem.setColumnKey(this.getColumnKeyFromPools(columnKey));
        parentGroup.addSubElement(groupItem);
    }

    private AxisCell createAxisCell(HeaderForMeasure hfm, String displayName) {
        String dir;
        this._estimateMemoryForHeadCell += (long)AxisCell.HEAPZISE_OVERHEAD;
        AxisCell cell = new AxisCell();
        cell.setAxisType(hfm.getAxisType());
        if (displayName != null) {
            cell.setTitle(displayName);
        }
        if ("top".equals(dir = hfm.getDirection())) {
            cell.setAxisDirection("top");
        } else if ("bottom".equals(dir)) {
            cell.setAxisDirection("bottom");
        } else if ("left".equals(dir)) {
            cell.setAxisDirection("left");
        } else if ("right".equals(dir)) {
            cell.setAxisDirection("right");
        }
        return cell;
    }

    private CompositeKey getColumnKeyFromPools(CompositeKey columnKey) {
        CompositeKey existColumnKey = this._columnKeyPools.get(columnKey);
        if (existColumnKey == null) {
            this._columnKeyPools.put(columnKey, columnKey);
            existColumnKey = columnKey;
        }
        return existColumnKey;
    }

    private PrioritizedSortingDefines getRowsSortingDefine(int rowDimIdx) {
        if (rowDimIdx >= this._rowsSortingDefines.length) {
            return null;
        }
        PrioritizedSortingDefines psd = this._rowsSortingDefines[rowDimIdx];
        if (psd == null) {
            AnalyticalField field = this._modelAssistantStructure.getRowDimensionField(rowDimIdx);
            if (field.getSort() == null) {
                SortingUniformDefine defaultSelfDefine = new SortingUniformDefine(Order.ASC, 0);
                Order order = Order.ASC;
                int subLevelOffset = 0;
                for (int i = rowDimIdx + 1; i < this._rowDimCount; ++i) {
                    AnalyticalField subLevelField = this._modelAssistantStructure.getRowDimensionField(i);
                    if (subLevelField.getSort() == null) continue;
                    order = subLevelField.getSort();
                    subLevelOffset = i - rowDimIdx;
                    break;
                }
                if (subLevelOffset > 0) {
                    SortingUniformDefine define = new SortingUniformDefine(order, subLevelOffset);
                    psd = new PrioritizedSortingDefines(define, defaultSelfDefine);
                } else {
                    int colDimCount = this._modelAssistantStructure.getColumnDimensionFieldCount();
                    SortingLane rowsSortingLane = this._analyticalModel.getRowsSortingLane();
                    if ((rowsSortingLane = this.checkSortingLane(rowsSortingLane, colDimCount)) == null) {
                        psd = new PrioritizedSortingDefines(defaultSelfDefine);
                    } else {
                        SortingUniformDefine define = new SortingUniformDefine(rowsSortingLane);
                        psd = new PrioritizedSortingDefines(define, defaultSelfDefine);
                    }
                }
            } else {
                SortingUniformDefine define = new SortingUniformDefine(field.getSort(), 0);
                psd = new PrioritizedSortingDefines(define);
            }
            this._rowsSortingDefines[rowDimIdx] = psd;
        }
        return psd;
    }

    private PrioritizedSortingDefines getColumnsSortingDefine(int colDimIdx) {
        if (colDimIdx >= this._columnsSortingDefines.length) {
            return null;
        }
        PrioritizedSortingDefines psd = this._columnsSortingDefines[colDimIdx];
        if (psd == null) {
            AnalyticalField field = this._modelAssistantStructure.getColumnDimensionField(colDimIdx);
            if (field.getSort() == null) {
                SortingUniformDefine defaultSelfDefine = new SortingUniformDefine(Order.ASC, 0);
                Order order = Order.ASC;
                int subLevelOffset = 0;
                for (int i = colDimIdx + 1; i < this._colDimCount; ++i) {
                    AnalyticalField subLevelField = this._modelAssistantStructure.getColumnDimensionField(i);
                    if (subLevelField.getSort() == null) continue;
                    order = subLevelField.getSort();
                    subLevelOffset = i - colDimIdx;
                    break;
                }
                if (subLevelOffset > 0) {
                    SortingUniformDefine define = new SortingUniformDefine(order, subLevelOffset);
                    psd = new PrioritizedSortingDefines(define, defaultSelfDefine);
                } else {
                    int rowDimCount = this._modelAssistantStructure.getRowDimensionFieldCount();
                    SortingLane columnsSortingLane = this._analyticalModel.getColumnsSortingLane();
                    if ((columnsSortingLane = this.checkSortingLane(columnsSortingLane, rowDimCount)) == null) {
                        psd = new PrioritizedSortingDefines(defaultSelfDefine);
                    } else {
                        SortingUniformDefine define = new SortingUniformDefine(columnsSortingLane);
                        psd = new PrioritizedSortingDefines(define, defaultSelfDefine);
                    }
                }
            } else {
                SortingUniformDefine define = new SortingUniformDefine(field.getSort(), 0);
                psd = new PrioritizedSortingDefines(define);
            }
            this._columnsSortingDefines[colDimIdx] = psd;
        }
        return psd;
    }

    private SortingLane checkSortingLane(SortingLane sortingLane, int dimCount) {
        if (sortingLane == null || !this.isCellMeasurable()) {
            return null;
        }
        if (sortingLane.getHeadValueCount() > dimCount) {
            return null;
        }
        if (sortingLane.getHeadValueCount() > 0 && sortingLane.getHeadValueCount() < dimCount) {
            ExecutableValue[] oldHeadValue = sortingLane.getHeadValue();
            ExecutableValue[] newHeadValue = new ExecutableValue[dimCount];
            for (int i = 0; i < dimCount; ++i) {
                newHeadValue[i] = i < oldHeadValue.length ? oldHeadValue[i] : new ExecutableValue(ExecutableValue.DataType.Subtotal);
            }
            sortingLane.setHeadValue(newHeadValue);
        }
        if (sortingLane.getMeasureIndex() >= this._drawingMeasureCount) {
            return null;
        }
        return sortingLane;
    }

    private void output() throws EnvCeilingException, UserStoppedException {
        int maxDimCount = Math.max(1, Math.max(this._rowDimCount, this._colDimCount));
        int theoreticalMaxMbCount = (int)((double)this._groupInstanceCount / (Math.pow(2.0, maxDimCount) - 1.0) * (Math.pow(2.0, (double)maxDimCount - 1.0) - 1.0));
        this.estimateMemoryForMergeBlock(theoreticalMaxMbCount);
        this.estimateMemoryForTopHead(10);
        this.estimateMemoryForRows(this._groupItemInstanceCount / 10);
        this.estimateMemoryForHeadCell();
        this._columnsIndex = new HashMap<CompositeKey, Integer>();
        int topRows = 0;
        int colDimIdx = 0;
        this.postorderSortColumns(colDimIdx, this._columnRoot);
        List<Group> topHeaderGroups = this._columnRoot.getSortedSubGroups();
        List<Object[]> planeTopHeader = this.createPlaneTopHeader();
        if (planeTopHeader != null) {
            this.ouputPlaneTopHeader(planeTopHeader, topHeaderGroups);
            topRows = 1;
        } else if (this._colDimCount > 0 || this._drawingMeasureCount > 0) {
            this.ouputTopHeader(colDimIdx, topHeaderGroups, this._rowDimCount + this._leftColumnAdded);
            topRows = this._colDimCount + this._topRowAdded;
        }
        int columnCount = this.getTableView().getTopHead().size();
        columnCount = columnCount == 0 ? 1 : columnCount;
        this.estimateMemoryForHeadCell();
        this.estimateMemoryForTopHead(columnCount);
        this.estimateMemoryForRows(this._groupItemInstanceCount / columnCount);
        if (this._rowDimCount > 0 || this._drawingMeasureCount > 0) {
            int rowDimIdx = 0;
            this.postorderSortRows(rowDimIdx, this._rowRoot);
            this.outputRows(rowDimIdx, this._rowRoot.getSortedSubGroups(), topRows);
            this.estimateMemoryForHeadCell();
            this.estimateMemoryForRows(this.getTableView().getLeftHead().size());
            this.estimateMemoryForMergeBlock(this.getTableView().getMergeBlocks().size());
        }
        if (planeTopHeader != null) {
            this.outputPlaneCrossHeader();
        } else {
            this.outputCrossHeader();
        }
        this.makeRedundance();
        if (this.getChartConfig() == null || this.getChartConfig().isShowLegend()) {
            if (this._continuousColorConfirmer != null) {
                AnalyticalField field = this._continuousColorConfirmer.getAnalyticalField();
                String minText = this.formatNumber(this._continuousColorConfirmer.getScopeLeft(), field);
                String maxText = this.formatNumber(this._continuousColorConfirmer.getScopeRight(), field);
                Legends.ContinuousColorLegend ccl = this._continuousColorConfirmer.createLegend(minText, maxText);
                ccl.setTitle(field.getTitle(this._i18nContext));
                this.getTableView().getLegends().setContinuousColorLegend(ccl);
            }
            if (this._discreteColorConfirmer != null && !this._discreteColorConfirmer.isLegendIgnored()) {
                Legends.DiscreteColorLegend dcl = this._discreteColorConfirmer.createLegend();
                dcl.setTitle(this._discreteColorConfirmer.getTitle());
                this.getTableView().getLegends().setDiscreteColorLegend(dcl);
            }
            if (this._ratioConfirmer != null) {
                AnalyticalField field = this._ratioConfirmer.getAnalyticalField();
                Legends.SizeLegend sl = this._ratioConfirmer.createLegend();
                sl.setTitle(field.getTitle(this._i18nContext));
                int c = this._ratioConfirmer.getSegmentCount();
                for (int i = 0; i < c; ++i) {
                    String text = this.formatNumber(this._ratioConfirmer.getSegmentedValue(i), field);
                    String ratio = this._ratioConfirmer.getSegmentedRatio(i).toString();
                    sl.add(ratio, text);
                }
                this.getTableView().getLegends().setSizeLegend(sl);
            }
        }
    }

    private void outputCrossHeader() {
        AnalyticalField field;
        AnalyticalField theOnlyOneMeasureField;
        int i;
        int leftColCount;
        int topRowCount = this.getTableView().getTopHead().size() == 0 ? 0 : this.getTableView().getTopHead().get(0).length;
        int n = leftColCount = this.getTableView().getLeftHead().size() == 0 ? 0 : this.getTableView().getLeftHead().get(0).length;
        if (topRowCount == 0 || leftColCount == 0) {
            return;
        }
        Diagonal diagonal = new Diagonal(topRowCount, leftColCount);
        this.getTableView().getLeftTopHead().setDiagonal(diagonal);
        ArrayList<String> titles = new ArrayList<String>();
        diagonal.setTitles(titles);
        for (i = 0; i < topRowCount; ++i) {
            if (this._topRowAdded == 1 && i >= this._colDimCount) {
                theOnlyOneMeasureField = null;
                if (this._modelAssistantStructure.getMeasureFieldCountForXAxis() == 1) {
                    int measureCountBefore = this._modelAssistantStructure.getMeasureFieldCountForYAxis();
                    theOnlyOneMeasureField = this._modelAssistantStructure.getMeasureField(measureCountBefore);
                }
                titles.add(this.makeDiagonalTitle(this._topHeaderForMeasure, theOnlyOneMeasureField));
                continue;
            }
            field = this._modelAssistantStructure.getColumnDimensionFields().get(i);
            titles.add(field.getTitle(this._i18nContext));
        }
        for (i = leftColCount - 1; i >= 0; --i) {
            if (this._leftColumnAdded == 1 && i >= this._rowDimCount) {
                theOnlyOneMeasureField = null;
                if (this._modelAssistantStructure.getMeasureFieldCountForYAxis() == 1) {
                    theOnlyOneMeasureField = this._modelAssistantStructure.getMeasureField(0);
                }
                titles.add(this.makeDiagonalTitle(this._leftHeaderForMeasure, theOnlyOneMeasureField));
                continue;
            }
            field = this._modelAssistantStructure.getRowDimensionFields().get(i);
            titles.add(field.getTitle(this._i18nContext));
        }
        if (topRowCount > 1 || leftColCount > 1) {
            this.getTableView().getMergeBlocks().add(new MergeBlock(0, topRowCount - 1, 0, leftColCount - 1));
        }
    }

    private String makeDiagonalTitle(HeaderForMeasure headerForMeasure, AnalyticalField theOnlyOneMeasureField) {
        if (headerForMeasure.isAsAxis()) {
            if ("number" == headerForMeasure.getAxisType()) {
                if (theOnlyOneMeasureField != null) {
                    return theOnlyOneMeasureField.getTitle(this._i18nContext);
                }
                return Messages.getLangMessage(this._i18nContext, "measureValue", "\u503c");
            }
            if (this._modelAssistantStructure.getCellDimensionFieldCount() > 0) {
                AnalyticalField field = this._modelAssistantStructure.getCellDimensionFields().get(0);
                return field.getTitle(this._i18nContext);
            }
            return "";
        }
        if (headerForMeasure.isAsBlank()) {
            return "";
        }
        return Messages.getLangMessage(this._i18nContext, "measureName", "\u5ea6\u91cf\u540d\u79f0");
    }

    private void outputPlaneCrossHeader() {
        int leftColumnCount = this._rowDimCount + this._leftColumnAdded;
        String[] planeLeftTopHead = new String[leftColumnCount];
        for (int i = 0; i < leftColumnCount; ++i) {
            if (i < this._rowDimCount) {
                AnalyticalField field = this._modelAssistantStructure.getRowDimensionFields().get(i);
                planeLeftTopHead[i] = field.getTitle(this._i18nContext);
                continue;
            }
            planeLeftTopHead[i] = Messages.getLangMessage(this._i18nContext, "measureName", "\u5ea6\u91cf\u540d\u79f0");
        }
        this.getTableView().getLeftTopHead().setPlane(planeLeftTopHead);
    }

    private void ouputPlaneTopHeader(List<Object[]> planeTopHeader, List<Group> topHeaderGroups) {
        this.getTableView().setTopHead(planeTopHeader);
        int c = topHeaderGroups.size();
        for (int i = 0; i < c; ++i) {
            Group group = topHeaderGroups.get(i);
            CompositeKey compositeKey = new CompositeKey();
            compositeKey.pushMember(group.getDimensionMember());
            this._columnsIndex.put(this.getColumnKeyFromPools(compositeKey), this._columnsIndex.size());
        }
    }

    private void postorderSortColumns(int colDimIdx, Group group) {
        int count;
        int topRowCount = this._colDimCount + this._topRowAdded;
        int n = count = topRowCount == 0 ? 1 : topRowCount;
        if (colDimIdx < count - 1) {
            List<AbstractGroupElement> subs = group.getSubGroups();
            int c = subs.size();
            for (int i = 0; i < c; ++i) {
                AbstractGroupElement sub = subs.get(i);
                if (!(sub instanceof Group)) continue;
                this.postorderSortColumns(colDimIdx + 1, (Group)sub);
            }
        }
        PrioritizedSortingDefines psd = this._topRowAdded > 0 && colDimIdx == this._colDimCount ? null : this.getColumnsSortingDefine(colDimIdx);
        group.sortSubGroups(psd);
    }

    private int ouputTopHeader(int colDimIdx, List<Group> subs, int colsBefore) {
        int count;
        int topRowCount = this._colDimCount + this._topRowAdded;
        int n = count = topRowCount == 0 ? 1 : topRowCount;
        if (colDimIdx == count - 1) {
            int c = subs.size();
            for (int i = 0; i < c; ++i) {
                Group group = subs.get(i);
                CompositeKey compositeKey = new CompositeKey();
                Object[] column = new Object[topRowCount];
                if (this.getTableView().getTopHead().size() < this._maxColumns) {
                    this.getTableView().getTopHead().add(column);
                }
                int idx = colDimIdx;
                for (Group parent = group; parent != this._columnRoot; parent = parent.getParent()) {
                    compositeKey.pushMember(parent.getDimensionMember());
                    if (topRowCount <= 0) continue;
                    int dimensionIndex = idx < this._colDimCount ? idx + this._rowDimCount : -1;
                    this.makeHeadCellValue(column, idx--, parent, dimensionIndex);
                }
                this._columnsIndex.put(this.getColumnKeyFromPools(compositeKey), this._columnsIndex.size());
            }
            return subs.size();
        }
        int fromCol = colsBefore;
        int c = subs.size();
        for (int i = 0; i < c; ++i) {
            Group group = subs.get(i);
            int leafCount = this.ouputTopHeader(colDimIdx + 1, group.getSortedSubGroups(), fromCol);
            if (leafCount > 1) {
                this.getTableView().getMergeBlocks().add(new MergeBlock(colDimIdx, colDimIdx, fromCol, fromCol + leafCount - 1));
            }
            fromCol += leafCount;
        }
        return fromCol - colsBefore;
    }

    private void postorderSortRows(int rowDimIdx, Group group) {
        int leftColumnCount = this._rowDimCount + this._leftColumnAdded;
        int n = leftColumnCount = leftColumnCount == 0 ? 1 : leftColumnCount;
        if (rowDimIdx < leftColumnCount - 1) {
            List<AbstractGroupElement> subs = group.getSubGroups();
            int c = subs.size();
            for (int i = 0; i < c; ++i) {
                AbstractGroupElement sub = subs.get(i);
                if (!(sub instanceof Group)) continue;
                this.postorderSortRows(rowDimIdx + 1, (Group)sub);
            }
        }
        PrioritizedSortingDefines psd = this._leftColumnAdded > 0 && rowDimIdx == this._rowDimCount ? null : this.getRowsSortingDefine(rowDimIdx);
        group.sortSubGroups(psd);
    }

    private int outputRows(int rowDimIdx, List<Group> subs, int rowsBefore) {
        int leftColumnCount = this._rowDimCount + this._leftColumnAdded;
        int n = leftColumnCount = leftColumnCount == 0 ? 1 : leftColumnCount;
        if (rowDimIdx == leftColumnCount - 1) {
            int c = subs.size();
            for (int i = 0; i < c; ++i) {
                Group group = subs.get(i);
                this.outputRow(rowDimIdx, group);
            }
            return subs.size();
        }
        int fromRow = rowsBefore;
        int c = subs.size();
        for (int i = 0; i < c; ++i) {
            Group group = subs.get(i);
            int leafCount = this.outputRows(rowDimIdx + 1, group.getSortedSubGroups(), fromRow);
            if (leafCount > 1 && this._isOutputtingLeftHeadMergeBlocks) {
                this.getTableView().getMergeBlocks().add(new MergeBlock(fromRow, fromRow + leafCount - 1, rowDimIdx, rowDimIdx));
            }
            fromRow += leafCount;
        }
        return fromRow - rowsBefore;
    }

    private void outputRow(int rowDimIdx, Group group) {
        int leftColumnCount = this._rowDimCount + this._leftColumnAdded;
        Object[] leftHeadOneRow = new Object[leftColumnCount];
        this.getTableView().getLeftHead().add(leftHeadOneRow);
        if (leftColumnCount > 0) {
            int idx = rowDimIdx;
            for (Group parent = group; parent != this._rowRoot; parent = parent.getParent()) {
                int dimensionIndex = idx < this._rowDimCount ? idx : -1;
                this.makeHeadCellValue(leftHeadOneRow, idx--, parent, dimensionIndex);
            }
        }
        if (this._drawingMeasureCount == 0) {
            return;
        }
        ICell[] bodyOneRow = new ICell[this.getTableView().getTopHead().size()];
        this.getTableView().getCells().add(bodyOneRow);
        List<AbstractGroupElement> children = group.getSubGroups();
        if (children != null) {
            for (AbstractGroupElement child : children) {
                GroupItem item = (GroupItem)child;
                if (item.getSubCuboidTag() != null && item.getMeasureIndex() != -1 && !this.getModelAssistantStructure().getMeasureField(item.getMeasureIndex()).isTotalDisplay()) continue;
                ICell cell = this.createCell(item);
                int colIdx = this._columnsIndex.get(item.getColumnKey());
                if (colIdx >= this._maxColumns) continue;
                bodyOneRow[colIdx] = cell;
            }
        }
    }

    private void makeHeadCellValue(Object[] header, int idx, Group group, int dimensionIndex) {
        Object value = group.createHeadCellValue();
        if (value instanceof SubtotalCell) {
            Object nextValue;
            String text = Messages.getLangMessage(this._i18nContext, idx == 0 ? "total" : "subTotal", "\u603b\u8ba1/\u5c0f\u8ba1");
            SubtotalCell total = (SubtotalCell)value;
            total.setText(text);
            header[idx] = total;
            if (idx + 1 < header.length && (nextValue = header[idx + 1]) instanceof SubtotalCell) {
                header[idx + 1] = null;
            }
            this._estimateMemoryForHeadCell += (long)SubtotalCell.HEAPZISE_OVERHEAD;
        } else if (value instanceof TreeNodeCell) {
            header[idx] = value;
            this._estimateMemoryForHeadCell += (long)TreeNodeCell.HEAPZISE_OVERHEAD;
        } else if (dimensionIndex >= 0) {
            if (value == null) {
                NonstringCell cell = new NonstringCell();
                cell.setText("");
                cell.setValue(NonstringValue.create(null));
                header[idx] = cell;
            } else {
                AnalyticalField field = this._engine.getCuboid().getDimensionField(dimensionIndex);
                String text = this.formatValue(value, field);
                if (value instanceof String) {
                    header[idx] = value;
                } else {
                    NonstringCell cell = new NonstringCell();
                    cell.setText(text);
                    cell.setValue(NonstringValue.create(value));
                    header[idx] = cell;
                    this._estimateMemoryForHeadCell += (long)NonstringCell.HEAPZISE_OVERHEAD;
                }
            }
        } else {
            header[idx] = value;
        }
    }

    private void estimateMemoryForMergeBlock(int count) throws EnvCeilingException {
        if (this._correspondent != null) {
            long bytes = (long)MergeBlock.HEAPZISE_OVERHEAD * (long)count;
            this._correspondent.applyForMemory(7, bytes);
        }
    }

    private void estimateMemoryForTopHead(int count) throws EnvCeilingException {
        if (this._correspondent != null) {
            long bytes = (long)OccupyByte.ARRAY * (long)count;
            this._correspondent.applyForMemory(8, bytes);
        }
    }

    private void estimateMemoryForRows(int count) throws EnvCeilingException, UserStoppedException {
        if (this._correspondent != null) {
            this._correspondent.checkStoppedByUser();
            long bytes = (long)OccupyByte.ARRAY * (long)count * 2L;
            this._correspondent.applyForMemory(9, bytes);
        }
    }

    private void estimateMemoryForHeadCell() throws EnvCeilingException {
        if (this._correspondent != null) {
            this._correspondent.applyForMemory(11, this._estimateMemoryForHeadCell);
        }
    }

    protected void makeRedundance() {
    }

    protected abstract ICell createCell(GroupItem var1);

    protected abstract int getCellHeapSize();

    protected List<Object[]> createPlaneTopHeader() {
        return null;
    }

    protected final List<Object[]> createPlaneTopHeaderImpl() {
        if (this._colDimCount > 0) {
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.getParallelMeasureLayout() == ParallelMeasureLayout.AtColumn) {
            int measureIndexAtTable = 0;
            boolean[] whichMeasureToDraw = this._markParser.getWhichMeasureToDraw();
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                if (!whichMeasureToDraw[i]) continue;
                MeasureTitleCell mtc = this.getMeasureTitleCell(i, measureIndexAtTable++);
                result.add(new Object[]{mtc});
            }
        } else if (this._drawingMeasureCount == 1) {
            boolean[] whichMeasureToDraw = this._markParser.getWhichMeasureToDraw();
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                if (!whichMeasureToDraw[i]) continue;
                MeasureTitleCell mtc = this.getMeasureTitleCell(i, 0);
                result.add(new Object[]{mtc});
                break;
            }
        } else {
            result.add(new String[]{Messages.getLangMessage(this._i18nContext, "measureValue", "\u503c")});
        }
        return result;
    }

    protected final int getDrawingMeasureCount() {
        return this._drawingMeasureCount;
    }

    protected final String getMeasureTitle(int measureIndex) {
        return this._measureTitles[measureIndex];
    }

    protected final MeasureTitleCell getMeasureTitleCell(int measureIndex, int measureIndexAtTable) {
        MeasureTitleCell mtc = this._measureTitleCells[measureIndexAtTable];
        if (mtc == null) {
            mtc = new MeasureTitleCell();
            mtc.setMeasureIndex(measureIndexAtTable);
            mtc.setMeasureTitle(this.getMeasureTitle(measureIndex));
            this._measureTitleCells[measureIndexAtTable] = mtc;
            this._estimateMemoryForHeadCell += (long)MeasureTitleCell.HEAPZISE_OVERHEAD;
        }
        return mtc;
    }

    protected final Scope getMeasureScope(int measureIndex) {
        return this._measureScopes.get(measureIndex);
    }

    protected final String makeSizeValue(BigDecimal measureValue, int measureIndex, AnalyticalField sizeField) {
        if (measureValue == null) {
            return "0";
        }
        if (this._ratioConfirmer == null) {
            Scope scope = this._measureScopes.get(measureIndex);
            this._ratioConfirmer = new RatioConfirmer(scope.getMin(), scope.getMax());
            this._ratioConfirmer.setAnalyticalField(sizeField);
        }
        return this._ratioConfirmer.getRatio(measureValue).toString();
    }

    protected final String makeContinuousColorValue(BigDecimal measureValue, Scope scope, AnalyticalField colorField) {
        if (this._continuousColorConfirmer == null) {
            this._continuousColorConfirmer = new ContinuousColorConfirmer(scope.getMin(), scope.getMax());
            this._continuousColorConfirmer.setDefinition(colorField.getContinuousColor());
            this._continuousColorConfirmer.setAnalyticalField(colorField);
        }
        if (measureValue == null) {
            measureValue = scope.getMin();
        }
        return this._continuousColorConfirmer.getColor(measureValue);
    }

    protected final String makeContinuousColorValue(BigDecimal measureValue, int measureIndex, AnalyticalField colorField) {
        Scope scope = this._measureScopes.get(measureIndex);
        return this.makeContinuousColorValue(measureValue, scope, colorField);
    }

    protected final String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text) {
        return this.getDiscreteColorConfirmer().getColor(object, text);
    }

    protected final void confirmDiscreteColorLegendTitlebyField(AnalyticalField field) {
        String title = field == null ? Messages.getLangMessage(this._i18nContext, "measureName", "\u5ea6\u91cf\u540d\u79f0") : field.getTitle(this._i18nContext);
        this.getDiscreteColorConfirmer().setTitle(title);
    }

    private DiscreteColorConfirmer getDiscreteColorConfirmer() {
        if (this._discreteColorConfirmer == null) {
            this._discreteColorConfirmer = new DiscreteColorConfirmer(this._skinName, this._i18nContext, this.getPaletteType());
            this._discreteColorConfirmer.setTranslucence(this.getPaletteTranslucenceAlpha());
        }
        return this._discreteColorConfirmer;
    }

    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.BASE;
    }

    protected float getPaletteTranslucenceAlpha() {
        return 1.0f;
    }

    protected final String getDefaultColorValue() {
        return Palette.getDefaultColor(this._skinName);
    }

    protected final String formatNumber(BigDecimal value, AnalyticalField analyticalField) {
        Comparable<BigDecimal> formatTarget;
        if (value == null) {
            return "";
        }
        String formatString = analyticalField.getUsableFormat(this.getI18nCtx());
        if (analyticalField.isFormatingAsDate()) {
            formatTarget = Aggregator.bigDecimalToCalendar(value);
        } else {
            formatTarget = value;
            if (formatString == null || formatString.length() == 0) {
                int scale = value.scale();
                formatString = "#,##0" + (scale == 0 ? "" : (scale == 1 ? ".0" : ".00"));
            }
        }
        Formater formater = this.getFormater(formatString);
        return formater.format((Object)formatTarget);
    }

    protected final String formatValue(Object value, AnalyticalField analyticalField) {
        if (value == null) {
            return "";
        }
        if (DataType.STRING == analyticalField.getDataType()) {
            return value.toString();
        }
        String formatString = analyticalField.getUsableFormat(this.getI18nCtx());
        if (formatString == null || formatString.length() == 0) {
            return value.toString();
        }
        Formater formater = this.getFormater(formatString);
        if (value instanceof Calendar) {
            int formatingPart = PartValue.constraintFormating(analyticalField.getPartValue());
            return formater.format((Calendar)value, formatingPart);
        }
        return formater.format(value);
    }

    private Formater getFormater(String formatString) {
        Formater formater;
        if (this._mapFormater == null) {
            this._mapFormater = new HashMap<String, Formater>();
        }
        if ((formater = this._mapFormater.get(formatString)) == null) {
            formater = new Formater();
            formater.setFormatString(formatString);
            formater.setI18nContext(this.getI18nCtx());
            this._mapFormater.put(formatString, formater);
        }
        return formater;
    }

    public final void setQingContext(II18nContext i18nCtx, String skinName) {
        this._i18nContext = i18nCtx;
        this._skinName = skinName;
    }

    protected final II18nContext getI18nCtx() {
        return this._i18nContext;
    }

    private ShedTitle createShedTitle() {
        String title;
        ShedTitle st = new ShedTitle();
        for (AnalyticalField field : this.getModelAssistantStructure().getRowDimensionFields()) {
            title = field.getTitle(this._i18nContext);
            st.addTitleAtRow(title);
        }
        for (AnalyticalField field : this.getModelAssistantStructure().getColumnDimensionFields()) {
            title = field.getTitle(this._i18nContext);
            st.addTitleAtColumn(title);
        }
        return st;
    }

    protected final void cutTooLarge(AbstractNormalChartModel normalChart, int categoryLimitedCount, int seriesLimitedCount) {
        if (normalChart.cutTooLarge(categoryLimitedCount, seriesLimitedCount)) {
            String warning = Messages.getLangMessage(this._i18nContext, "cutTooLargeChart", "\u6570\u636e\u91cf\u8d85\u51fa\u89c6\u56fe\u5c55\u73b0\u80fd\u529b\uff0c\u5df2\u505a\u88c1\u526a\u3002");
            this.getTableView().setWarning(warning);
        }
    }

    protected boolean isCellMeasurable() {
        return true;
    }

    protected BigDecimal getCellMeasurableValue(SubCuboidKey tag, CompositeKey dimKeyForRowCol, int measureIndex) {
        Cuboid cuboid = this.getCuboid(tag);
        if (cuboid != null) {
            Aggregator[] aggregators = cuboid.getCellAggregators(dimKeyForRowCol);
            Aggregator aggregator = aggregators[measureIndex];
            return aggregator.getNumberValue();
        }
        return null;
    }

    protected static final String encodeCategoryValue(Set<Object> values) {
        return ExecutableValueCoder.dimemsionMembersToJsonString(values);
    }

    protected static final String encodeCategoryValue(Object categoryValue, String label) {
        return ExecutableValueCoder.dimemsionMemberToJsonString(categoryValue, label);
    }

    private static class TreeNodeGroup
    extends Group {
        public static final int HEAPSIZE_OVERHEAD = OccupyByte.align(Group.HEAPSIZE_OVERHEAD + OccupyByte.REFERENCE * 3 + OccupyByte.INT * 2) + OccupyByte.ARRAYLIST;
        private TreeNodeGroup _parentNode;
        private List<TreeNodeGroup> _childrenNode;
        private int _level;
        private int _lastChildLevel = -1;
        private TreeNodeCell _headCell;
        private boolean _askAsParent;

        private TreeNodeGroup() {
            super(null, null);
        }

        public TreeNodeGroup(ParentChildDimensionMember member, SortingDependence sortingDependence, boolean askAsParent) {
            super(member, sortingDependence);
            this._askAsParent = askAsParent;
        }

        private ParentChildDimensionMember getPcdMember() {
            return (ParentChildDimensionMember)super.getDimensionMember();
        }

        public Object getParentIdFieldValue() {
            return this.getPcdMember().getParentIdValue();
        }

        @Override
        public Object createHeadCellValue() {
            if (this._headCell == null) {
                Object value = this.getPcdMember().getDisplayValue();
                Object id = this.getPcdMember().getIdValue();
                this._headCell = new TreeNodeCell();
                this._headCell.setId(id == null ? "" : id.toString());
                this._headCell.setText(value == null ? "" : value.toString());
                this._headCell.setLevel(this._level);
                this._headCell.setAsParent(this._askAsParent || this._childrenNode != null);
                if (this._askAsParent) {
                    this._headCell.setExpanded(this._childrenNode != null);
                }
                if (this._lastChildLevel >= 0) {
                    this._headCell.setLastChildLevel(this._lastChildLevel);
                }
            }
            return this._headCell;
        }

        @Override
        public Object getMemberForSortAccording() {
            return this.getPcdMember().getSortAccordingValue();
        }

        public void addChildNode(TreeNodeGroup child) {
            if (this._childrenNode == null) {
                this._childrenNode = new ArrayList<TreeNodeGroup>();
            }
            this._childrenNode.add(child);
            child._parentNode = this;
        }

        public TreeNodeGroup getParentNode() {
            return this._parentNode;
        }

        public int getLevel() {
            return this._level;
        }

        public void setLevel(int level) {
            this._level = level;
        }

        public int getLastChildLevel() {
            return this._lastChildLevel;
        }

        public void setLastChildLevel(int lastChildLevel) {
            this._lastChildLevel = lastChildLevel;
        }

        public List<TreeNodeGroup> getInvertedSortedChildren() {
            if (this._childrenNode == null) {
                return null;
            }
            Collections.sort(this._childrenNode);
            return this._childrenNode;
        }

        @Override
        public int compareTo(Group o) {
            int result = super.compareTo(o);
            return -result;
        }
    }

    protected static class GroupItem
    extends AbstractGroupElement {
        public static final int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.REFERENCE * 3 + OccupyByte.INT);
        private CompositeKey _dimensionKey;
        private SubCuboidKey _subCuboidTag;
        private int _measureIndex;
        private CompositeKey _columnKey;

        public GroupItem(CompositeKey dimensionKey, SubCuboidKey subCuboidTag, int measureIndex) {
            this._dimensionKey = dimensionKey;
            this._subCuboidTag = subCuboidTag;
            this._measureIndex = measureIndex;
        }

        @Override
        protected Object getGroupKey() {
            return this._columnKey;
        }

        public void setColumnKey(CompositeKey column) {
            this._columnKey = column;
        }

        public CompositeKey getColumnKey() {
            return this._columnKey;
        }

        public CompositeKey getDimensionKey() {
            return this._dimensionKey;
        }

        public int getMeasureIndex() {
            return this._measureIndex;
        }

        public SubCuboidKey getSubCuboidTag() {
            return this._subCuboidTag;
        }
    }

    static class Group
    extends AbstractGroupElement
    implements Comparable<Group> {
        public static final int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.REFERENCE * 5) + OccupyByte.ARRAYLIST * 2 + OccupyByte.HASHMAP;
        private Object _member;
        private List<AbstractGroupElement> _subGroups = new ArrayList<AbstractGroupElement>();
        private Map<Object, AbstractGroupElement> _subGroupsMap = new HashMap<Object, AbstractGroupElement>();
        private PrioritizedSortingDefines _sortingDefines;
        private SortingDependence _sortingDependence;
        private List<Group> _sortedSubGroups;

        public Group(Object member, SortingDependence sortingDependence) {
            this._member = member;
            this._sortingDependence = sortingDependence;
        }

        public final Object getDimensionMember() {
            return this._member;
        }

        @Override
        protected Object getGroupKey() {
            return this._member;
        }

        public Object createHeadCellValue() {
            if (this._member == "com.kingdee.bos.qing.All") {
                return new SubtotalCell();
            }
            if (this._member instanceof SortableCompositeMember) {
                return ((SortableCompositeMember)this._member).getValue();
            }
            return this._member;
        }

        public PrioritizedSortingDefines getSortingDefines() {
            return this._sortingDefines;
        }

        protected Object getMemberForSortAccording() {
            return this._member;
        }

        protected final List<Object> getSortAccording() {
            ArrayList<Object> wrap = new ArrayList<Object>(2);
            if (this._member != "com.kingdee.bos.qing.All") {
                SortingUniformDefine define = this.getParent().getSortingDefines().getPrior1();
                if (define.isAccordingDimensionMember()) {
                    if (define.isAccordingSubDimension()) {
                        Group group = this;
                        for (int i = 0; i < define.getAccordingSubDimensionOffset(); ++i) {
                            group = group.getSortedSubGroups().get(0);
                        }
                        wrap.add(group.getMemberForSortAccording());
                    }
                } else {
                    wrap.add(this._sortingDependence.getSortAccording(this, define));
                }
            }
            wrap.add(this.getMemberForSortAccording());
            return wrap;
        }

        public final void addSubElement(AbstractGroupElement ele) {
            this._subGroups.add(ele);
            this._subGroupsMap.put(ele.getGroupKey(), ele);
            ele._parent = this;
        }

        public final List<AbstractGroupElement> getSubGroups() {
            return this._subGroups;
        }

        public final void sortSubGroups(PrioritizedSortingDefines psd) {
            this._sortingDefines = psd;
            this._sortedSubGroups = psd == null || this._subGroups.size() < 2 ? Arrays.asList(this._subGroups.toArray(new Group[0])) : (this._subGroups.get(0) instanceof TreeNodeGroup ? this.sortSubGroupsForTree() : this.sortSubGroups());
        }

        public final List<Group> getSortedSubGroups() {
            if (this._sortedSubGroups == null) {
                throw new RuntimeException("Please call sortSubGroups() first.");
            }
            return this._sortedSubGroups;
        }

        public final Group getSubGroup(Object key) {
            return (Group)this._subGroupsMap.get(key);
        }

        public final GroupItem getSubGroupItem(CompositeKey columnKey) {
            return (GroupItem)this._subGroupsMap.get(columnKey);
        }

        @Override
        public int compareTo(Group o) {
            List<Object> meWrap = this.getSortAccording();
            List<Object> anotherWrap = o.getSortAccording();
            Comparable me = (Comparable)meWrap.get(0);
            Comparable another = (Comparable)anotherWrap.get(0);
            if (me == "com.kingdee.bos.qing.All") {
                return this._sortingDependence.isTotalAhead() ? -1 : 1;
            }
            if (another == "com.kingdee.bos.qing.All") {
                return this._sortingDependence.isTotalAhead() ? 1 : -1;
            }
            Order order = this.getParent().getSortingDefines().getPrior1().getOrder();
            int result = this._sortingDependence.getValueComparer().compare(me, another);
            if (result == 0 && meWrap.size() > 1) {
                order = this.getParent().getSortingDefines().getPrior2().getOrder();
                me = (Comparable)meWrap.get(1);
                another = (Comparable)anotherWrap.get(1);
                result = this._sortingDependence.getValueComparer().compare(me, another);
            }
            if (order == Order.DESC && this._sortingDependence.getValueComparer().isReversedEnabled()) {
                result = -result;
            }
            return result;
        }

        private List<Group> sortSubGroups() {
            Object[] groups = this._subGroups.toArray(new Group[0]);
            Arrays.sort(groups);
            List<Object> list = Arrays.asList(groups);
            return list;
        }

        private List<Group> sortSubGroupsForTree() {
            Group subtotal = null;
            TreeNodeGroup virtualRoot = new TreeNodeGroup();
            virtualRoot.setLevel(-1);
            for (AbstractGroupElement sub : this._subGroups) {
                if (sub instanceof TreeNodeGroup) {
                    TreeNodeGroup node = (TreeNodeGroup)sub;
                    ParentChildDimensionMember key = ParentChildDimensionMember.createParentSearchingKey(node.getParentIdFieldValue());
                    TreeNodeGroup parent = (TreeNodeGroup)this._subGroupsMap.get(key);
                    if (parent == null) {
                        virtualRoot.addChildNode(node);
                        continue;
                    }
                    parent.addChildNode(node);
                    continue;
                }
                if (!(sub instanceof Group)) continue;
                subtotal = (Group)sub;
            }
            ArrayList<Group> result = new ArrayList<Group>();
            ArrayList<TreeNodeGroup> stack = new ArrayList<TreeNodeGroup>();
            stack.add(virtualRoot);
            while (!stack.isEmpty()) {
                List<TreeNodeGroup> children;
                TreeNodeGroup popOne = (TreeNodeGroup)stack.remove(stack.size() - 1);
                if (popOne != virtualRoot) {
                    popOne.setLevel(popOne.getParentNode().getLevel() + 1);
                    result.add(popOne);
                }
                if ((children = popOne.getInvertedSortedChildren()) == null || children.size() <= 0) continue;
                TreeNodeGroup lastChild = children.get(0);
                int parentProperty = popOne.getLastChildLevel();
                lastChild.setLastChildLevel(parentProperty >= 0 ? parentProperty : popOne.getLevel());
                stack.addAll(children);
            }
            if (subtotal != null) {
                result.add(subtotal);
            }
            return result;
        }
    }

    private static abstract class AbstractGroupElement {
        protected Group _parent;

        private AbstractGroupElement() {
        }

        public Group getParent() {
            return this._parent;
        }

        protected abstract Object getGroupKey();
    }

    private static class PrioritizedSortingDefines {
        private SortingUniformDefine _prior1;
        private SortingUniformDefine _prior2;

        public PrioritizedSortingDefines(SortingUniformDefine p1) {
            this._prior1 = p1;
            this._prior2 = null;
        }

        public PrioritizedSortingDefines(SortingUniformDefine p1, SortingUniformDefine p2) {
            this._prior1 = p1;
            this._prior2 = p2;
        }

        public SortingUniformDefine getPrior1() {
            return this._prior1;
        }

        public SortingUniformDefine getPrior2() {
            return this._prior2;
        }
    }

    private class SortingDependence {
        private CommonComparator comparer;

        private SortingDependence() {
        }

        private CompositeKey createTopHeadCompositeKey(SortingUniformDefine define) {
            CompositeKey topHeadCompositeKey = new CompositeKey();
            int measureIndexAtTable = define.getMeasureIndex();
            ExecutableValue[] headValue = define.getHeadValue();
            if (headValue.length == 0 && AbstractFlatBuilder.this._topRowAdded == 0 && AbstractFlatBuilder.this._drawingMeasureCount == 1 && measureIndexAtTable == 0) {
                topHeadCompositeKey.addMember(AbstractFlatBuilder.DEFAULT_GRAND_TOTAL);
            } else {
                for (int i = 0; i < headValue.length; ++i) {
                    Object member = headValue[i].getOriginalValue();
                    AnalyticalField field = AbstractFlatBuilder.this.getModelAssistantStructure().getColumnDimensionField(i);
                    if (field.isParentChildDimension()) {
                        member = ParentChildDimensionMember.createSearchingKey(member);
                    } else if (field.isOrderDefined()) {
                        member = SortableCompositeMember.createSearchingKey(member);
                    }
                    topHeadCompositeKey.addMember(member);
                }
                if (AbstractFlatBuilder.this._topRowAdded > 0) {
                    Object member = this.getAddedHeader(AbstractFlatBuilder.this._topHeaderForMeasure, measureIndexAtTable);
                    topHeadCompositeKey.addMember(member);
                }
            }
            return topHeadCompositeKey;
        }

        private Group createLeftHeadGroup(SortingUniformDefine define) {
            Object member;
            ExecutableValue[] headValue = define.getHeadValue();
            Group group = AbstractFlatBuilder.this._rowRoot;
            for (int i = 0; i < headValue.length; ++i) {
                member = headValue[i].getOriginalValue();
                if (AbstractFlatBuilder.this.getModelAssistantStructure().getRowDimensionField(i).isParentChildDimension()) {
                    member = ParentChildDimensionMember.createSearchingKey(member);
                }
                if ((group = group.getSubGroup(member)) == null) break;
            }
            if (group != null && AbstractFlatBuilder.this._leftColumnAdded > 0) {
                int measureIndexAtTable = define.getMeasureIndex();
                member = this.getAddedHeader(AbstractFlatBuilder.this._leftHeaderForMeasure, measureIndexAtTable);
                group = group.getSubGroup(member);
            }
            return group;
        }

        private Object getAddedHeader(HeaderForMeasure headerForMeasure, int measureIndexAtTable) {
            Object member = headerForMeasure.isAsAxis() ? this.getAxisCell(measureIndexAtTable, headerForMeasure) : (headerForMeasure.isAsBlank() ? null : this.getMeasureTitleCell(measureIndexAtTable));
            return member;
        }

        private MeasureTitleCell getMeasureTitleCell(int measureIndexAtTable) {
            measureIndexAtTable = measureIndexAtTable < 0 ? 0 : measureIndexAtTable;
            return AbstractFlatBuilder.this.getMeasureTitleCell(-1, measureIndexAtTable);
        }

        private AxisCell getAxisCell(int measureIndexAtTable, HeaderForMeasure headerForMeasure) {
            int measureIndex = measureIndexAtTable < 0 ? 0 : measureIndexAtTable;
            String display = AbstractFlatBuilder.this._drawingMeasureCount == 1 ? AbstractFlatBuilder.this.getMeasureTitle(measureIndex) : null;
            AxisCell ac = AbstractFlatBuilder.this.createAxisCell(headerForMeasure, display);
            return ac;
        }

        private boolean isTopHeadGroup(Group theGroup) {
            Group group = theGroup;
            while (group != null) {
                if ((group = group.getParent()) == AbstractFlatBuilder.this._columnRoot) {
                    return true;
                }
                if (group != AbstractFlatBuilder.this._rowRoot) continue;
                return false;
            }
            throw new RuntimeException("Something must be wrong.");
        }

        public Object getSortAccording(Group theGroup, SortingUniformDefine define) {
            GroupItem item = null;
            if (this.isTopHeadGroup(theGroup)) {
                Group leftHeadGroup = define.getLeftHeadGroup();
                if (leftHeadGroup == null) {
                    leftHeadGroup = this.createLeftHeadGroup(define);
                    define.setLeftHeadGroup(leftHeadGroup);
                }
                if (leftHeadGroup != null) {
                    CompositeKey columnKey = new CompositeKey();
                    int idx = 0;
                    Group group = theGroup;
                    while (group != AbstractFlatBuilder.this._columnRoot) {
                        columnKey.pushMember(group.getGroupKey());
                        group = group.getParent();
                        ++idx;
                    }
                    group = theGroup;
                    int colDimCount = AbstractFlatBuilder.this._modelAssistantStructure.getColumnDimensionFieldCount();
                    for (int i = idx; i < colDimCount; ++i) {
                        Group subGroup = group.getSubGroup("com.kingdee.bos.qing.All");
                        if (subGroup == null) {
                            subGroup = group.getSortedSubGroups().get(0);
                            columnKey.addMember(subGroup.getDimensionMember());
                        } else {
                            columnKey.addMember("com.kingdee.bos.qing.All");
                        }
                        group = subGroup;
                    }
                    if (AbstractFlatBuilder.this._topRowAdded > 0) {
                        int measureIndexAtTable = define.getMeasureIndex();
                        Object member = this.getAddedHeader(AbstractFlatBuilder.this._topHeaderForMeasure, measureIndexAtTable);
                        columnKey.addMember(member);
                    }
                    item = leftHeadGroup.getSubGroupItem(columnKey);
                }
            } else {
                CompositeKey columnKey;
                Group parent = theGroup;
                int idx = 0;
                while (parent != AbstractFlatBuilder.this._rowRoot && parent != null) {
                    parent = parent.getParent();
                    ++idx;
                }
                int rowDimCount = AbstractFlatBuilder.this._modelAssistantStructure.getRowDimensionFieldCount();
                Group group = theGroup;
                for (int i = idx; i < rowDimCount; ++i) {
                    Group subGroup = group.getSubGroup("com.kingdee.bos.qing.All");
                    if (subGroup == null) {
                        subGroup = group.getSortedSubGroups().get(0);
                    }
                    group = subGroup;
                }
                if (AbstractFlatBuilder.this._leftColumnAdded > 0) {
                    int measureIndexAtTable = define.getMeasureIndex();
                    Object member = this.getAddedHeader(AbstractFlatBuilder.this._leftHeaderForMeasure, measureIndexAtTable);
                    group = group.getSubGroup(member);
                }
                if ((columnKey = define.getTopHeadCompositeKey()) == null) {
                    columnKey = this.createTopHeadCompositeKey(define);
                    define.setTopHeadCompositeKey(columnKey);
                }
                item = group.getSubGroupItem(columnKey);
            }
            if (item == null) {
                return null;
            }
            return AbstractFlatBuilder.this.getCellMeasurableValue(item.getSubCuboidTag(), item.getDimensionKey(), item.getMeasureIndex());
        }

        public CommonComparator getValueComparer() {
            if (this.comparer == null) {
                Locale locale = AbstractFlatBuilder.this._i18nContext.getLanManager().getLocale();
                this.comparer = new CommonComparator(locale);
                this.comparer.setEmptyAheadAlways(false);
            }
            return this.comparer;
        }

        public boolean isTotalAhead() {
            ChartConfig.TableConfig tc = AbstractFlatBuilder.this.getTableConfig();
            return tc == null ? false : tc.isTotalAhead();
        }
    }
}

