/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CuboidSpliter {
    private ModelAssistantStructure _mas;
    private CompositeKey _dimKeySubtotal;
    private int _subtotalSrcMeasureIdx;
    private int _subtotalDestMeasureIdx;
    private Map<CompositeKey, Cuboid> _rowColPartOfCuboid;
    private Map<SubCuboidKey, Map<CompositeKey, Cuboid>> _rowColPartOfSubCuboids;
    private ICorrespondent _correspondent;

    public CuboidSpliter(ModelAssistantStructure mas) {
        this._mas = mas;
    }

    public void setCorrespondent(ICorrespondent correspondent) {
        this._correspondent = correspondent;
    }

    public void openInsideSubtotal(int srcMeasureIdx, int destMeasureIdx) {
        this._subtotalSrcMeasureIdx = srcMeasureIdx;
        this._subtotalDestMeasureIdx = destMeasureIdx;
        this._dimKeySubtotal = new CompositeKey();
        int c = this._mas.getCellDimensionFieldCount();
        for (int i = 0; i < c; ++i) {
            this._dimKeySubtotal.addMember("com.kingdee.bos.qing.All");
        }
    }

    public void standardizingCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag, AbstractDoMoreHandler doMore) throws EnvCeilingException {
        int n = this._mas.getRowDimensionFieldCount() + this._mas.getColumnDimensionFieldCount();
        int m = this._mas.getCellDimensionFieldCount();
        long bytesPerCell = cuboid.getHeapSizePerCell();
        long estimateBytes = bytesPerCell * 100L;
        long count = 0L;
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>(cuboid.getMeasureFields().size());
        int c = cuboid.getMeasureFields().size();
        for (int i = 0; i < c; ++i) {
            aggregations.add(Aggregation.SUM);
        }
        int displayMeasureCount = this._mas.getMeasureFieldCountForCell();
        Map<CompositeKey, Cuboid> stanardizedCube = this.getStandardizedCube(subCuboidTag);
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKey = it.next();
            CompositeKey[] twoKeys = dimKey.split(n);
            CompositeKey dimKeyForRowCol = twoKeys[0];
            CompositeKey dimKeyInCell = twoKeys[1];
            Cuboid cuboidInCell = stanardizedCube.get(dimKeyForRowCol);
            if (cuboidInCell == null) {
                List<AnalyticalField> dims = cuboid.getDimensionFields();
                cuboidInCell = new Cuboid();
                cuboidInCell.setDimensionFields(dims.subList(n, n + m));
                cuboidInCell.setMeasureFields(cuboid.getMeasureFields());
                cuboidInCell.setAppointedAggregations(aggregations);
                stanardizedCube.put(dimKeyForRowCol, cuboidInCell);
                estimateBytes += (long)(CompositeKey.HEAPSIZE_OVERHEAD + Cuboid.HEAPSIZE_OVERHEAD);
            }
            if (doMore != null) {
                doMore.forDimension(dimKeyInCell);
            }
            Aggregator[] aggInOrigin = cuboid.getCellAggregators(dimKey);
            Aggregator[] aggInChartPart = cuboidInCell.getCellAggregators(dimKeyInCell);
            Aggregator[] aggInChartPartForAll = null;
            if (this._dimKeySubtotal != null) {
                aggInChartPartForAll = cuboidInCell.getCellAggregators(this._dimKeySubtotal);
            }
            for (int k = 0; k < displayMeasureCount; ++k) {
                Aggregator aggregator = aggInOrigin[k];
                Object value = aggregator.getValue();
                aggInChartPart[k].append(value);
                if (aggInChartPartForAll != null && (this._subtotalSrcMeasureIdx == -1 || this._subtotalSrcMeasureIdx == k)) {
                    if (doMore != null) {
                        value = doMore.measureToSubtotal(value);
                    }
                    int idx = this._subtotalDestMeasureIdx == -1 ? k : this._subtotalDestMeasureIdx;
                    aggInChartPartForAll[idx].append(value);
                }
                if (doMore == null) continue;
                doMore.forMeasure(k, aggregator);
            }
            if (this._correspondent == null) continue;
            if (count % 100L == 0L) {
                this._correspondent.applyForMemory(10, estimateBytes += bytesPerCell * 100L);
            }
            ++count;
        }
    }

    public Map<CompositeKey, Cuboid> getStandardizedCube(SubCuboidKey tag) {
        Map<CompositeKey, Cuboid> sub;
        if (tag == null) {
            if (this._rowColPartOfCuboid == null) {
                this._rowColPartOfCuboid = new HashMap<CompositeKey, Cuboid>();
            }
            return this._rowColPartOfCuboid;
        }
        if (this._rowColPartOfSubCuboids == null) {
            this._rowColPartOfSubCuboids = new HashMap<SubCuboidKey, Map<CompositeKey, Cuboid>>();
        }
        if ((sub = this._rowColPartOfSubCuboids.get(tag)) == null) {
            sub = new HashMap<CompositeKey, Cuboid>();
            this._rowColPartOfSubCuboids.put(tag, sub);
        }
        return sub;
    }

    public boolean isSubtotalKey(CompositeKey key) {
        return key == this._dimKeySubtotal;
    }

    public BigDecimal getInsideSubtotal(Cuboid cuboidInCell, int measureIdx) {
        if (this._dimKeySubtotal == null) {
            throw new RuntimeException("Do you forget openInsideSubtotal()?");
        }
        Aggregator[] aggregators = cuboidInCell.getCellAggregators(this._dimKeySubtotal);
        Aggregator aggregator = aggregators[measureIdx];
        return aggregator.getNumberValue();
    }

    public static abstract class AbstractDoMoreHandler {
        public Object measureToSubtotal(Object value) {
            return value;
        }

        public void forDimension(CompositeKey dimKeyInCell) {
        }

        public void forMeasure(int measureIndex, Aggregator aggregator) {
        }
    }
}

