/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSimilarListMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.CustomList;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.CustomListChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.square.GridChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MakerForCustomList
extends AbstractSimilarListMaker {
    private Map<AnalyticalField, Integer> _dimensionSearcher;
    private Map<AnalyticalField, Integer> _measureSearcher;
    private List<Scope> _scopes;
    private Map<Integer, Boolean> _staticTextMark;

    MakerForCustomList() {
    }

    private CustomList getDesignModel() {
        return (CustomList)this.getModel().getChartModel();
    }

    private CustomListChartProperty getDesignProperty() {
        return (CustomListChartProperty)this.getDesignModel().getChartProperty();
    }

    private static int searchFieldIndex(AnalyticalField field, List<AnalyticalField> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i) != field) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected FieldSet getFieldSet() {
        return this.getDesignModel().getFieldSet();
    }

    @Override
    protected int getColumnNumberOffset() {
        return 0;
    }

    @Override
    protected void makeColumns(GridChartModel chart) {
        this._dimensionSearcher = new HashMap<AnalyticalField, Integer>();
        this._measureSearcher = new HashMap<AnalyticalField, Integer>();
        FieldSet fieldSet = this.getFieldSet();
        int c = fieldSet.getFieldCount();
        for (int i = 0; i < c; ++i) {
            AnalyticalField field = fieldSet.getField(i);
            int fieldIdx = MakerForCustomList.searchFieldIndex(field, this.getCuboid().getDimensionFields());
            if (fieldIdx >= 0) {
                this._dimensionSearcher.put(field, fieldIdx);
                continue;
            }
            fieldIdx = MakerForCustomList.searchFieldIndex(field, this.getCuboid().getMeasureFields());
            if (fieldIdx < 0) continue;
            this._measureSearcher.put(field, fieldIdx);
        }
        this._scopes = new ArrayList<Scope>();
        this._staticTextMark = new HashMap<Integer, Boolean>();
        List<CustomListChartProperty.ContentArea> areas = this.getDesignProperty().getContentPanel().getAreas();
        for (int i = 0; i < areas.size(); ++i) {
            CustomListChartProperty.ContentArea area = areas.get(i);
            AnalyticalField field = area.getBoundField();
            String title = field == null ? "" : field.getTitle(this.getI18nContext());
            GridChartModel.Column column = chart.addOneColumn();
            column.setTitle(title);
            this._staticTextMark.put(i, field == null);
            Scope scope = null;
            CustomListChartProperty.ColorBar colorBar = area.getColorBar();
            if (colorBar != null && field != null && field.isMeasure()) {
                if (colorBar.getMax() == null || colorBar.getMin() == null) {
                    scope = new Scope();
                }
                GridChartModel.Bar bar = new GridChartModel.Bar();
                bar.setScopeMin(colorBar.getMin());
                bar.setScopeMax(colorBar.getMax());
                bar.setMainColor(colorBar.getNormalColor());
                bar.setNegativeColor(colorBar.getNegativeColor());
                bar.setCrossAxisColor(colorBar.getAxisColor());
                column.setBar(bar);
            }
            this._scopes.add(scope);
        }
    }

    @Override
    protected void postMake(GridChartModel chart) {
        List<GridChartModel.Column> columns = chart.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Boolean mark;
            GridChartModel.Column column = columns.get(i);
            GridChartModel.Bar bar = column.getBar();
            if (bar != null) {
                Scope scope = this._scopes.get(i);
                if (bar.getScopeMin() == null) {
                    bar.setScopeMin(scope.getMin().toPlainString());
                }
                if (bar.getScopeMax() == null) {
                    bar.setScopeMax(scope.getMax().toPlainString());
                }
            }
            if ((mark = this._staticTextMark.get(i)) == null || !mark.booleanValue()) continue;
            column.setStaticText(true);
        }
    }

    @Override
    protected void makeOneRow(int rowNum, GridChartModel.Row row, CompositeKey dimKey) {
        Aggregator[] aggs = this.getCuboid().getCellAggregators(dimKey);
        List<CustomListChartProperty.ContentArea> areas = this.getDesignProperty().getContentPanel().getAreas();
        for (int i = 0; i < areas.size(); ++i) {
            String text = null;
            Object value = null;
            BigDecimal number = null;
            boolean done = false;
            CustomListChartProperty.ContentArea area = areas.get(i);
            AnalyticalField field = area.getBoundField();
            if (field != null) {
                Integer dimensionIdx = this._dimensionSearcher.get(field);
                if (dimensionIdx != null) {
                    value = dimKey.getMember(dimensionIdx);
                    text = this.formatValue(value, field);
                    done = true;
                } else {
                    Integer measureIdx = this._measureSearcher.get(field);
                    if (measureIdx != null) {
                        number = aggs[measureIdx].getNumberValue();
                        value = number;
                        text = this.formatNumber(number, field);
                        Scope scope = this._scopes.get(i);
                        if (scope != null) {
                            scope.join(number);
                        }
                        done = true;
                    }
                }
            }
            if (!done) {
                String customText = area.getCustomText();
                text = customText == null ? "" : this.parseCustomText(i, customText, rowNum, dimKey, aggs);
                value = text;
            }
            GridChartModel.Cell cell = row.addOneCell(text);
            cell.setValue(value);
            cell.setNumber(number == null ? null : number.toPlainString());
            this.makeCellStyle(area, cell);
        }
        this.makeLinkageKeyword(row, dimKey);
        this.makeAffectionSrc(row, dimKey);
    }

    private void makeLinkageKeyword(GridChartModel.Row row, CompositeKey dimKey) {
        if (this.getDesignProperty().hasLinkageTarget()) {
            int dimCount = 0;
            int c = this.getFieldSet().getFieldCount();
            for (int i = 0; i < c; ++i) {
                AnalyticalField field = this.getFieldSet().getField(i);
                if (!field.isDimension()) continue;
                Object value = dimKey.getMember(dimCount++);
                String text = this.formatValue(value, field);
                this.addLinkageKeywordValueToRow(row, value, text);
            }
        }
    }

    private void makeAffectionSrc(GridChartModel.Row row, CompositeKey dimKey) {
        if (this.getDesignProperty().getAffectionSrcField() != null) {
            int dimCount = 0;
            int c = this.getFieldSet().getFieldCount();
            for (int i = 0; i < c; ++i) {
                AnalyticalField field = this.getFieldSet().getField(i);
                if (field == this.getDesignProperty().getAffectionSrcField()) {
                    Object value = dimKey.getMember(dimCount);
                    String text = this.formatValue(value, field);
                    this.setAffectionSrcToRow(row, value, text);
                }
                if (!field.isDimension()) continue;
                ++dimCount;
            }
        }
    }

    private String parseCustomText(int colIdx, String customText, int rowNum, CompositeKey dimKey, Aggregator[] aggs) {
        StringBuilder text = new StringBuilder(customText);
        if (text.indexOf("${") >= 0) {
            FieldSet fieldSet = this.getFieldSet();
            int c = fieldSet.getFieldCount() + 1;
            for (int i = 0; i < c; ++i) {
                String src = "${" + i + "}$";
                String dest = null;
                int charIdxFrom = text.indexOf(src);
                if (charIdxFrom < 0) continue;
                if (i == 0) {
                    dest = String.valueOf(rowNum);
                } else {
                    int fieldIdx = i - 1;
                    AnalyticalField field = fieldSet.getField(fieldIdx);
                    Integer dimensionIdx = this._dimensionSearcher.get(field);
                    if (dimensionIdx != null) {
                        Object value = dimKey.getMember(dimensionIdx);
                        dest = this.formatValue(value, field);
                    } else {
                        Integer measureIdx = this._measureSearcher.get(field);
                        if (measureIdx != null) {
                            BigDecimal value = aggs[measureIdx].getNumberValue();
                            dest = this.formatNumber(value, field);
                        }
                    }
                }
                if (dest == null) continue;
                this._staticTextMark.put(colIdx, false);
                do {
                    int charIdxTo = charIdxFrom + src.length();
                    text.replace(charIdxFrom, charIdxTo, dest);
                } while ((charIdxFrom = text.indexOf(src)) >= 0);
            }
        }
        return text.toString();
    }

    @Override
    protected void makeHeaderFooter(GridChartModel chart) {
        CustomListChartProperty.ContentPanel tail;
        Cuboid totalCuboid;
        boolean cuboidEmpty = this.getCuboid().getCellCount() == 0;
        Cuboid cuboid = totalCuboid = cuboidEmpty ? null : this.getGrandTotalCuboid();
        if (totalCuboid == null) {
            totalCuboid = this.getCuboid();
        }
        CompositeKey dimKey = new CompositeKey();
        int c = totalCuboid.getDimensionFields().size();
        for (int i = 0; i < c; ++i) {
            dimKey.addMember("com.kingdee.bos.qing.All");
        }
        Aggregator[] aggs = totalCuboid.getNullableCellAggregators(dimKey);
        CustomListChartProperty.ContentPanel head = this.getDesignProperty().getHeadPanel();
        if (head != null) {
            GridChartModel.Row row = chart.getHeader();
            this.makeHeaderOrFooter(head, aggs, row);
        }
        if ((tail = this.getDesignProperty().getTailPanel()) != null && !cuboidEmpty) {
            GridChartModel.Row row = chart.getFooter();
            this.makeHeaderOrFooter(tail, aggs, row);
        }
    }

    private void makeHeaderOrFooter(CustomListChartProperty.ContentPanel headOrTail, Aggregator[] aggs, GridChartModel.Row row) {
        List<CustomListChartProperty.ContentArea> areas = headOrTail.getAreas();
        for (int i = 0; i < areas.size(); ++i) {
            String text = null;
            Object value = null;
            boolean done = false;
            CustomListChartProperty.ContentArea area = areas.get(i);
            AnalyticalField field = area.getBoundField();
            if (field != null) {
                Integer dimensionIdx = this._dimensionSearcher.get(field);
                if (dimensionIdx != null) {
                    text = "*";
                    done = true;
                } else {
                    Integer measureIdx = this._measureSearcher.get(field);
                    if (measureIdx != null && aggs != null) {
                        value = aggs[measureIdx].getNumberValue();
                        text = this.formatNumber((BigDecimal)value, field);
                        done = true;
                    }
                }
            }
            if (!done) {
                text = area.getCustomText();
                value = text;
            }
            GridChartModel.Cell cell = row.addOneCell(text);
            cell.setValue(value);
            this.makeCellStyle(area, cell);
        }
    }

    private void makeCellStyle(CustomListChartProperty.ContentArea area, GridChartModel.Cell cell) {
        CustomListChartProperty.CommonStyle cs = area.getStyle();
        Map<String, Object> styleMap = cs.toMap();
        if (styleMap != null) {
            cell.setStyleIndex(this.mergeStoreStyle(cell.getStyleIndex(), styleMap));
        }
    }
}

