/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Dial;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.DialChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

class MakerForDial
extends AbstractSquareViewMaker {
    MakerForDial() {
    }

    private Dial getDesignChart() {
        return (Dial)this.getModel().getChartModel();
    }

    private DialChartProperty getDesignChartProperty() {
        return (DialChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        if (this.getDesignChart().getMeasure().getFieldCount() > 0) {
            chart.addCategory(new AbstractNormalChartModel.Category());
            Cuboid cuboid = this.getCuboid();
            Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
            if (itKeys.hasNext()) {
                Aggregator[] aggs = cuboid.getCellAggregators(itKeys.next());
                Aggregator agg = aggs[0];
                BigDecimal measure = agg.getNumberValue();
                this.makePointerValue(chart, measure);
                this.outputSections(chart, aggs);
            } else {
                this.makePointerValue(chart, this.getDataEmptyInstead());
                this.outputSections(chart, null);
            }
        }
        return chart;
    }

    private BigDecimal getSectionBoundary(DialChartProperty.Section section, Aggregator[] aggs) {
        BigDecimal value = null;
        if (section.getRuntimeMeasureIndex() >= 0) {
            if (aggs != null) {
                Aggregator agg = aggs[section.getRuntimeMeasureIndex()];
                value = agg.getNumberValue();
            }
        } else if (section.getEndValue() != null) {
            try {
                value = new BigDecimal(section.getEndValue());
            }
            catch (NumberFormatException ex) {
                value = null;
            }
        }
        return value;
    }

    private void outputSections(MultiSeriesChartModel chart, Aggregator[] aggs) {
        int sectionCount = this.getDesignChartProperty().getSectionCount();
        if (sectionCount > 1) {
            DialChartProperty.Section section0 = this.getDesignChartProperty().getSection(0);
            BigDecimal startValue = this.getSectionBoundary(section0, aggs);
            for (int i = 1; i < sectionCount; ++i) {
                DialChartProperty.Section section = this.getDesignChartProperty().getSection(i);
                BigDecimal endValue = this.getSectionBoundary(section, aggs);
                String start = startValue == null ? "0" : startValue.toString();
                String end = endValue == null ? "0" : endValue.toString();
                AbstractNormalChartModel.AxisValueScope avs = chart.addValueScope(start, end);
                avs.setTitle(section.getLabel());
                avs.setColor(section.getColor());
                startValue = endValue;
            }
        }
    }

    private void makePointerValue(MultiSeriesChartModel chart, BigDecimal measureValue) {
        AnalyticalField measureField = this.getCuboid().getMeasureField(0);
        String measureTitle = this.getMeasureTitle(measureField);
        AbstractNormalChartModel.Series series = chart.addSeries(measureTitle);
        series.setFormatString(measureField.getUsableNumberFormat());
        List<AbstractNormalChartModel.INode> nodes = series.getCategoryFitnessNodeList(1);
        AbstractNormalChartModel.Node node = this.createNodeNotNull(measureValue, measureField);
        nodes.set(0, node);
    }

    private BigDecimal getDataEmptyInstead() {
        BigDecimal dataEmptyInstead;
        try {
            dataEmptyInstead = new BigDecimal(this.getDesignChartProperty().getDataEmptyInstead());
        }
        catch (NumberFormatException ex) {
            dataEmptyInstead = BigDecimal.ZERO;
        }
        return dataEmptyInstead;
    }
}

