/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.flattening.square.AbstractSimilarListMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Grid;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.GridChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.Style;
import com.kingdee.bos.qing.core.model.exhibition.square.GridChartModel;
import java.math.BigDecimal;

class MakerForGrid
extends AbstractSimilarListMaker {
    MakerForGrid() {
    }

    private Grid getDesignModel() {
        return (Grid)this.getModel().getChartModel();
    }

    private GridChartProperty getDesignProperty() {
        return (GridChartProperty)this.getDesignModel().getChartProperty();
    }

    @Override
    protected FieldSet getFieldSet() {
        return this.getDesignModel().getColumnSet();
    }

    @Override
    protected int getColumnNumberOffset() {
        return this.getDesignProperty().isShowRowNum() ? -1 : 0;
    }

    @Override
    protected void makeColumns(GridChartModel chart) {
        if (this.getDesignProperty().isShowRowNum()) {
            GridChartModel.Column column = this.addOneColumn(chart, "right");
            column.setTitle(this.getDesignProperty().getTitleOfRowNum());
        }
        int c = this.getFieldSet().getFieldCount();
        for (int i = 0; i < c; ++i) {
            AnalyticalField field = this.getFieldSet().getField(i);
            String align = field.isMeasure() ? "right" : null;
            String title = field.getTitle(this.getI18nContext());
            GridChartModel.Column column = this.addOneColumn(chart, align);
            column.setTitle(title);
        }
    }

    private GridChartModel.Column addOneColumn(GridChartModel chart, String align) {
        GridChartModel.Column column = chart.addOneColumn();
        if (align != null) {
            Style style = new Style();
            style.setAlign(align);
            column.setStyleIndex(this.getStyleStorage().store(style));
        }
        return column;
    }

    @Override
    protected void makeOneRow(int rowNum, GridChartModel.Row row, CompositeKey dimKey) {
        if (this.getDesignProperty().isShowRowNum()) {
            BigDecimal value = new BigDecimal(rowNum);
            String text = Integer.toString(rowNum);
            this.addOneCell(row, value, text);
        }
        boolean hasLinkageTarget = this.getDesignProperty().hasLinkageTarget();
        AnalyticalField affectionSrcField = this.getDesignProperty().getAffectionSrcField();
        Aggregator[] aggs = this.getCuboid().getCellAggregators(dimKey);
        int dimCount = 0;
        int msuCount = 0;
        int c = this.getFieldSet().getFieldCount();
        for (int i = 0; i < c; ++i) {
            String text;
            Object value;
            AnalyticalField field = this.getFieldSet().getField(i);
            if (field.isDimension()) {
                value = dimKey.getMember(dimCount++);
                text = this.formatValue(value, field);
                if (hasLinkageTarget) {
                    this.addLinkageKeywordValueToRow(row, value, text);
                }
                if (field == affectionSrcField) {
                    this.setAffectionSrcToRow(row, value, text);
                }
            } else {
                value = aggs[msuCount++].getNumberValue();
                text = this.formatNumber((BigDecimal)value, field);
            }
            this.addOneCell(row, value, text);
        }
    }

    private void addOneCell(GridChartModel.Row row, Object value, String text) {
        GridChartModel.Cell cell = row.addOneCell(text);
        cell.setValue(value);
    }

    @Override
    protected void makeHeaderFooter(GridChartModel chart) {
    }

    @Override
    protected void postMake(GridChartModel chart) {
    }
}

