/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.TreeChartHandler;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.square.chart.RectTree;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RectTreeChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeChartModel;
import java.math.BigDecimal;

class MakerForRectTree
extends AbstractSquareViewMaker {
    private TreeChartHandler _treeChartHandler;

    MakerForRectTree() {
    }

    private RectTree getDesignChart() {
        return (RectTree)this.getModel().getChartModel();
    }

    private RectTreeChartProperty getDesignChartProperty() {
        return (RectTreeChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    @Override
    protected boolean cutTooLargeChart(AbstractChartModel chart) {
        return this._treeChartHandler.isCutTooLarge();
    }

    @Override
    protected AbstractSquareViewMaker.AbstractColorValueMaker createColorValueMaker() {
        AnalyticalField continuousColorField = this._treeChartHandler.getContinuousColorField();
        if (continuousColorField != null) {
            ContinuousColor colorDefine = this.getDesignChartProperty().getContinuousColor();
            String legendFormat = this.getDesignChartProperty().getLegendFormat();
            return super.createContinuousColorValueMaker(continuousColorField, colorDefine, legendFormat);
        }
        return super.createColorValueMaker();
    }

    private AbstractSquareViewMaker.ContinuousColorValueMaker getContinuousColorValueMaker() {
        return (AbstractSquareViewMaker.ContinuousColorValueMaker)this.getColorValueMaker();
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this._treeChartHandler = new TreeChartHandler();
        this._treeChartHandler.setI18nContext(this.getI18nContext());
        this._treeChartHandler.setChartProperty(this.getDesignChartProperty().isHideNegative(), null);
        this._treeChartHandler.setCuboid(this.getCuboid());
        this._treeChartHandler.setHandlerRelative(new TreeChartHandler.AbstractRelative(){

            @Override
            public String formatValue(Object value, AnalyticalField analyticalField) {
                return MakerForRectTree.this.formatValue(value, analyticalField);
            }

            @Override
            public String formatNumber(BigDecimal value, AnalyticalField analyticalField) {
                return MakerForRectTree.this.formatNumber(value, analyticalField);
            }

            @Override
            public String encodeCategoryValue(Object categoryValue, String label) {
                return MakerForRectTree.encodeCategoryValue(categoryValue, label);
            }

            @Override
            public String getDefaultColor() {
                return MakerForRectTree.this.makeDiscreteColorValue(new AbstractChartModel.OrderingObject(""), "", true);
            }

            @Override
            public String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text) {
                return MakerForRectTree.this.makeDiscreteColorValue(object, text, false);
            }

            @Override
            public String makeContinuousColorValue(BigDecimal measureValue, Scope scope, AnalyticalField colorField) {
                return MakerForRectTree.this.getContinuousColorValueMaker().makeContinuousColorValue(measureValue, scope);
            }
        });
        this.parseDesignModel();
        TreeChartModel chart = this._treeChartHandler.makeChartModel();
        return chart;
    }

    private void parseDesignModel() {
        AnalyticalField colorField;
        int colorDimensionIdx;
        if (this.getDesignChart().getMeasureSet().getFieldCount() > 0) {
            AnalyticalField field = this.getDesignChart().getMeasureSet().getField(0);
            int measureIdx = 0;
            this._treeChartHandler.setSizeDefine(field, measureIdx);
        }
        if ((colorDimensionIdx = this.getDesignChart().getDimensionAsColor()) >= 0) {
            AnalyticalField colorField2 = this.getDesignChart().getDimensionSet().getField(colorDimensionIdx);
            this._treeChartHandler.setDiscreteColorDefine(colorField2, colorDimensionIdx);
        } else if (this.getDesignChart().getColorSet().getFieldCount() > 0 && (colorField = this.getDesignChart().getColorSet().getField(0)).isMeasure()) {
            if (colorField.isProperty()) {
                this._treeChartHandler.setDiscreteColorDefine(colorField, -1);
            } else {
                this._treeChartHandler.setContinueColorDefine(colorField, new Scope());
            }
        }
    }
}

