/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.filter;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.IDiscretePreparedValue;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class DiscreteFilter
extends AbstractAnalyticalFilter {
    public static final String PERSISTENT_FILTER_NAME = "discrete";
    private boolean exclude;
    private List<String> selected;
    private CtrlType ctrl;
    private Boolean treeSelectingIncludeSubs;

    public DiscreteFilter() {
        super(PERSISTENT_FILTER_NAME);
    }

    @Override
    public boolean isAllAccepted() {
        return this.isFullValue() && !this.isExclude();
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public void setSelecteds(List<String> selecteds) {
        this.selected = selecteds;
    }

    public List<String> getSelecteds() {
        return this.selected;
    }

    public void setCtrlType(CtrlType ctrl) {
        this.ctrl = ctrl;
    }

    public CtrlType getCtrlType() {
        return this.ctrl;
    }

    @Override
    public void safety() {
        this.selected.clear();
        this.setFullValue(true);
    }

    @Override
    public void parseForBeforeRun() {
    }

    @Override
    public AbstractScopeLimitedSelectedValues.DiscreteScopeLimitedSelectedValues getSlicedSelectValuesWithinScope(AbstractPreparedValue preparedValue) {
        int beforeSize = this.selected.size();
        List<? extends IDiscretePreparedValue.IDiscreteItem> selectableItems = ((IDiscretePreparedValue)((Object)preparedValue)).getValues();
        HashSet<String> selectableValueSet = new HashSet<String>(selectableItems.size());
        for (IDiscretePreparedValue.IDiscreteItem iDiscreteItem : selectableItems) {
            selectableValueSet.add(iDiscreteItem.getValue());
        }
        this.removeNotExistValueFromSelected(selectableValueSet);
        if (this.selected.size() != beforeSize) {
            return new AbstractScopeLimitedSelectedValues.DiscreteScopeLimitedSelectedValues(this.selected);
        }
        return null;
    }

    private void removeNotExistValueFromSelected(Set<String> selectableValueSet) {
        Iterator<String> alreadySelectIterator = this.selected.iterator();
        while (alreadySelectIterator.hasNext()) {
            String currentSelectedValue = alreadySelectIterator.next();
            if (selectableValueSet.contains(currentSelectedValue)) continue;
            alreadySelectIterator.remove();
        }
    }

    @Override
    protected void toXmlImpl(Element node) {
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"exclude", (boolean)this.exclude);
        int c = this.selected.size();
        for (int i = 0; i < c; ++i) {
            Element nodeItem = new Element("Selected");
            String value = this.selected.get(i);
            if (value == null) {
                nodeItem.setAttribute("special", "null");
            } else if (value.length() == 0) {
                nodeItem.setAttribute("special", "empty");
            } else {
                XmlUtil.addCDATA((Element)nodeItem, (String)value);
            }
            node.addContent((Content)nodeItem);
        }
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"selectingIncludeSubs", (Boolean)this.treeSelectingIncludeSubs);
        if (this.ctrl != null) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"ctrlType", (String)this.ctrl.toPersistance());
        }
    }

    @Override
    protected void fromXmlImpl(Element node) throws PersistentModelParseException {
        this.exclude = XmlUtil.readAttrDefaultFalse((Element)node, (String)"exclude");
        List children = XmlUtil.getChildren((Element)node, (String)"Selected");
        this.selected = new ArrayList<String>(children.size());
        int c = children.size();
        for (int i = 0; i < c; ++i) {
            Element nodeItem = (Element)children.get(i);
            String value = XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"value");
            if (value == null) {
                String special = nodeItem.getAttributeValue("special");
                if ("null".equals(special)) {
                    value = null;
                } else if ("empty".equals(special)) {
                    value = "";
                } else {
                    value = nodeItem.getText();
                    if (value.length() == 0) {
                        value = null;
                    }
                }
            }
            this.selected.add(value);
        }
        this.treeSelectingIncludeSubs = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"selectingIncludeSubs");
        String ctrlType = XmlUtil.readAttrWhenExist((Element)node, (String)"ctrlType");
        this.ctrl = ctrlType == null ? null : CtrlType.fromPersistance(ctrlType);
    }

    @Override
    protected DiscreteFilter doCopy() {
        DiscreteFilter discreteFilter = new DiscreteFilter();
        discreteFilter.exclude = this.exclude;
        if (this.selected != null) {
            discreteFilter.selected = new ArrayList<String>(this.selected);
        }
        return discreteFilter;
    }

    public static enum CtrlType {
        Checkbox_List,
        Checkbox_Popup,
        RadioButton_List,
        RadioButton_Popup;


        public String toPersistance() {
            return this.name();
        }

        public static CtrlType fromPersistance(String name) {
            try {
                return CtrlType.valueOf(name);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

