/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.parser;

import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.brief.BriefOutputFunctions;
import com.kingdee.bos.qing.core.model.parser.AbstractFormulaParserPool;
import com.kingdee.bos.qing.core.model.parser.SharedFunctionProvider;

public class BriefOutputScriptParser
extends AbstractFormulaParserPool {
    private static final BriefOutputScriptParser INST = new BriefOutputScriptParser();
    private static final SharedFunctionProvider FP = new SharedFunctionProvider();

    private BriefOutputScriptParser() {
    }

    public static IExpr parseConditionFilter(String formula) throws ParserException {
        ConditionFilterRelativedExprConfirmer refConfirmer = new ConditionFilterRelativedExprConfirmer();
        return INST.parseImpl(FP, formula, refConfirmer);
    }

    public static IExpr parsePostScript(String formula) throws ParserException {
        PostScriptRelativedExprConfirmer refConfirmer = new PostScriptRelativedExprConfirmer();
        return INST.parseImpl(FP, formula, refConfirmer);
    }

    static {
        FP.regist(new BriefOutputFunctions.EachRow());
        FP.regist(new BriefOutputFunctions.TopRows());
        FP.regist(new BriefOutputFunctions.Rank());
        FP.regist(new BriefOutputFunctions.RankTop());
        FP.regist(new BriefOutputFunctions.RowsCount());
    }

    private static class PostScriptRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private PostScriptRelativedExprConfirmer() {
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            throw new ParserException(11, expr.getCharIndexAtFormula());
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
            throw new ParserException(17, expr.getCharIndexAtFormula());
        }
    }

    private static class ConditionFilterRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private ConditionFilterRelativedExprConfirmer() {
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            throw new ParserException(11, expr.getCharIndexAtFormula());
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
            if (!"VALUE".equalsIgnoreCase(expr.getName())) {
                throw new ParserException(17, expr.getCharIndexAtFormula());
            }
            expr.setReturnDataType(0);
        }
    }
}

