/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.square;

import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRenderForDial;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRenderForRectTree;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRenderForSunburst;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForArea;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForBar;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForColumn;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForComposite;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForCustomList;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForFunnel;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForGrid;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForKPI;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForLine;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForPercentArea;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForPercentStackBar;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForPercentStackColumn;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForPie;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForProgressBar;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForProgressCircle;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForProgressColumn;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForRadar;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForRing;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForRose;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForScatter;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForStackBar;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForStackColumn;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererForWaterfall;
import com.kingdee.bos.qing.export.chart.renderer.square.IChartDrawable;
import java.util.HashMap;
import java.util.Map;

public class ChartRendererFactory {
    private static Map<SquareChartType, IChartDrawable> map = new HashMap<SquareChartType, IChartDrawable>();

    public static IChartDrawable getRenderer(SquareChartType chartType) {
        return map.get((Object)chartType);
    }

    static {
        map.put(SquareChartType.Line, new ChartRendererForLine());
        map.put(SquareChartType.Column, new ChartRendererForColumn());
        map.put(SquareChartType.StackedColumn, new ChartRendererForStackColumn());
        map.put(SquareChartType.PercentStackedColumn, new ChartRendererForPercentStackColumn());
        map.put(SquareChartType.Bar, new ChartRendererForBar());
        map.put(SquareChartType.StackedBar, new ChartRendererForStackBar());
        map.put(SquareChartType.PercentStackedBar, new ChartRendererForPercentStackBar());
        map.put(SquareChartType.Area, new ChartRendererForArea());
        map.put(SquareChartType.PercentArea, new ChartRendererForPercentArea());
        map.put(SquareChartType.Pie, new ChartRendererForPie());
        map.put(SquareChartType.Rose, new ChartRendererForRose());
        map.put(SquareChartType.KPI, new ChartRendererForKPI());
        map.put(SquareChartType.Radar, new ChartRendererForRadar());
        map.put(SquareChartType.ProgressBar, new ChartRendererForProgressBar());
        map.put(SquareChartType.ProgressColumn, new ChartRendererForProgressColumn());
        map.put(SquareChartType.ProgressCircle, new ChartRendererForProgressCircle());
        map.put(SquareChartType.Composite, new ChartRendererForComposite());
        map.put(SquareChartType.Grid, new ChartRendererForGrid());
        map.put(SquareChartType.Ring, new ChartRendererForRing());
        map.put(SquareChartType.Waterfall, new ChartRendererForWaterfall());
        map.put(SquareChartType.Funnel, new ChartRendererForFunnel());
        map.put(SquareChartType.Scatter, new ChartRendererForScatter());
        map.put(SquareChartType.Dial, new ChartRenderForDial());
        map.put(SquareChartType.RectTree, new ChartRenderForRectTree());
        map.put(SquareChartType.Sunburst, new ChartRenderForSunburst());
        map.put(SquareChartType.CustomList, new ChartRendererForCustomList());
    }
}

