/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.excel;

public class ExcelNumberFormater {
    private static char DEFAULT_DECIMALSYMBOL = (char)46;
    private static char DEFAULT_GROUPINGSYMBOL = (char)44;
    private static char EXCEL_TRANSFERRED_CHAR = (char)92;
    private FormatString[] formatStrings;
    private String thousandGroupFormatString = "";
    private int _unitPower;
    private boolean _isTenThousandGroup = false;
    private String _decimalPlace;

    public ExcelNumberFormater(String formatStr) {
        this.parse(formatStr);
    }

    public String getBaseFormatString() {
        StringBuilder baseFormatString = new StringBuilder();
        if (this._decimalPlace == null) {
            baseFormatString.append("0");
            if (this._unitPower < 0) {
                baseFormatString.append(".");
            }
        } else {
            baseFormatString.append(0 + this._decimalPlace);
        }
        if (this._unitPower < 0) {
            int zeroCount = Math.abs(this._unitPower);
            for (int index = 0; index < zeroCount; ++index) {
                baseFormatString.append("0");
            }
        }
        return baseFormatString.toString();
    }

    public String getUsableFormatString(double value) {
        if (this._isTenThousandGroup) {
            return this.getUnitFormatString(value, 10000);
        }
        if (this._unitPower == -3 || this._unitPower == -2 || this._unitPower == 0 || this._unitPower == 3 || this._unitPower == 6 || this._unitPower == 9 || this._unitPower == 12) {
            return this.thousandGroupFormatString;
        }
        return this.getUnitFormatString(value, 1000);
    }

    private String getUnitFormatString(double value, int groupUnit) {
        if (this._unitPower > 0) {
            value /= Math.pow(10.0, Math.abs(this._unitPower));
        } else if (this._unitPower < 0 && this._unitPower != -3) {
            value *= Math.pow(10.0, Math.abs(this._unitPower));
        }
        StringBuilder format = new StringBuilder();
        for (FormatString formatString : this.formatStrings) {
            format.append(formatString.getPrefix());
            format.append(this.getUnitFormatPure(value, groupUnit));
            format.append(formatString.getSuffix());
            format.append(";");
        }
        format.deleteCharAt(format.length() - 1);
        return format.toString();
    }

    private String getUnitFormatPure(double value, int groupUnit) {
        String middleStr = "";
        if (groupUnit == 1000) {
            middleStr = "\\,###";
        } else if (groupUnit == 10000) {
            middleStr = "\\,####";
        }
        StringBuilder prue = new StringBuilder();
        prue.append("#0");
        while (value > (double)groupUnit) {
            value /= (double)groupUnit;
            prue.append(middleStr);
        }
        switch (this._unitPower) {
            case -3: 
            case -2: 
            case 0: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                prue.append(this._decimalPlace == null ? "" : this._decimalPlace);
                break;
            }
            case 2: {
                prue.append("\\.00");
                break;
            }
            case 4: {
                prue.append("\\.0,");
                break;
            }
            case 5: {
                prue.append("\\.00,");
                break;
            }
            case 7: {
                prue.append("\\.0,,");
                break;
            }
            case 8: {
                prue.append("\\.00,,");
                break;
            }
            case 10: {
                prue.append("\\.0,,,");
                break;
            }
            case 11: {
                prue.append("\\.00,,,");
            }
        }
        return prue.toString();
    }

    private void parse(String formatStr) {
        if (formatStr == null) {
            formatStr = "#,##0.00";
        }
        String[] split = formatStr.split(";");
        this.formatStrings = new FormatString[split.length];
        for (int j = 0; j < split.length; ++j) {
            this.formatStrings[j] = new FormatString(split[j]);
            this.thousandGroupFormatString = this._unitPower == 0 ? this.thousandGroupFormatString + this.formatStrings[j].getFormatString() + "_ ;" : this.thousandGroupFormatString + this.formatStrings[j].getFormatString() + ";";
        }
        this.thousandGroupFormatString = this.thousandGroupFormatString.substring(0, this.thousandGroupFormatString.length() - 1);
    }

    class FormatString {
        private String _pure;
        private String _prefix;
        private String _suffix;

        public FormatString(String customString) {
            this.parse(customString);
        }

        public String getFormatString() {
            return this._prefix + this._pure + this._suffix;
        }

        public String getPure() {
            return this._pure;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getSuffix() {
            return this._suffix;
        }

        private void parse(String customString) {
            char chr;
            int i;
            int zeroIdx;
            int rightBraceIdx;
            int leftBraceIdx = customString.indexOf(123);
            if (leftBraceIdx >= 0 && (rightBraceIdx = customString.indexOf(125)) > leftBraceIdx + 1) {
                String sacle = customString.substring(leftBraceIdx + 1, rightBraceIdx);
                try {
                    ExcelNumberFormater.this._unitPower = Integer.parseInt(sacle);
                    customString = customString.substring(0, leftBraceIdx) + customString.substring(rightBraceIdx + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int pureStart = -1;
            int pureEnd = -1;
            int sharpIdx = customString.indexOf(35);
            int lastSharpIdx = customString.lastIndexOf(35);
            pureStart = sharpIdx;
            pureEnd = lastSharpIdx + 1;
            if (lastSharpIdx - sharpIdx == 4) {
                ExcelNumberFormater.this._isTenThousandGroup = true;
            }
            if (sharpIdx >= 0 && !ExcelNumberFormater.this._isTenThousandGroup) {
                for (int i2 = sharpIdx + 1; i2 < lastSharpIdx; ++i2) {
                    char chr2 = customString.charAt(i2);
                    if (chr2 == '#' || chr2 == DEFAULT_GROUPINGSYMBOL) continue;
                    customString = customString.substring(0, i2) + DEFAULT_GROUPINGSYMBOL + customString.substring(i2 + 1);
                }
            }
            if ((zeroIdx = customString.indexOf(48)) >= 0) {
                int lastZeroIdx = customString.lastIndexOf(48);
                for (i = zeroIdx + 1; i < lastZeroIdx; ++i) {
                    chr = customString.charAt(i);
                    if (chr == '0') continue;
                    if (chr != DEFAULT_DECIMALSYMBOL) {
                        customString = customString.substring(0, i) + DEFAULT_DECIMALSYMBOL + customString.substring(i + 1);
                    }
                    ExcelNumberFormater.this._decimalPlace = customString.substring(i, lastZeroIdx + 1);
                }
                pureStart = pureStart < 0 ? zeroIdx : Math.min(pureStart, zeroIdx);
                pureEnd = Math.max(pureEnd, lastZeroIdx + 1);
            }
            if (pureStart >= 0) {
                this._prefix = customString.substring(0, pureStart);
                this._pure = customString.substring(pureStart, pureEnd);
            } else {
                this._prefix = "";
                this._pure = "";
            }
            if (pureEnd >= 0) {
                this._suffix = customString.substring(pureEnd);
            }
            StringBuilder prefix = new StringBuilder();
            for (i = 0; i < this._prefix.length(); ++i) {
                chr = this._prefix.charAt(i);
                prefix.append(EXCEL_TRANSFERRED_CHAR).append(chr);
            }
            this._prefix = prefix.toString();
            StringBuilder suffix = new StringBuilder();
            for (int i3 = 0; i3 < this._suffix.length(); ++i3) {
                char chr3 = this._suffix.charAt(i3);
                if (chr3 == '%' && ExcelNumberFormater.this._unitPower == -2) {
                    suffix.append(chr3);
                    continue;
                }
                if (chr3 == '\u2030') continue;
                suffix.append(EXCEL_TRANSFERRED_CHAR).append(chr3);
            }
            this._suffix = suffix.toString();
            switch (ExcelNumberFormater.this._unitPower) {
                case -2: {
                    break;
                }
                case 3: {
                    this._suffix = "," + this._suffix;
                    break;
                }
                case 6: {
                    this._suffix = ",," + this._suffix;
                    break;
                }
                case 9: {
                    this._suffix = ",,," + this._suffix;
                    break;
                }
                case 12: {
                    this._suffix = ",,,," + this._suffix;
                    break;
                }
            }
        }
    }
}

