//轻分析图表控件数据模型
//Copyright (c) 2017 金蝶软件(中国)有限公司
//
//第三方依赖： 
//无
//
//依赖：
//qing-common.js
//

(function()
{
	if(typeof(com) == "undefined") com = {};
	if(typeof(com.kingdee) == "undefined") com.kingdee = {};
	if(typeof(com.kingdee.bos) == "undefined") com.kingdee.bos = {};
	if(typeof(com.kingdee.bos.qing) == "undefined") com.kingdee.bos.qing = {};
	if(typeof(com.kingdee.bos.qing.chart) == "undefined") com.kingdee.bos.qing.chart = {};
	if(typeof(com.kingdee.bos.qing.chart.model) == "undefined") com.kingdee.bos.qing.chart.model = {};
	
	var NS = com.kingdee.bos.qing.chart.model;
	
	NS.NormalChartModel = NormalChartModel;
	NS.Category = Category;
	NS.Series = Series;
	NS.Node = Node;
	NS.XYNode = XYNode;
	NS.AxisValueScope = AxisValueScope;
	NS.Refline = PaintableLine;
	
	NS.GridChartModel = GridChartModel;
	
	NS.TreeChartModel = TreeChartModel;
	
	NS.DiscreteColorLegendModel = DiscreteColorLegendModel;
	NS.ContinuousColorLegendModel = ContinuousColorLegendModel;
	
	NS.AbstractAttr = AbstractAttr;
	NS.CommonAttr = CommonAttr;
	NS.PieAttr = PieAttr;
	NS.YNXSAttr = YNXSAttr;
	NS.YSXNAttr = YSXNAttr;
	NS.ScatterAttr = ScatterAttr;
	NS.LineAttr = LineAttr;
	NS.CompositeAttr = CompositeAttr;
	NS.MapAttr = MapAttr;
	NS.GISAttr = GISAttr;
	NS.RadarAttr = RadarAttr;
	NS.AbstractXYProgressAttr = AbstractXYProgressAttr;
	NS.ProgressBarAttr = ProgressBarAttr;
	NS.ProgressColumnAttr = ProgressColumnAttr;
	NS.ProgressCircleAttr = ProgressCircleAttr;
	NS.DialAttr = DialAttr;
	NS.GridAttr = GridAttr;
	NS.CustomListAttr = CustomListAttr;
	NS.WaterfallAttr = WaterfallAttr;
	NS.FunnelAttr = FunnelAttr;
	NS.RectTreeAttr = RectTreeAttr;
	NS.SunburstAttr = SunburstAttr;
	
	NS.SelectionModel = SelectionModel;
	NS.StringSelectionModel = StringSelectionModel;
	NS.RowSelectionModel = RowSelectionModel;
	
	var BlocksToTable;
	(function()
	{
		var oPackage = com.kingdee.bos.qing.common;
		BlocksToTable = oPackage.BlocksToTable;
	})();
	
	/** 斗方列表的数据模型 */
	function GridChartModel()
	{
		var _arrColumn;
		var _arrRow;
		var _oHeader;
		var _oFooter;
		
		this.getColumnCount = function()
		{
			return _arrColumn.length;
		}
		this.getColumn = function(iIdx)
		{
			return _arrColumn[iIdx];
		}
		
		this.getRowCount = function()
		{
			return _arrRow.length;
		}
		this.getRow = function(iIdx)
		{
			return _arrRow[iIdx];
		}
		
		this.getCustomHeader = function()
		{
			return _oHeader;
		}
		
		this.getCustomFooter = function()
		{
			return _oFooter;
		}
		
		this.getPrioritizedStyle = function(oColumn, oRow, oCell, sMethod, bWholeObject)
		{
			var arrPriority = [oCell, oRow, oColumn];
			for(var i = 0; i < arrPriority.length; i++)
			{
				var oHost = arrPriority[i];
				var oStyle = (oHost ? oHost.getStyle() : null);
				if(oStyle)
				{
					var oValue = oStyle[sMethod]();
					if(oValue !== undefined)
					{
						return (bWholeObject ? oStyle : oValue);
					}
				}
			}
			return null;
		}
		
		this.fromJsonObject = function(oJson)
		{
			var arrStyle = [];
			var arrJsonStyle = oJson["styles"];
			if(arrJsonStyle)
			{
				for(var i = 0; i < arrJsonStyle.length; i++)
				{
					var oStyle = new Style();
					oStyle.fromJsonObject(arrJsonStyle[i]);
					arrStyle.push(oStyle);
				}
			}
			
			_arrColumn = [];
			var arrJsonColumn = oJson["columns"];
			for(var i = 0; i < arrJsonColumn.length; i++)
			{
				var oColumn = new Column();
				oColumn.fromJsonObject(arrJsonColumn[i], arrStyle);
				_arrColumn.push(oColumn);
			}
			
			_arrRow = [];
			var arrJsonRow = oJson["rows"]
			for(var i = 0; i < arrJsonRow.length; i++)
			{
				var oRow = new Row();
				oRow.fromJsonObject(arrJsonRow[i], arrStyle);
				_arrRow.push(oRow);
			}
			
			_oHeader = null;
			var oJsonHeader = oJson["header"];
			if(oJsonHeader)
			{
				_oHeader = new Row();
				_oHeader.fromJsonObject(oJsonHeader, arrStyle);
			}
			
			_oFooter = null;
			var oJsonFooter = oJson["footer"];
			if(oJsonFooter)
			{
				_oFooter = new Row();
				_oFooter.fromJsonObject(oJsonFooter, arrStyle);
			}
		}
		
		function Column()
		{
			var _sTitle;
			var _oStyle;
			var _oBar;
			var _bStaticText;
			
			this.getTitle = function()
			{
				return _sTitle;
			}
			
			/** 数据条 */
			this.getBar = function()
			{
				return _oBar;
			}
			
			/** 自定义列表显示区域填写的固定文字 */
			this.isStaticText = function()
			{
				return _bStaticText;
			}
			
			this.getStyle = function()
			{
				return _oStyle;
			}
			
			this.isVisible = function()
			{
				return (_oStyle ? !_oStyle.isHide() : true);
			}
			
			this.fromJsonObject = function(oJson, arrStyle)
			{
				_sTitle = oJson["title"];
				var oJsonBar = oJson["bar"];
				_oBar = (oJsonBar ? Bar.createFromJson(oJsonBar) : null);
				var iStyleIdx = oJson["style"];
				(iStyleIdx || iStyleIdx == 0) && (_oStyle = arrStyle[iStyleIdx]);
				_bStaticText = (oJson["staticText"] ? true : false);
			}
		}
		
		function Row()
		{
			var _arrCell = [];
			var _oStyle;
			var _arrLinkageKeywordValue;
			var _sAffectionSrcValue;
			var _sAffectionSrcText;
			
			this.getCellCount = function()
			{
				return _arrCell.length;
			}
			
			this.getCell = function(iIdx)
			{
				return _arrCell[iIdx];
			}
			
			this.getStyle = function()
			{
				return _oStyle;
			}
			
			/** 联查关键字段的值 */
			this.getLinkageKeywordValues = function()
			{
				return _arrLinkageKeywordValue;
			}
			
			/** 作为联动依据的关键字段的值 */
			this.getAffectionSrcValue = function()
			{
				return _sAffectionSrcValue;
			}
			this.getAffectionSrcText = function()
			{
				return (_sAffectionSrcText ? _sAffectionSrcText : _sAffectionSrcValue);
			}
			
			this.fromJsonObject = function(oJson, arrStyle)
			{
				var arrJsonCell = oJson["cells"];
				for(var i = 0; i < arrJsonCell.length; i++)
				{
					var oCell = new Cell();
					oCell.fromJsonObject(arrJsonCell[i], arrStyle);
					_arrCell.push(oCell);
				}
				var iStyleIdx = oJson["style"];
				(iStyleIdx || iStyleIdx == 0) && (_oStyle = arrStyle[iStyleIdx]);
				_arrLinkageKeywordValue = oJson["linkage"];
				_sAffectionSrcValue = oJson["affectionSrcValue"];
				_sAffectionSrcText = oJson["affectionSrcText"];
			}
		}
		
		function Cell()
		{
			var _sContent;
			var _numNumber;
			var _oStyle;
			
			this.getContent = function()
			{
				return _sContent;
			}
			
			this.getNumber = function()
			{
				return _numNumber;
			}
			
			this.getStyle = function()
			{
				return _oStyle;
			}
			
			this.fromJsonObject = function(oJson, arrStyle)
			{
				_sContent = oJson["content"];
				var sNumber = oJson["number"];
				_numNumber = (sNumber ? parseFloat(sNumber) : null);
				var iStyleIdx = oJson["style"];
				(iStyleIdx || iStyleIdx == 0) && (_oStyle = arrStyle[iStyleIdx]);
			}
		}
		
		function Bar()
		{
			var _numMin;
			var _numMax;
			var _sMainColor;
			var _sNegativeColor;
			var _sCrossAxisColor;
			
			var _numRtMin;
			var _numRtMax;
			var _numRtZeroPosRatio;
			
			this.getScopeMin = function()
			{
				return _numMin;
			}
			
			this.getScopeMax = function()
			{
				return _numMax;
			}
			
			this.getPositiveColor = function()
			{
				return _sMainColor;
			}
			
			this.getNegativeColor = function()
			{
				return (_sNegativeColor ? _sNegativeColor : _sMainColor);
			}
			
			this.getCrossAxisColor = function()
			{
				return _sCrossAxisColor;
			}
			
			this.getRtZeroPosRatio = function()
			{
				if(_numRtZeroPosRatio === undefined)
				{
					_numRtZeroPosRatio = null;
					if((_numMin || _numMin === 0) && (_numMax || _numMax === 0))
					{
						_numRtMin = Math.min(_numMin, _numMax);
						_numRtMax = Math.max(_numMin, _numMax);
						if(_numRtMin >= 0)
						{
							_numRtZeroPosRatio = 0;
							_numRtMin = 0;
						}
						else if(_numRtMax <= 0)
						{
							_numRtZeroPosRatio = 1;
							_numRtMax = 0;
						}
						else
						{
							_numRtZeroPosRatio = -_numRtMin / (_numRtMax - _numRtMin);
						}
					}
				}
				return _numRtZeroPosRatio;
			}
			
			this.getRtValuePosRatio = function(numValue)
			{
				numValue = Math.max(_numRtMin, Math.min(_numRtMax, numValue));
				var numValuePosRatio = _numRtZeroPosRatio + numValue / (_numRtMax - _numRtMin);
				return numValuePosRatio;
			}
			
			this.fromJsonObject = function(oJson)
			{
				var sMin = oJson["scopeMin"];
				_numMin = (sMin ? parseFloat(sMin) : null);
				var sMax = oJson["scopeMax"];
				_numMax = (sMax ? parseFloat(sMax) : null);
				_sMainColor = oJson["mainColor"];
				_sNegativeColor = oJson["negativeColor"];
				_sCrossAxisColor = oJson["crossAxisColor"];
			}
		}
		Bar.createFromJson = function(oJson)
		{
			var oBar = new Bar();
			oBar.fromJsonObject(oJson);
			return oBar;
		}
	}
	GridChartModel.createFromJson = function(oJson)
	{
		var oChartModel = new GridChartModel();
		oChartModel.fromJsonObject(oJson);
		return oChartModel;
	}
	
	function Style()
	{
		var _iFontSize;
		var _sBold;//true or null
		var _sColor;
		var _sBackground;
		var _sAlign;
		var _bHide;
			
		var _oImg;
		var _arrImgDelayGetter;
		var _sIcon;
		var _sIconPos;
		var _sIconColor;
		
		this.getFontSize = function()
		{
			return _iFontSize;
		}
		
		this.getBold = function()
		{
			return _sBold;
		}
		
		this.getColor = function()
		{
			return _sColor;
		}
		
		this.getBackground = function()
		{
			return _sBackground;
		}
		
		this.isBackgroundImage = function()
		{
			return (_oImg ? true : false);
		}
		this.getBackgroundImageRect = function()
		{
			return _oImg["myRect"];
		}
		this.getBackgroundImage = function(funCallback)
		{
			if(_arrImgDelayGetter)
			{
				_arrImgDelayGetter.push(funCallback);
			}
			else
			{
				funCallback(_oImg["myState"] == "error" ? null : _oImg);
			}
		}
		
		this.isBackgroundIcon = function()
		{
			return (_sIcon ? true : false);
		}
		this.getBackgroundIconName = function()
		{
			return _sIcon;
		}
		this.isBackgroundIconBefore = function()
		{
			return _sIconPos == "before";
		}
		this.isBackgroundIconAfter = function()
		{
			return _sIconPos == "after";
		}
		this.getBackgroundIconColor = function()
		{
			return _sIconColor;
		}
		
		this.getAlign = function()
		{
			return _sAlign;
		}
		
		this.isHide = function()
		{
			return _bHide;
		}
		
		this.fromJsonObject = function(oJson)
		{
			_iFontSize = oJson["fontSize"];
			_sBold = oJson["bold"];
			_sColor = oJson["color"];
			_sBackground = oJson["background"];
			parseBackgroundImage() || parseBackgroundIcon();
			_sAlign = oJson["align"];
			_bHide = (oJson["hide"] ? true : false);
		}
		
		//"qing-img|X,Y,W,H|URL"
		var parseBackgroundImage = function()
		{
			var sPrefix = "qing-img|";
			if(!_sBackground || _sBackground.indexOf(sPrefix) != 0)
			{
				return false;
			}
			_arrImgDelayGetter = [];
			_oImg = new Image();
			_oImg.onload = doImageLoaded;
			_oImg.onerror = doImageError;
			var sNext = _sBackground.substring(sPrefix.length);
			var sUrl = sNext; 
			if(Style.REG_RECT_CHECKER.test(sNext))
			{
				var iIdx = sNext.indexOf("|");
				var sRect = sNext.substring(0, iIdx);
				sUrl = sNext.substring(iIdx + 1);
				
				var arrRect = sRect.split(",");
				for(var i = 0; i < arrRect.length; i++)
				{
					arrRect[i] = parseInt(arrRect[i]);
				}
				_oImg["myRect"] = arrRect;
			}
			_oImg.src = sUrl;
			return true;
		}
		
		var doImageLoaded = function(evt)
		{
			for(var i = 0; i < _arrImgDelayGetter.length; i++)
			{
				var funCallback = _arrImgDelayGetter[i];
				funCallback(_oImg);
			}
			_arrImgDelayGetter = null;
		}
		
		var doImageError = function(evt)
		{
			_oImg["myState"] = "error";
			for(var i = 0; i < _arrImgDelayGetter.length; i++)
			{
				var funCallback = _arrImgDelayGetter[i];
				funCallback(null);
			}
			_arrImgDelayGetter = null;
		}
		
		//"qing-icon|after|circle|#f90"
		var parseBackgroundIcon = function()
		{
			var sPrefix = "qing-icon|";
			if(!_sBackground || _sBackground.indexOf(sPrefix) != 0)
			{
				return false;
			}
			var sNext = _sBackground.substring(sPrefix.length);
			var arrPart = sNext.split("|");
			_sIconPos = arrPart[0];
			_sIcon = arrPart[1];
			_sIconColor = arrPart[2];
			return true;
		}
	}
	Style.REG_RECT_CHECKER = /^-?\d+,-?\d+,\d+,\d+\|/;
	
	
	/** 常规图表的数据模型 */
	function NormalChartModel()
	{
		var _sCategoryTitle;
		var _sSeriesFieldTitle;
		var _arrCategory;
		var _arrSeries;
		var _arrScope;
		var _arrPaintableLines;
		var _arrGuideline;
		
		/**
		 * 类别的字段名
		 */	
		this.setCategoryTitle = function(sCategoryTitle)
		{
			_sCategoryTitle = sCategoryTitle;
		}
		this.getCategoryTitle = function()
		{
			return _sCategoryTitle;
		}
		
		/** 用字段值产生多系列的字段名 */
		this.setSeriesFieldTitle = function(sSeriesFieldTitle)
		{
			_sSeriesFieldTitle = sSeriesFieldTitle;
		}
		this.getSeriesFieldTitle = function()
		{
			return _sSeriesFieldTitle;
		}
		
		/**
		 * 类别的集合
		 */
		this.setCategories = function(arrCategory)
		{
			_arrCategory = arrCategory;
		}
		this.getCategories = function()
		{
			return _arrCategory;
		}
		
		/**
		 * 系列的集合
		 * 饼图、单柱状图等是单系列的，但也描述成一个成员的多系列
		 */
		this.setSeries = function(arrSeries)
		{
			_arrSeries = arrSeries;
		}
		this.getSeries = function()
		{
			return _arrSeries;
		}
		
		/** 全局的值范围 */
		this.setScopes = function(arrScope)
		{
			_arrScope = arrScope;
		}
		this.getScopes = function()
		{
			return _arrScope;
		}
		
		/** 与Scope一一对应的各数轴上的参考线数组，其中每个元素（每个轴上）又是一个包含多条线的数组 */
		this.setPaintableLines = function(arrPaintableLines)
		{
			_arrPaintableLines = arrPaintableLines;
		}
		this.getPaintableLines = function()
		{
			return _arrPaintableLines;
		}
		
		/** 类别轴上的辅助线 */
		this.setGuidelines = function(arrGuideline)
		{
			_arrGuideline = arrGuideline;
		}
		this.getGuidelines = function()
		{
			return _arrGuideline;
		}
		
		/** [易用接口] 获取指定系列iSeriesIdx和指定类别iCategoryIdx对应的数据节点 */
		this.getNode = function(iSeriesIdx, iCategoryIdx)
		{
			var oSeries = _arrSeries[iSeriesIdx];
			var oNode = oSeries.getNodes()[iCategoryIdx];
			return oNode;
		}
		
		/** 指定的对象oCommon记录了所有图表的共有属性，将它们合并进来 */
		this.merge = function(oCommon)
		{
			var sCategoryTitle = oCommon.getCategoryTitle();
			if(sCategoryTitle)
			{
				_sCategoryTitle = sCategoryTitle;
			}
			var sSeriesFieldTitle = oCommon.getSeriesFieldTitle();
			if(sSeriesFieldTitle)
			{
				_sSeriesFieldTitle = sSeriesFieldTitle;
			}
			var arrCategory = oCommon.getCategories();
			if(arrCategory && arrCategory.length > 0)
			{
				_arrCategory = arrCategory;
			}
			
			var arrSeries = oCommon.getSeries();
			if(arrSeries && arrSeries.length > 0)
			{
				if(!_arrSeries)
				{
					_arrSeries = [];
				}
				for(var i = 0; i < arrSeries.length; i++)
				{
					var oSeries = arrSeries[i];
					var oMySeries = _arrSeries[i];
					if(!oMySeries)
					{
						oMySeries = new Series();
						_arrSeries[i] = oMySeries;
					}
					oMySeries.merge(oSeries);
				}
			}
			
			var arrScope = oCommon.getScopes();
			if(arrScope && arrScope.length > 0)
			{
				if(!_arrScope)
				{
					_arrScope = [];
				}
				for(var i = 0; i < arrScope.length; i++)
				{
					var oScope = arrScope[i];
					_arrScope[i] = oScope;
				}
			}
		}
	}
	NormalChartModel.createFromJson = function(oJsonChart)
	{
		var arrCategory = [];
		var arrSeries = [];
        var sSeriesFieldTitle = oJsonChart["seriesFieldTitle"]
		var sCategoryTitle = oJsonChart["categoryTitle"];
		var arrJsonCategory = oJsonChart["categories"];
		var arrJsonSeries = oJsonChart["series"];
		var arrJsonScope = oJsonChart["scopes"];
		var arrJsonPaintableLineArray = oJsonChart["paintableLines"];
		var arrJsonGuideline = oJsonChart["guidelines"];
		if(arrJsonCategory)
		{
			for(var i = 0; i < arrJsonCategory.length; i++)
			{
				var oJsonCategory = arrJsonCategory[i];
				var oCategory = null;
				if(oJsonCategory)
				{
					oCategory = new Category();
					oCategory.setLabel(oJsonCategory["label"]);
					oCategory.setColor(oJsonCategory["color"]);
					oCategory.setValue(oJsonCategory["value"]);
					oJsonCategory["asParent"] && oCategory.setAsParent(true);
				}
				arrCategory[i] = oCategory;
			}
		}
		if(arrJsonSeries)
		{
			for(var i = 0; i < arrJsonSeries.length; i++)
			{
				var oJosnSeries = arrJsonSeries[i];
				var oSeries = new Series();
				oSeries.setName(oJosnSeries["name"]);
				oSeries.setColor(oJosnSeries["color"]);
				oSeries.setFormatString(oJosnSeries["formatString"]);
                oSeries.setSeriesFieldValueText(oJosnSeries["seriesFieldValue"], oJosnSeries["seriesFieldText"])
                oSeries.setAxisIndex(oJosnSeries["axisIndex"]);
				var arrJsonNodes = oJosnSeries["nodes"];
				var arrNode = [];
				for(var j = 0; j < arrJsonNodes.length; j++)
				{
					var oJsonNode = arrJsonNodes[j];
					var oNode = null;
					if(oJsonNode)
					{
						var sValue = oJsonNode["value"];
						if(sValue !== undefined)
						{
							oNode = new Node();
							oNode.setValue(parseFloat(sValue));
							oNode.setText(oJsonNode["text"]);
							oNode.setColor(oJsonNode["color"]);
						}
						else if(oJsonNode["x"] !== undefined && oJsonNode["y"] !== undefined)
						{
							oNode = new XYNode();
							oNode.setXAxisValue(parseFloat(oJsonNode["x"]));
							oNode.setYAxisValue(parseFloat(oJsonNode["y"]));
							if(oJsonNode["z"])
							{
								oNode.setZAxisValue(parseFloat(oJsonNode["z"]));
							}
						}
						else
						{
							throw new Error("Unknown Series-Node type.");
						}
					}
					arrNode[j] = oNode;
				}
				oSeries.setNodes(arrNode);
				arrSeries[i] = oSeries;
			}
		}
		
		var oChartModel = new NormalChartModel();
        oChartModel.setSeriesFieldTitle(sSeriesFieldTitle);
		oChartModel.setCategoryTitle(sCategoryTitle);
		oChartModel.setCategories(arrCategory);
		oChartModel.setSeries(arrSeries);
		if(arrJsonScope)
		{
			var arrScope = [];
			oChartModel.setScopes(arrScope);
			for(var i = 0; i < arrJsonScope.length; i++)
			{
				var oJsonScope = arrJsonScope[i];
				var oScope = new AxisValueScope();
				oScope.setMin(parseFloat(oJsonScope["min"]));
				oScope.setMax(parseFloat(oJsonScope["max"]));
				oScope.setTitle(oJsonScope["title"]);
				oScope.setFormatString(oJsonScope["formatString"]);
				oScope.setColor(oJsonScope["color"]);
				oScope.setSuggestUseLog(oJsonScope["suggestLog"]);
				oScope.setLogParam(parseFloat(oJsonScope["logMin"]), parseFloat(oJsonScope["logMax"]), parseInt(oJsonScope["logOffset"]));
				var sCuttableForLinear = oJsonScope["cuttableForLinear"];
				sCuttableForLinear && oScope.setCuttableFootForLinear(parseFloat(sCuttableForLinear));
				var sCuttableForLog = oJsonScope["cuttableForLog"];
				sCuttableForLog && oScope.setCuttableFootForLog(parseInt(sCuttableForLog));
				arrScope[i] = oScope;
			}
		}
		if(arrJsonPaintableLineArray)
		{
			var arrLineArray = [];
			oChartModel.setPaintableLines(arrLineArray);
			for(var i = 0; i < arrJsonPaintableLineArray.length; i++)
			{
				var arrOneAxisLines = [];
				arrLineArray[i] = arrOneAxisLines;
				var arrJsonLines = arrJsonPaintableLineArray[i];
				for(var j = 0; j < arrJsonLines.length; j++)
				{
					var oJsonLine = arrJsonLines[j];
					if(oJsonLine)
					{
						var oLine = new PaintableLine();
						oLine.setLabel(oJsonLine["label"]);
						oLine.setLineValue(parseFloat(oJsonLine["line"]));
						oLine.setTips(oJsonLine["tipsTitle"], oJsonLine["tipsText"]);
						arrOneAxisLines[j] = oLine;
					}
				}
			}
		}
		if(arrJsonGuideline)
		{
			var arrGuideline = [];
			oChartModel.setGuidelines(arrGuideline);
			for(var i = 0; i < arrJsonGuideline.length; i++)
			{
				var oJsonLine = arrJsonGuideline[i];
				var oLine = new Guideline();
				oLine.setCategoryIndex(oJsonLine["category"]);
				oLine.setLabel(oJsonLine["label"]);
				arrGuideline.push(oLine);
			}
		}
		return oChartModel;
	}
	
	/** 
	 * 类别
	 * 类别是饼图一角的名称或柱状图一根柱子在横轴上的值，等等。<p>
	 * 类别通常是离散值，例如一个叫地区的字段的值[北京、上海、广州、深圳]，每个值是一个类别。<br>
	 * 但也可以表示连续值，例如散点图或气泡图的一个轴，此时每个类别的值表示轴上的一个刻度。<br>
	 */
	function Category()
	{
		var _sLabel;
		var _sValue;
		var _sColor;
		var _bAsParent;
		
		/** 类别名称，显示值 */
		this.setLabel = function(sLabel)
		{
			_sLabel = sLabel;
		}
		this.getLabel = function()
		{
			return _sLabel;
		}
		
		this.getDisplayLabel = function()
		{
			var sLabel = _sLabel;
			_bAsParent && (sLabel += " (+)");
			return sLabel;
		}
		
		/** “其它”记录哪些值（编码过的字符串）；当类别表示数轴上的刻度时，可以指定数值，到具体图表再转换成数字类型 */
		this.setValue = function(sValue)
		{
			_sValue = sValue;
		}
		this.getValue = function()
		{
			return _sValue;
		}
		
		this.getExecutableValue = function()
		{
			return (_sValue === undefined ? _sLabel : _sValue);
		}
		
		/** 可以给类别指定颜色 */
		this.setColor = function(sColor)
		{
			_sColor = sColor;
		}
		this.getColor = function()
		{
			return _sColor;
		}
		
		/** 在父子维中作为一个可展开的父节点 */
		this.setAsParent = function(bAsParent)
		{
			_bAsParent = bAsParent;
		}
		this.isAsParent = function()
		{
			return _bAsParent;
		}
		
		this.merge = function(oCommon)
		{
			var sColor = oCommon.getColor();
			if(sColor)
			{
				_sColor = sColor;
			}
		}
	}
	
	/**
	 * 系列
	 * 组合多个数据节点
	 */
	function Series()
	{
		var _sName;
		var _arrNode;
		var _sColor;
		var _sFormatString;
		var _sSeriesFieldText;
		var _sSeriesFieldValue;
		var _iAxisIdx = 0;
		
		/** 系列名称，也是显示值 */
		this.setName = function(sName)
		{
			_sName = sName;
		}
		this.getName = function()
		{
			return _sName;
		}
		
		/** 
		 * 数据节点
		 * 如果是散点图等，类别表示数轴上的刻度，则数据节点个数不限制；否则个数与类别一致，一一对应。 
		 */
		this.setNodes = function(arrNode)
		{
			_arrNode = arrNode;
		}
		this.getNodes = function()
		{
			return _arrNode;
		}
		
		/** 可以给系列指定颜色 */
		this.setColor = function(sColor)
		{
			_sColor = sColor;
		}
		this.getColor = function()
		{
			return _sColor;
		}
		
		/** for数轴标尺 */
		this.setFormatString = function(sFormatString)
		{
			_sFormatString = sFormatString;
		}
		this.getFormatString = function()
		{
			return _sFormatString;
		}
		
		/** 多系列字段值 */
		this.setSeriesFieldValueText = function(sSeriesFieldValue, sSeriesFieldText)
		{
			_sSeriesFieldValue = sSeriesFieldValue;
			_sSeriesFieldText = sSeriesFieldText;
		}
		this.getSeriesFieldValue = function()
		{
			return _sSeriesFieldValue;
		}
		this.getSeriesFieldText = function()
		{
			return _sSeriesFieldText;
		}
		this.getExecutableSeriesFieldValue = function()
		{
			return (_sSeriesFieldValue ? _sSeriesFieldValue : _sSeriesFieldText);
		}
		
		/** 在组合图中标明属于左轴还是右轴 */
		this.setAxisIndex = function(iAxisIdx)
		{
			_iAxisIdx = (typeof(iAxisIdx) == "number" ? iAxisIdx : 0);
		}
		this.getAxisIndex = function()
		{
			return _iAxisIdx;
		}
		
		this.merge = function(oCommon)
		{
			var sColor = oCommon.getColor();
			if(sColor)
			{
				_sColor = sColor;
			}
			var sName = oCommon.getName();
			if(sName)
			{
				_sName = sName;
			}
			var sSeriesFieldValue = oCommon.getSeriesFieldValue();
			var sSeriesFieldText = oCommon.getSeriesFieldText();
			if(sSeriesFieldValue || sSeriesFieldText)
			{
				_sSeriesFieldValue = sSeriesFieldValue;
				_sSeriesFieldText = sSeriesFieldText;
			}
		}
	}
	
	/**
	 * 数据节点
	 * 描述饼图一角的大小或柱状图一根柱子的高度（在纵轴上的值），等等。
	 */
	function Node()
	{
		var _numValue;
		var _sText;
		var _sColor;
		
		/** 数值 */
		this.setValue = function(numValue)
		{
			_numValue = numValue;
		}
		this.getValue = function()
		{
			return _numValue;
		}
		
		/** 显示值，经过格式化的数值 */
		this.setText = function(sText)
		{
			_sText = sText;
		}
		this.getText = function()
		{
			return _sText;
		}
		
		/** 条件样式特别指定的颜色 */
		this.setColor = function(sColor)
		{
			_sColor = sColor;
		}
		this.getColor = function()
		{
			return _sColor;
		}
	}
	
	/**
	 * 数据节点
	 * 用于散点图、气泡图等
	 */
	function XYNode()
	{
		var _numX;
		var _numY;
		var _numZ;
		
		this.setXAxisValue = function(numX)
		{
			_numX = numX;
		}
		this.getXAxisValue = function()
		{
			return _numX;
		}

		this.setYAxisValue = function(numY)
		{
			_numY = numY;
		}
		this.getYAxisValue = function()
		{
			return _numY;
		}
		
		this.setZAxisValue = function(numZ)
		{
			_numZ = numZ;
		}
		this.getZAxisValue = function()
		{
			return _numZ;
		}
	}
	
	/** 轴上的最大值最小值 */
	function AxisValueScope()
	{
		var _numMin;
		var _numMax;
		
		var _sTitle;
		var _sFormatString;
		var _sColor;
		
		var _numLogMin;
		var _numLogMax;
		var _iLogOffset;
		var _bSuggestUseLog = false;
		
		var _numCuttableFootForLinear = 0;
		var _iCuttableFootForLog = 0;
		
		this.setMin = function(numValue)
		{
			_numMin = numValue;
		}
		this.getMin = function()
		{
			return _numMin;
		}
		
		this.setMax = function(numValue)
		{
			_numMax = numValue;
		}
		this.getMax = function()
		{
			return _numMax;
		}
		
		this.setTitle = function(sTitle)
		{
			_sTitle = sTitle;
		}
		this.getTitle = function()
		{
			return _sTitle;
		}
		
		this.setFormatString = function(sFormatString)
		{
			_sFormatString = sFormatString;
		}
		this.getFormatString = function()
		{
			return _sFormatString;
		}
		
		this.setColor = function(sColor)
		{
			_sColor = sColor;
		}
		this.getColor = function()
		{
			return _sColor;
		}
		
		this.setSuggestUseLog = function(bSuggestUseLog)
		{
			_bSuggestUseLog = (bSuggestUseLog ? true : false);
		}
		this.isSuggestUseLog = function()
		{
			return _bSuggestUseLog;
		}
		
		this.setLogParam = function(numLogMin, numLogMax, iLogOffset)
		{
			_numLogMin = numLogMin;
			_numLogMax = numLogMax;
			_iLogOffset = iLogOffset;
		}
		
		this.getLogMin = function()
		{
			return _numLogMin;
		}
		
		this.getLogMax = function()
		{
			return _numLogMax;
		}
		
		this.getLogOffset = function()
		{
			return _iLogOffset;
		}
		
		this.setCuttableFootForLinear = function(numCuttableFoot)
		{
			_numCuttableFootForLinear = numCuttableFoot;
		}
		this.getCuttableFootForLinear = function()
		{
			return _numCuttableFootForLinear;
		}
		
		this.setCuttableFootForLog = function(iCuttableFoot)
		{
			_iCuttableFootForLog = iCuttableFoot;
		}
		this.getCuttableFootForLog = function()
		{
			return _iCuttableFootForLog;
		}
	}
	
	/** 数轴上的参考线 */
	function PaintableLine()
	{
		var _numLine;
		var _sLabel;
		var _sTipsTitle;
		var _sTipsText;
		
		this.setLineValue = function(numValue)
		{
			_numLine = numValue;
		}
		this.getLineValue = function()
		{
			return _numLine;
		}
		
		this.setLabel = function(sText)
		{
			_sLabel = sText;
		}
		this.getLabel = function()
		{
			return _sLabel;
		}
		
		this.setTips = function(sTitle, sText)
		{
			_sTipsTitle = sTitle;
			_sTipsText = sText;
		}
		this.getTipsTitle = function()
		{
			return _sTipsTitle;
		}
		this.getTipsText = function()
		{
			return _sTipsText;
		}
	}
	
	/** 类别轴上的辅助线 */
	function Guideline()
	{
		var _iCategoryIdx;
		var _sLabel;
		
		this.setCategoryIndex = function(iIdx)
		{
			_iCategoryIdx = iIdx;
		}
		this.getCategoryIndex = function()
		{
			return _iCategoryIdx;
		}
		
		this.setLabel = function(sText)
		{
			_sLabel = sText;
		}
		this.getLabel = function()
		{
			return _sLabel;
		}
	}
	
	
	function TreeChartModel()
	{
		var _arrLabelCaption;
		var _sSizeCaption;
		var _sSizeFormat;
		var _arrDetailCaption;
		var _oRoot;
		var _iNodesCount = null;
		
		this.getLabelCaptionCount = function()
		{
			return (_arrLabelCaption ? _arrLabelCaption.length : 0);
		}
		this.getLabelCaption = function(iIdx)
		{
			return _arrLabelCaption[iIdx];
		}
		
		this.getSizeCaption = function()
		{
			return _sSizeCaption;
		}
		
		this.getSizeFormat = function()
		{
			return _sSizeFormat;
		}
		
		this.getDetailCaptionCount = function()
		{
			return (_arrDetailCaption ? _arrDetailCaption.length : 0);
		}
		this.getDetailCaption = function(iIdx)
		{
			return _arrDetailCaption[iIdx][0];
		}
		this.isDetailCaptionProperty = function(iIdx)
		{
			return _arrDetailCaption[iIdx][1];
		}
		
		this.getRoot = function()
		{
			return _oRoot;
		}
		
		this.getTotalNodesCount = function()
		{
			if(_iNodesCount === null)
			{
				_iNodesCount = 0;
				var arrQueue = [_oRoot];
				while(arrQueue.length > 0)
				{
					var oBranchNode = arrQueue.shift();
					var iChildCount = oBranchNode.getChildCount();
					_iNodesCount += iChildCount;
					for(var i = 0; i < iChildCount; i++)
					{
						var oTreeNode = oBranchNode.getChild(i);
						if(oTreeNode.getChildCount() > 0)
						{
							arrQueue.push(oTreeNode);
						}
					}
				}
			}
			return _iNodesCount;
		}
		
		this.fromJsonObject = function(oJson)
		{
			_iNodesCount = null;
			_arrLabelCaption = oJson["labelCaptions"];
			_sSizeCaption = oJson["sizeCaption"];
			_sSizeFormat = oJson["sizeFormat"];
			_arrDetailCaption = null;
			var arrJsonDetailCaption = oJson["detailCaptions"];
			if(arrJsonDetailCaption)
			{
				_arrDetailCaption = [];
				for(var i = 0; i < arrJsonDetailCaption.length; i++)
				{
					var oJsonDetailCaption = arrJsonDetailCaption[i];
					var sTitle = oJsonDetailCaption["title"];
					var bProperty = (oJsonDetailCaption["property"] ? true : false);
					_arrDetailCaption.push([sTitle, bProperty]);
				}
			}
			var oJsonRoot = oJson["root"];
			_oRoot = new TreeChartNode();
			_oRoot.fromJsonObject(oJsonRoot);
		}
	}
	TreeChartModel.createFromJson = function(oJsonChart)
	{
		var oChartModel = new TreeChartModel();
		oChartModel.fromJsonObject(oJsonChart);
		return oChartModel;
	}
	
	function TreeChartNode()
	{
		var _this = this;
		var _oParentNode;
		
		var _sLabel;
		var _sMember;
		var _sColor;
		//叶子节点才有的：
		var _numSize;
		var _arrDetailText;
		//树枝节点才有的：
		var _arrChild;
		//Runtime:
		var _numDrawingSize;
		var _oDrawingObject;
		
		this.setParent = function(oParentNode)
		{
			_oParentNode = oParentNode;
		}
		this.getParent = function()
		{
			return _oParentNode;
		}
		
		this.getLabel = function()
		{
			return _sLabel;
		}
		
		this.getMember = function()
		{
			return _sMember;
		}
		
		this.getColor = function()
		{
			return _sColor;
		}
		
		this.getSize = function()
		{
			return _numSize;
		}
		this.setSize = function(numSize)
		{
			_numSize = numSize;
		}
		
		//这是size忽略负数或转绝对值之后的值
		this.getDrawingSize = function()
		{
			return _numDrawingSize;
		}
		this.setDrawingSize = function(numDrawingSize)
		{
			_numDrawingSize = numDrawingSize;
		}
		
		//绘制器挂的节点模型
		this.getDrawingObject = function()
		{
			return _oDrawingObject;
		}
		this.setDrawingObject = function(oDrawingObject)
		{
			_oDrawingObject = oDrawingObject;
		}
		
		this.getDetailTextCount = function()
		{
			return (_arrDetailText ? _arrDetailText.length : 0);
		}
		this.getDetailText = function(iIdx)
		{
			return _arrDetailText[iIdx];
		}
		
		this.getChildCount = function()
		{
			return (_arrChild ? _arrChild.length : 0);
		}
		this.getChild = function(iIdx)
		{
			return _arrChild[iIdx];
		}
		
		this.fromJsonObject = function(oJson)
		{
			_sLabel = oJson["label"];
			_sMember = oJson["member"];
			_sColor = oJson["color"];
			var sSize = oJson["size"];
			_numSize = (sSize ? parseFloat(sSize) : null);
			_arrDetailText = oJson["detailTexts"];
			_arrChild = null;
			var arrJsonNode = oJson["children"];
			if(arrJsonNode)
			{
				_arrChild = [];
				for(var i = 0; i < arrJsonNode.length; i++)
				{
					var oJsonNode = arrJsonNode[i];
					var oNode = new TreeChartNode();
					oNode.fromJsonObject(oJsonNode);
					oNode.setParent(_this);
					_arrChild.push(oNode);
				}
			}
		}
	}
	
	
	function DiscreteColorLegendModel()
	{
		var _arrColor;
		var _arrText;
		var _arrCaption;
		var _iOthersItemCount;
		var _sAdditionalText;
		
		this.prepare = function(arrColor, arrText, arrCaption, iOthersCount)
		{
			var iRows = arrColor.length;
			_arrColor = arrColor.slice(0, iRows);
			_arrText = arrText.slice(0, iRows);
			_arrCaption = (arrCaption ? arrCaption.slice(0, iRows) : []);
			_iOthersItemCount = iOthersCount;
		}
		
		this.updateColor = function(arrColor)
		{
			_arrColor = arrColor;
		}
		
		this.getItemCount = function()
		{
			return _arrColor.length;
		}
		
		this.getColor = function(iIdx)
		{
			return _arrColor[iIdx];
		}
		
		this.getText = function(iIdx)
		{
			return _arrText[iIdx];
		}
		
		/** 允许在text文字前加一个标题，不一定有，具体场景决定并使用。 */
		this.getCaption = function(iIdx)
		{
			return _arrCaption[iIdx];
		}
		
		this.getOthersItemCount = function()
		{
			return _iOthersItemCount;
		}
		
		/** 有othersItemCount的时候，可以由此传递一个“其它#1项”的文字以供绘制 */
		this.setAdditionalText = function(sText)
		{
			_sAdditionalText = sText;
		}
		this.getAdditionalText = function()
		{
			return _sAdditionalText;
		}
	}
	
	function ContinuousColorLegendModel()
	{
		var _sMinText;
		var _sMaxText;
		var _oGradientColor;
		var _arrSegmentColor;
		
		/** @param sMinText, sMaxText, sColor1, sColor2 [, numPos, sColor3, sColor4] */
		this.prepareGradient = function(sMinText, sMaxText, sColor1, sColor2, numPos, sColor3, sColor4)
		{
			_sMinText = sMinText;
			_sMaxText = sMaxText;
			_oGradientColor = new Gradient(sColor1, sColor2, numPos, sColor3, sColor4);
			_arrSegmentColor = null;
		}
		
		this.prepareSegment = function(sMinText, sMaxText, arrColor)
		{
			_sMinText = sMinText;
			_sMaxText = sMaxText;
			_oGradientColor = null;
			_arrSegmentColor = arrColor;
		}
		
		this.getMinText = function()
		{
			return _sMinText;
		}
		
		this.getMaxText = function()
		{
			return _sMaxText;
		}
		
		this.isGradientColor = function()
		{
			return (_oGradientColor ? true : false);
		}
		
		this.getGradientColor = function()
		{
			return _oGradientColor;
		}
		
		this.getSegmentCount = function()
		{
			return _arrSegmentColor.length;
		}
		
		this.getSegmentColor = function(iIdx)
		{
			return _arrSegmentColor[iIdx];
		}
		
		function Gradient(sColor1, sColor2, numPos, sColor3, sColor4)
		{
			this.getColor1 = function(){return sColor1;}
			this.getColor2 = function(){return sColor2;}
			this.getPos = function(){return numPos;};
			this.getColor3 = function(){return sColor3;}
			this.getColor4 = function(){return sColor4;}
			
			this.isDiverging = function()
			{
				return (numPos || numPos === 0 ? true : false);
			}
		}
	}
	
	
	function AbstractAttr()
	{
		var _bDataEmpty = false;
		var _sSkinName;
		var _oCustomStyleMap;
		var _bReserveRollOutSpace = false;
		var _bShowDataLabel = false;
		var _bDataLabelOverlappable = false;
		var _sDataLabelFormat;
		var _sShowLegend = AbstractAttr.ShowLegend_Right;
		
		this.setDataEmpty = function(bDataEmpty)
		{
			_bDataEmpty = bDataEmpty;
		}
		this.isDataEmpty = function()
		{
			return _bDataEmpty;
		}
		
		this.setSkinName = function(sSkinName)
		{
			_sSkinName = sSkinName;
		}
		this.getSkinName = function()
		{
			return _sSkinName;
		}
		
		this.putCustomStyles = function(oMap)
		{
			!_oCustomStyleMap && (_oCustomStyleMap = {});
			for(var sKey in oMap)
			{
				_oCustomStyleMap[sKey] = oMap[sKey];
			}
		}
		this.putCustomStyle = function(sKey, sValue)
		{
			!_oCustomStyleMap && (_oCustomStyleMap = {});
			_oCustomStyleMap[sKey] = sValue;
		}
		this.getCustomStyle = function(sKey)
		{
			return _oCustomStyleMap ? _oCustomStyleMap[sKey] : null;
		}
		
		/** 为上钻操作预留空间（这是一个和属性设置无关的特殊项） */
		this.setReserveRollOutSpace = function(bValue)
		{
			_bReserveRollOutSpace = bValue;
		}
		this.isReserveRollOutSpace = function()
		{
			return _bReserveRollOutSpace;
		}
		
		this.setShowDataLabel = function(bValue)
		{
			_bShowDataLabel = bValue;
		}
		this.isShowDataLabel = function()
		{
			return _bDataEmpty ? false : _bShowDataLabel;
		}
		
		/** 允许标签重叠 */
		this.setDataLabelOverlappable = function(bValue)
		{
			_bDataLabelOverlappable = bValue;
		}
		this.isDataLabelOverlappable = function()
		{
			return _bDataLabelOverlappable;
		}
		
		this.setDataLabelFormat = function(sFormat)
		{
			_sDataLabelFormat = sFormat;
		}
		this.getDataLabelFormat = function()
		{
			return _sDataLabelFormat;
		}
		
		this.setShowLegend = function(sValue)
		{
			_sShowLegend = sValue;
		}
		this.getShowLegend = function()
		{
			return _sShowLegend;
		}
		
		var copyTo = function(oAnother)
		{
			oAnother.setShowDataLabel(_bShowDataLabel);
			oAnother.setDataLabelOverlappable(_bDataLabelOverlappable);
			oAnother.setDataLabelFormat(_sDataLabelFormat);
			oAnother.setShowLegend(_sShowLegend);
			oAnother.setReserveRollOutSpace(_bReserveRollOutSpace);
			_oCustomStyleMap && oAnother.putCustomStyles(_oCustomStyleMap);
		}
		
		this.protectedMethod = 
		{
			"copyTo": copyTo
		}
	}
	AbstractAttr.ShowLegend_Non = "NON";
	AbstractAttr.ShowLegend_Right = "RIGHT";
	AbstractAttr.ShowLegend_Bottom = "BOTTOM";
	
	AbstractAttr.RulerScale_Auto = "AUTO";
	AbstractAttr.RulerScale_Linear = "LINEAR";
	AbstractAttr.RulerScale_Log = "LOG";
	
	AbstractAttr.RulerStart_Zero = "ZERO";
	AbstractAttr.RulerStart_Nonzero = "NONZERO";
	
	
	function AbstractTooltipsSelfDrivingAttr()
	{
		var _iDuration = -1;
		
		this.setTooltipsSelfDrivingDuration = function(iDurationSeconds)
		{
			_iDuration = iDurationSeconds;
		}
		this.isTooltipsSelfDriving = function()
		{
			return (_iDuration >= 0);
		}
		this.getTooltipsSelfDrivingDuration = function()
		{
			return _iDuration;
		}
	}
	
	
	function CommonAttr()
	{
		AbstractAttr.call(this);
	}
	
	function PieAttr()
	{
		AbstractAttr.call(this);
		var _this = this;
		var _bPresentByAngle = true;
		var _bPresentByRadius = false;
		var _iDataLabelType;
		var _bIgnoreNegative = false;
		var _bHollow = false;
		var _bShowTotal = true;
		
		/** 饼图总是只呈现为角度差异，玫瑰图可能不呈现为角度差异 */
		this.setPresentByAngle = function(bPresentByAngle)
		{
			_bPresentByAngle = bPresentByAngle;
		}
		this.isPresentByAngle = function()
		{
			return _bPresentByAngle;
		}
		
		/** 饼图总是不呈现为半径差异，玫瑰图总是呈现为半径差异 */
		this.setPresentByRadius = function(bPresentByRadius)
		{
			_bPresentByRadius = bPresentByRadius;
		}
		this.isPresentByRadius = function()
		{
			return _bPresentByRadius;
		}
		
		/** 见常量: PieAttr.SHOW_LABEL_XXX */
		this.setDataLabelType = function(iValue)
		{
			_iDataLabelType = iValue;
		}
		this.getDataLabelType = function()
		{
			return _iDataLabelType;
		}
		
		/** true：忽略负数，不出现在饼里；false：负数用绝对值 */
		this.setIgnoreNegative = function(bValue)
		{
			_bIgnoreNegative = bValue;
		}
		this.isIgnoreNegative = function()
		{
			return _bIgnoreNegative;
		}
		
		/** 空心--即为环形图 */
		this.setHollow = function(bValue)
		{
			_bHollow = bValue
		}
		this.isHollow = function()
		{
			return _bHollow;
		}
		
		/** 环形图在中间显示总计 */
		this.setShowTotalWhenHollow = function(bValue)
		{
			_bShowTotal = bValue;
		}
		this.isShowTotalWhenHollow = function()
		{
			return _this.isDataEmpty() ? false : _bShowTotal;
		}
		
		/** 中间空心的半径 */
		this.getHollowRadius = function(iRadius)
		{
			return parseInt(iRadius * 0.75);
		}
	}
	PieAttr.SHOW_LABEL_NAME = 0x1;
	PieAttr.SHOW_LABEL_NUMBER = 0x2;
	PieAttr.SHOW_LABEL_PERCENT = 0x4;
	
	function AbstractNumberAxisAttr()
	{
		var _sUnitText;
		var _sFormat;
		var _sRulerScale = AbstractAttr.RulerScale_Linear;
		var _sRulerStart = AbstractAttr.RulerStart_Zero;
		
		var setUnitText = function(sText){_sUnitText = sText;}
		var getUnitText = function(){return _sUnitText;}
		
		var setFormat = function(sFormat){_sFormat = sFormat;}
		var getFormat = function(){return _sFormat;}
		
		var setRulerScale = function(sEnum){_sRulerScale = sEnum;}
		var getRulerScale = function(){return _sRulerScale;}
		
		var setRulerStart = function(sEnum){_sRulerStart = sEnum;}
		var getRulerStart = function(){return _sRulerStart;}
		
		this.protectedMethod["setUnitText"] = setUnitText;
		this.protectedMethod["getUnitText"] = getUnitText;
		this.protectedMethod["setFormat"] = setFormat;
		this.protectedMethod["getFormat"] = getFormat;
		this.protectedMethod["setRulerScale"] = setRulerScale;
		this.protectedMethod["getRulerScale"] = getRulerScale;
		this.protectedMethod["setRulerStart"] = setRulerStart;
		this.protectedMethod["getRulerStart"] = getRulerStart;
	}
	
	function AbstractNumberYAxisAttr()
	{
		AbstractNumberAxisAttr.call(this);
		var _super = this.protectedMethod;
		
		this.setYUnitText = _super.setUnitText;
		this.getYUnitText = _super.getUnitText;
		
		this.setYFormat = _super.setFormat;
		this.getYFormat = _super.getFormat;
		
		this.setYRulerScale = _super.setRulerScale;
		this.getYRulerScale = _super.getRulerScale;
		
		this.setYRulerStart = _super.setRulerStart;
		this.getYRulerStart = _super.getRulerStart;
	}
	
	function AbstractNumberXAxisAttr()
	{
		AbstractNumberAxisAttr.call(this);
		var _super = this.protectedMethod;
		
		this.setXUnitText = _super.setUnitText;
		this.getXUnitText = _super.getUnitText;
		
		this.setXFormat = _super.setFormat;
		this.getXFormat = _super.getFormat;
		
		this.setXRulerScale = _super.setRulerScale;
		this.getXRulerScale = _super.getRulerScale;
		
		this.setXRulerStart = _super.setRulerStart;
		this.getXRulerStart = _super.getRulerStart;
	}
	
	function YNXSAttr()
	{
		AbstractAttr.call(this);
		AbstractNumberYAxisAttr.call(this);
	}
	
	function YSXNAttr()
	{
		AbstractAttr.call(this);
		AbstractNumberXAxisAttr.call(this);
	}
	
	function ScatterAttr()
	{
		AbstractAttr.call(this);
		AbstractNumberYAxisAttr.call(this);
		AbstractNumberXAxisAttr.call(this);
	}
	
	function AbstractLineAttr()
	{
		var _bSmooth = false;
		var _bPaintingPoint = false;
		var _isTooltipsSorted = false;
		var _bZeroInsteadNull = false;
		
		/** 平滑 */
		this.setSmooth = function(bSmooth)
		{
			_bSmooth = bSmooth;
		}
		this.isSmooth = function()
		{
			return _bSmooth;
		}
		
		/** 画点 */
		this.setPaintingPoint = function(bPaintingPoint)
		{
			_bPaintingPoint = bPaintingPoint;
		}
		this.isPaintingPoint = function()
		{
			return _bPaintingPoint;
		}
		
		/** 空值补零 */
		this.setZeroInsteadNull = function(bZeroInsteadNull)
		{
			_bZeroInsteadNull = bZeroInsteadNull;
		}
		this.isZeroInsteadNull = function()
		{
			return _bZeroInsteadNull;
		}
		
		/** 每个类别的tooltips要不要按度量值对系列排序 */
		this.setTooltipsSorted = function(isTooltipsSorted)
		{
			_isTooltipsSorted = isTooltipsSorted;
		}
		this.isTooltipsSorted = function()
		{
			return _isTooltipsSorted;
		}
	}
	
	function LineAttr()
	{
		YNXSAttr.call(this);
		AbstractLineAttr.call(this);
	}
	
	function AbstractPrimaryYAxisAttr()
	{
		AbstractNumberAxisAttr.call(this);
		var _super = this.protectedMethod;
		
		this.setPYUnitText = _super.setUnitText;
		this.getPYUnitText = _super.getUnitText;
		
		this.setPYFormat = _super.setFormat;
		this.getPYFormat = _super.getFormat;
		
		this.setPYRulerScale = _super.setRulerScale;
		this.getPYRulerScale = _super.getRulerScale;
		
		this.setPYRulerStart = _super.setRulerStart;
		this.getPYRulerStart = _super.getRulerStart;
	}
	function AbstractSecondaryYAxisAttr()
	{
		AbstractNumberAxisAttr.call(this);
		var _super = this.protectedMethod;
		
		this.setSYUnitText = _super.setUnitText;
		this.getSYUnitText = _super.getUnitText;
		
		this.setSYFormat = _super.setFormat;
		this.getSYFormat = _super.getFormat;
		
		this.setSYRulerScale = _super.setRulerScale;
		this.getSYRulerScale = _super.getRulerScale;
		
		this.setSYRulerStart = _super.setRulerStart;
		this.getSYRulerStart = _super.getRulerStart;
	}
	function DoubleYAttr()
	{
		AbstractAttr.call(this);
		AbstractPrimaryYAxisAttr.call(this);
		AbstractSecondaryYAxisAttr.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		var _bLeftShowLabel = false;
		var _bRightShowLabel = false;
		
		this.setShowDataLabel = function(bLeft, bRight)
		{
			_bLeftShowLabel = bLeft;
			_bRightShowLabel = bRight;
		}
		
		var copyTwoY = function(oPrimaryAttr, oSecondaryAttr)
		{
			_super.copyTo(oPrimaryAttr);
			oPrimaryAttr.setShowDataLabel(_bLeftShowLabel);
			oPrimaryAttr.setYUnitText(_this.getPYUnitText());
			oPrimaryAttr.setYFormat(_this.getPYFormat());
			oPrimaryAttr.setYRulerScale(_this.getPYRulerScale());
			oPrimaryAttr.setYRulerStart(_this.getPYRulerStart());
			
			_super.copyTo(oSecondaryAttr);
			oSecondaryAttr.setShowDataLabel(_bRightShowLabel);
			oSecondaryAttr.setYUnitText(_this.getSYUnitText());
			oSecondaryAttr.setYFormat(_this.getSYFormat());
			oSecondaryAttr.setYRulerScale(_this.getSYRulerScale());
			oSecondaryAttr.setYRulerStart(_this.getSYRulerStart());
		}
		
		this.protectedMethod["copyTwoY"] = copyTwoY;
	}
	
	function CompositeAttr()
	{
		DoubleYAttr.call(this);
		AbstractLineAttr.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		this.splitTwoY = function()
		{
			var oPrimaryAttr = new YNXSAttr();
			
			var oSecondaryAttr = new LineAttr();
			oSecondaryAttr.setSmooth(_this.isSmooth());
			oSecondaryAttr.setPaintingPoint(_this.isPaintingPoint());
			oSecondaryAttr.setZeroInsteadNull(_this.isZeroInsteadNull());
			
			_super.copyTwoY(oPrimaryAttr, oSecondaryAttr);
			return [oPrimaryAttr, oSecondaryAttr];
		}
	}
	
	function MapAttr()
	{
		AbstractAttr.call(this);
		AbstractTooltipsSelfDrivingAttr.call(this);
		
		var _sBackImageUrl;
		var _iPageWidth;
		var _iPageHeight;
		var _sTemplateContent;
		var _oRegionMapping;
		
		this.setBackImageUrl = function(sBackImageUrl)
		{
			_sBackImageUrl = sBackImageUrl;
		}
		this.getBackImageUrl = function()
		{
			return _sBackImageUrl;
		}
		
		/** 当有背景图片时，需要指定设计时的页面尺寸（亦即SVG的viewBox尺寸），图片按此比例最大居中显示 */
		this.setPageSize = function(iPageWidth, iPageHeight)
		{
			_iPageWidth = iPageWidth;
			_iPageHeight = iPageHeight;
		}
		this.getPageWidth = function()
		{
			return _iPageWidth;
		}
		this.getPageHeight = function()
		{
			return _iPageHeight;
		}
		
		this.setTemplateContent = function(sTemplateContent)
		{
			_sTemplateContent = sTemplateContent;
		}
		this.getTemplateContent = function()
		{
			return _sTemplateContent;
		}
		
		this.setRegionMapping = function(oRegionMapping)
		{
			_oRegionMapping = oRegionMapping;
		}
		this.getRegionMapping = function()
		{
			return _oRegionMapping;
		}
	}
	
	function GISAttr()
	{
		AbstractAttr.call(this);
		
		var _bDirty = false;
		var _numLongitude;
		var _numLatitude;
		var _iZoom;
		var _sUsage;
		var _sCustomScript;
		
		this.setPropertyDirty = function(bDirty)
		{
			_bDirty = bDirty;
		}
		this.isPropertyDirty = function()
		{
			return _bDirty;
		}
		
		this.setLongitude = function(numLongitude)
		{
			_numLongitude = numLongitude;
		}
		this.getLongitude = function()
		{
			return _numLongitude;
		}
		
		this.setLatitude = function(numLatitude)
		{
			_numLatitude = numLatitude;
		}
		this.getLatitude = function()
		{
			return _numLatitude;
		}
		
		this.setZoom = function(iZoom)
		{
			_iZoom = iZoom;
		}
		this.getZoom = function()
		{
			return _iZoom;
		}
		
		this.setUsage = function(sUsage)
		{
			_sUsage = sUsage;
		}
		this.getUsage = function()
		{
			return _sUsage;
		}
		
		this.setCustomScript = function(sScript)
		{
			_sCustomScript = sScript;
		}
		this.getCustomScript = function()
		{
			return _sCustomScript;
		}
	}
	
	function RadarAttr()
	{
		AbstractAttr.call(this);
		var _sRadarFormat;
		var _bShowRulerMarkLabel;
		var _bDimensionOutside = true;
		var _bFillColor;
		
		this.setRadarFormat = function(sFormat)
		{
			_sRadarFormat = sFormat;
		}
		this.getRadarFormat = function()
		{
			return _sRadarFormat;
		}
		
		this.setShowRulerMarkLabel = function(bShowRulerMarkLabel)
		{
			_bShowRulerMarkLabel = bShowRulerMarkLabel;
		}
		this.isShowRulerMarkLabel = function()
		{
			return _bShowRulerMarkLabel;
		}
		
		this.setDimensionOutside = function(bDimensionOutside)
		{
			_bDimensionOutside = bDimensionOutside;
		}
		this.isDimensionOutside = function()
		{
			return _bDimensionOutside;
		}
		
		this.setFillColor = function(bFillColor)
		{
			_bFillColor = bFillColor;
		}
		
		this.isFillColor = function()
		{
			return _bFillColor;
		}
	}
	
	function AbstractProgressAttr()
	{
		var _iOverlapShrinkingPercent = 100;
		
		/** 进度条向内缩的百分比 (0,100] */
		this.setOverlapShrinkingPercent = function(iPercent)
		{
			_iOverlapShrinkingPercent = (!iPercent || isNaN(iPercent) ? 100 : Math.max(0, Math.min(100, iPercent)));
		}
		this.getOverlapShrinkingRatio = function()
		{
			return _iOverlapShrinkingPercent * 0.01;
		}
	}
	
	function AbstractXYProgressAttr()
	{
		AbstractProgressAttr.call(this);
		var _sLabelType;
		
		this.setLabelType = function(sLabelType)
		{
			_sLabelType = sLabelType;			
		}
		this.getLabelType = function()
		{
			return _sLabelType;
		}
	}
	AbstractXYProgressAttr.SHOW_LABEL_NUMBER = 0x1;
	AbstractXYProgressAttr.SHOW_LABEL_PERCENT = 0x2;
	
	function ProgressBarAttr()
	{
		YSXNAttr.call(this);
		AbstractXYProgressAttr.call(this);
		
		this.getXRulerScale = function()
		{
			return AbstractAttr.RulerScale_Linear;
		}
		
		this.getXRulerStart = function()
		{
			return AbstractAttr.RulerStart_Zero;
		}
	}
	
	function ProgressColumnAttr()
	{
		YNXSAttr.call(this);
		AbstractXYProgressAttr.call(this);
		
		this.getYRulerScale = function()
		{
			return AbstractAttr.RulerScale_Linear;
		}
		
		this.getYRulerStart = function()
		{
			return AbstractAttr.RulerStart_Zero;
		}
	}
	
	function ProgressCircleAttr()
	{
		AbstractAttr.call(this);
		AbstractProgressAttr.call(this);
		var _iPercentageDigit = 0;
		var _bPercentageCeiling = false;
		var _numDataEmptyPercentageInstead = 0;
		var _sLabelDesc;
		
		this.setPercentageDecimalDigit = function(iDigit)
		{
			_iPercentageDigit = iDigit;
		}
		this.getPercentageDecimalDigit = function()
		{
			return _iPercentageDigit;
		}
		
		this.setPercentageCeiling = function(bPercentageCeiling)
		{
			_bPercentageCeiling = bPercentageCeiling;
		}
		this.isPercentageCeiling = function()
		{
			return _bPercentageCeiling;
		}
		
		this.setDataEmptyPercentageInstead = function(numValue)
		{
			_numDataEmptyPercentageInstead = numValue;
		}
		this.getDataEmptyPercentageInstead = function()
		{
			return _numDataEmptyPercentageInstead;
		}
		
		this.setLabelDesc = function(sLabelDesc)
		{
			_sLabelDesc = sLabelDesc;
		}
		this.getLabelDesc = function()
		{
			return _sLabelDesc;
		}
	}
	
	function DialAttr()
	{
		AbstractAttr.call(this);
		
		var _sPanStyle = DialAttr.PAN_STYLE_WITH_TRACK;
		var _iArcDegree = 240;
		var _iRotate = 0;
		var _bShowRulerMarkLabel = true;
		var _sRulerMarkLabelFormat;
		var _iPointerLabelType = DialAttr.SHOW_LABEL_NAME | DialAttr.SHOW_LABEL_NUMBER;
		var _sPointerName;
		var _sPointerNumberFormat;
		var _iPointerPercentDecimal = 2;
		
		/** 表盘风格，见常量：DialAttr.PAN_STYLE_WITH_TRACK 带条状色块； DialAttr.PAN_STYLE_ONLY_MARK 仅刻度。 */
		this.setPanStyle = function(sPanStyle)
		{
			_sPanStyle = sPanStyle;
		}
		this.getPanStyle = function()
		{
			return _sPanStyle;
		}
		
		/** 表盘弧形角度，默认240、180两档。 */
		this.setArcDegree = function(iDegree)
		{
			_iArcDegree = iDegree;
		}
		this.getArcDegree = function()
		{
			return _iArcDegree;
		}
		
		/** 逆时针旋转的角度，例如30。负数则顺时针 */
		this.setRotate = function(iDegree)
		{
			_iRotate = iDegree;
		}
		this.getRotate = function()
		{
			return _iRotate;
		}
		
		this.setShowRulerMarkLabel = function(bShow)
		{
			_bShowRulerMarkLabel = bShow;
		}
		this.isShowRulerMarkLabel = function()
		{
			return _bShowRulerMarkLabel;
		}
		
		this.setRulerMarkLabelFormat = function(sFormat)
		{
			_sRulerMarkLabelFormat = sFormat;
		}
		this.getRulerMarkLabelFormat = function()
		{
			return _sRulerMarkLabelFormat;
		}
		
		this.setPointerLabelType = function(iType)
		{
			_iPointerLabelType = iType;
		}
		this.getPointerLabelType = function()
		{
			return _iPointerLabelType;
		}
		
		this.setPointerName = function(sName)
		{
			_sPointerName = sName;
		}
		this.getPointerName = function()
		{
			return _sPointerName;
		}
		
		this.setPointerNumberFormat = function(sFormat)
		{
			_sPointerNumberFormat = sFormat;
		}
		this.getPointerNumberFormat = function()
		{
			return _sPointerNumberFormat;
		}
		
		this.setPointerPercentDecimal = function(iDigit)
		{
			_iPointerPercentDecimal = iDigit;
		}
		this.getPointerPercentDecimal = function()
		{
			return _iPointerPercentDecimal;
		}
	}
	DialAttr.PAN_STYLE_WITH_TRACK = "withTrack";
	DialAttr.PAN_STYLE_ONLY_MARK = "onlyMark";
	DialAttr.SHOW_LABEL_NAME = 0x1;
	DialAttr.SHOW_LABEL_NUMBER = 0x2;
	DialAttr.SHOW_LABEL_PERCENT = 0x4;
	
	function AbstractListSimilarAttr()
	{
		var _bAutoScroll = true;
		var _iStickRows = 0;
		
		this.setAutoScroll = function(bAutoScroll)
		{
			_bAutoScroll = bAutoScroll;
		}
		this.isAutoScroll = function()
		{
			return _bAutoScroll;
		}
		
		this.setStickRows = function(iStickRows)
		{
			_iStickRows = iStickRows;
		}
		this.getStickRows = function()
		{
			return _iStickRows;
		}
	}
	
	function GridAttr()
	{
		AbstractAttr.call(this);
		AbstractListSimilarAttr.call(this);
		var _bShowHeader = true;
		var _bShowRowNum = false;
		
		this.setShowHeader = function(bShowHeader)
		{
			_bShowHeader = bShowHeader;
		}
		this.isShowHeader = function()
		{
			return _bShowHeader;
		}
		
		this.setShowRowNum = function(bShowRowNum)
		{
			_bShowRowNum = bShowRowNum;
		}
		this.isShowRowNum = function()
		{
			return _bShowRowNum;
		}
	}
	
	function CustomListAttr()
	{
		AbstractAttr.call(this);
		AbstractListSimilarAttr.call(this);
		var _iRowWidth;
		var _iRowHeight;
		var _iHeaderHeight;
		var _iFooterHeight;
		var _mapDesigntimeRect = {};
		var _sSplitLineColor;
		var _sHeaderBackgroundColor;
		var _sFooterBackgroundColor;
		var _bBodyMiddleAlign = false;
		
		/** 单行垂直居中，可以用来做“指标”。 */
		this.setBodyMiddleAlign = function(bMiddleAlign)
		{
			_bBodyMiddleAlign = bMiddleAlign;
		}
		this.isBodyMiddleAlign = function()
		{
			return _bBodyMiddleAlign;
		}
		
		this.setSplitLineColor = function(sColor)
		{
			_sSplitLineColor = sColor;
		}
		this.getSplitLineColor = function()
		{
			return _sSplitLineColor;
		}
		
		this.setHeaderBackgroundColor = function(sColor)
		{
			_sHeaderBackgroundColor = sColor;
		}
		this.getHeaderBackgroundColor = function()
		{
			return _sHeaderBackgroundColor;
		}
		
		this.setFooterBackgroundColor = function(sColor)
		{
			_sFooterBackgroundColor = sColor;
		}
		this.getFooterBackgroundColor = function()
		{
			return _sFooterBackgroundColor;
		}
		
		this.setDesigntimeRowSize = function(iRowWidth, iRowHeight, iHeaderHeight, iFooterHeight)
		{
			_iRowWidth = iRowWidth;
			_iRowHeight = iRowHeight;
			_iHeaderHeight = iHeaderHeight;
			_iFooterHeight = iFooterHeight;
		}
		
		this.getRowHeight = function()
		{
			return _iRowHeight;
		}
		
		this.getHeaderHeight = function()
		{
			return _iHeaderHeight;
		}
		
		this.getFooterHeight = function()
		{
			return _iFooterHeight;
		}
		
		this.addDesigntimeRect = function(iX, iY, iW, iH)
		{
			addDesigntimeRect("body", iX, iY, iW, iH);
		}
		
		this.addDesigntimeHeaderRect = function(iX, iY, iW, iH)
		{
			addDesigntimeRect("head", iX, iY, iW, iH);
		}
		
		this.addDesigntimeFooterRect = function(iX, iY, iW, iH)
		{
			addDesigntimeRect("foot", iX, iY, iW, iH);
		}
		
		var addDesigntimeRect = function(sType, iX, iY, iW, iH)
		{
			var arrDesigntimeRect = _mapDesigntimeRect[sType];
			if(!arrDesigntimeRect)
			{
				arrDesigntimeRect = [];
				_mapDesigntimeRect[sType] = arrDesigntimeRect;
			}
			arrDesigntimeRect.push([iX, iY, iW, iH]);
		}
		
		this.getRuntimeRects = function(iRuntimeWidth, iRuntimeHeight)
		{
			return parseRow("body", _iRowWidth, _iRowHeight, iRuntimeWidth, iRuntimeHeight);
		}
		
		this.getRuntimeHeaderRects = function(iRuntimeWidth)
		{
			return parseRow("head", _iRowWidth, _iHeaderHeight, iRuntimeWidth, _iHeaderHeight);
		}
		
		this.getRuntimeFooterRects = function(iRuntimeWidth)
		{
			return parseRow("foot", _iRowWidth, _iFooterHeight, iRuntimeWidth, _iFooterHeight);
		}
		
		var parseRow = function(sType, iDesigntimeWidth, iDesigntimeHeight, iRuntimeWidth, iRuntimeHeight)
		{
			var arrRuntimeRect = [];
			var arrDesigntimeRect = _mapDesigntimeRect[sType];
			if(arrDesigntimeRect)
			{
				var oTransformer = new BlocksToTable();
				oTransformer.setGapFixed(false);
				oTransformer.setDesigningSize(iDesigntimeWidth, iDesigntimeHeight);
				for(var i = 0; i < arrDesigntimeRect.length; i++)
				{
					var arrWrap = arrDesigntimeRect[i];
					var iX = arrWrap[0];
					var iY = arrWrap[1];
					var iW = arrWrap[2];
					var iH = arrWrap[3];
					var bWidthFixed = false;
					var bHeightFixed = true;
					var sId = "" + i;
					oTransformer.appendBlock(sId, iX, iY, iW, iH, bWidthFixed, bHeightFixed);
				}
				oTransformer.transformTo(iRuntimeWidth, iRuntimeHeight);
				for(var i = 0; i < arrDesigntimeRect.length; i++)
				{
					var sId = "" + i;
					var arrTheFour = oTransformer.searchBlockRect(sId);
					if(arrTheFour)
					{
						var oRect = new Rect(arrTheFour[0], arrTheFour[1], arrTheFour[2], arrTheFour[3]);
						arrRuntimeRect.push(oRect);
					}
				}
			}
			return arrRuntimeRect;
		}
		
		function Rect(iX, iY, iW, iH)
		{
			this.getRectX = function(){return iX;}
			this.getRectY = function(){return iY;}
			this.getRectWidth = function(){return iW;}
			this.getRectHeight = function(){return iH;}
		}
	}
	
	function WaterfallAttr()
	{
		AbstractAttr.call(this);
		AbstractNumberYAxisAttr.call(this);
	}
	
	function FunnelAttr()
	{
		AbstractAttr.call(this);
		
		var _bLadderPerfect= true;
		var _arrRatioBy = [true, false, false];//总只有一个true
		var _iLabelName = FunnelAttr.LABEL_NONE;
		var _iLabelValue = FunnelAttr.LABEL_NONE;
		var _iLabelPercent = FunnelAttr.LABEL_RIGHT;
		var _sPercentageFormat;
		
		this.setLadderPerfect = function(bLadderPerfect){_bLadderPerfect = bLadderPerfect;}
		this.isLadderPerfect = function(){return _bLadderPerfect;}
		
		this.markRatioByStep  = function(){_arrRatioBy = [true, false, false];}
		this.markRatioByStart = function(){_arrRatioBy = [false, true, false];}
		this.markRatioByTotal = function(){_arrRatioBy = [false, false, true];}
		this.isRatioByStep    = function(){return _arrRatioBy[0];}
		this.isRatioByStart   = function(){return _arrRatioBy[1];}
		this.isRatioByTotal   = function(){return _arrRatioBy[2];}
		
		this.setLabelNamePosition = function(iPosition){_iLabelName = iPosition;}
		this.getLabelNamePosition = function(){return _iLabelName;}
		
		this.setLabelValuePosition = function(iPosition){_iLabelValue = iPosition;}
		this.getLabelValuePosition = function(){return _iLabelValue;}
		
		this.setLabelPercentPosition = function(iPosition){_iLabelPercent = iPosition;}
		this.getLabelPercentPosition = function(){return _iLabelPercent;}
		
		this.isLabelLeft   = function(iPosition){return iPosition == FunnelAttr.LABEL_LEFT;}
		this.isLabelRight  = function(iPosition){return iPosition == FunnelAttr.LABEL_RIGHT;}
		this.isLabelCenter = function(iPosition){return iPosition == FunnelAttr.LABEL_CENTER;}
		this.isLabelHide   = function(iPosition){return iPosition == FunnelAttr.LABEL_NONE;}
		
		this.setPercentageFormat = function(sFormat){_sPercentageFormat = sFormat;}
		this.getPercentageFormat = function(){return _sPercentageFormat;}
	}
	FunnelAttr.LABEL_NONE = 0;
	FunnelAttr.LABEL_LEFT = 1;
	FunnelAttr.LABEL_CENTER = 2;
	FunnelAttr.LABEL_RIGHT = 3;
	
	function RectTreeAttr()
	{
		AbstractAttr.call(this);
		var _bIgnoreNegative = false;
		
		this.setIgnoreNegative = function(bValue)
		{
			_bIgnoreNegative = bValue;
		}
		this.isIgnoreNegative = function()
		{
			return _bIgnoreNegative;
		}
	}
	
	function SunburstAttr()
	{
		AbstractAttr.call(this);
		var _bIgnoreNegative = false;
		
		this.setIgnoreNegative = function(bValue)
		{
			_bIgnoreNegative = bValue;
		}
		this.isIgnoreNegative = function()
		{
			return _bIgnoreNegative;
		}
	}
	
	function AbstractSelectionModel()
	{
		var _this = this;
		var _bMuitlSelectable = false;
		var _arrListener = [];
		
		this.setMultiSelectable = function(bMulti)
		{
			_bMuitlSelectable = bMulti;
		}
		this.isMultiSelectable = function()
		{
			return _bMuitlSelectable;
		}
		
		/** funListener like: func(oSelectionModel, oSelectedTargets) */
		this.addChangedListener = function(funListener)
		{
			_arrListener.push(funListener);
		}
		var fireChangedEvent = function(oSelectedTargets)
		{
			for(var i = 0; i < _arrListener.length; i++)
			{
				var funListener = _arrListener[i];
				funListener(_this, oSelectedTargets);
			}
		}
		
		this.clearAll = function()
		{
			throw new Error("Override");
		}
		
		this.protectedMethod = 
		{
			"fireChangedEvent": fireChangedEvent
		}
	}
	
	function StringSelectionModel()
	{
		AbstractSelectionModel.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		var _oSelectedTargets;
		
		this.clearAll = function()
		{
			_oSelectedTargets && _oSelectedTargets.clear();
		}
		
		this.deselect = function()
		{
			if(getTargets().isAnySelected())
			{
				getTargets().clear();
				_super.fireChangedEvent(getTargets());
			}
		}
		
		this.toggleSelect = function(sValue)
		{
			getTargets().toggleSelect(sValue, _this.isMultiSelectable());
			_super.fireChangedEvent(getTargets());
		}
		
		this.isSelected = function(sValue)
		{
			return _oSelectedTargets ? _oSelectedTargets.isSelected(sValue) : false;
		}
		
		this.isAnySelected = function()
		{
			return _oSelectedTargets ? _oSelectedTargets.isAnySelected() : false;
		}
		
		var getTargets = function()
		{
			if(!_oSelectedTargets)
			{
				_oSelectedTargets = new SelectedTargets();
				_oSelectedTargets.setExecutableValueGetter(
					function(sValue)
					{
						return sValue;
					});
				_oSelectedTargets.setDisplayValueGetter(
					function(sValue)
					{
						return sValue;
					});
			}
			return _oSelectedTargets;
		}
	}
	
	/** GridChartModel对应的选中模型 */
	function RowSelectionModel()
	{
		AbstractSelectionModel.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		var _oSelectedTargets;
		
		this.clearAll = function()
		{
			_oSelectedTargets && _oSelectedTargets.clear();
		}
		
		this.deselect = function()
		{
			if(getTargets().isAnySelected())
			{
				getTargets().clear();
				_super.fireChangedEvent(getTargets());
			}
		}
		
		this.toggleSelect = function(oRow)
		{
			getTargets().toggleSelect(oRow, _this.isMultiSelectable());
			_super.fireChangedEvent(getTargets());
		}
		
		this.isSelected = function(oRow)
		{
			return _oSelectedTargets ? _oSelectedTargets.isSelected(oRow) : false;
		}
		
		this.isAnySelected = function()
		{
			return _oSelectedTargets ? _oSelectedTargets.isAnySelected() : false;
		}
		
		var getTargets = function()
		{
			if(!_oSelectedTargets)
			{
				_oSelectedTargets = new SelectedTargets();
				_oSelectedTargets.setExecutableValueGetter(
					function(oRow)
					{
						return oRow.getAffectionSrcValue();
					});
				_oSelectedTargets.setDisplayValueGetter(
					function(oRow)
					{
						return oRow.getAffectionSrcText();
					});
			}
			return _oSelectedTargets;
		}
	}
	
	/** NormalChartModel对应的选中模型 */
	function SelectionModel()
	{
		AbstractSelectionModel.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		var _iMode = SelectionModel.Mode_Category;
		var _oSelectedCategories;
		var _oSelectedSeries;
		
		this.setMode = function(iMode)
		{
			_iMode = iMode;
		}
		this.isSelectingCategory = function()
		{
			return (_iMode & SelectionModel.Mode_Category) == SelectionModel.Mode_Category;
		}
		this.isSelectingSeries = function()
		{
			return (_iMode & SelectionModel.Mode_Series) == SelectionModel.Mode_Series;
		}
		
		/** 指定的oCategory和oSeries是否选中，参数传null表示忽略对类别或系列的检查，但不能两个都传null。 */
		this.isSelected = function(oCategory, oSeries)
		{
			var bSelected = true;
			if(oCategory !== null && _this.isSelectingCategory())
			{
				if(_oSelectedCategories)
				{
					bSelected = _oSelectedCategories.isSelected(oCategory);
				}
				else
				{
					bSelected = false;
				}
			}
			if(oSeries !== null && _this.isSelectingSeries())
			{
				if(_oSelectedSeries)
				{
					bSelected = bSelected && _oSelectedSeries.isSelected(oSeries);
				}
				else
				{
					bSelected = false;
				}
			}
			return bSelected;
		}
		
		this.isAnySelected = function()
		{
			return (_this.isSelectingCategory() && _oSelectedCategories && _oSelectedCategories.isAnySelected())
					|| (_this.isSelectingSeries() && _oSelectedSeries && _oSelectedSeries.isAnySelected());
		}
		
		this.clearAll = function()
		{
			_oSelectedCategories && _oSelectedCategories.clear();
			_oSelectedSeries && _oSelectedSeries.clear();
		}
		
		this.deselectCategories = function()
		{
			if(getCategoryTargets().isAnySelected())
			{
				getCategoryTargets().clear();
				_super.fireChangedEvent(getCategoryTargets());
			}
		}
		
		this.toggleSelectCategory = function(oCategory)
		{
			getCategoryTargets().toggleSelect(oCategory, _this.isMultiSelectable());
			_super.fireChangedEvent(getCategoryTargets());
		}
		
		this.deselectSeries = function()
		{
			if(getSeriesTargets().isAnySelected())
			{
				getSeriesTargets().clear();
				_super.fireChangedEvent(getSeriesTargets());
			}
		}
		
		this.toggleSelectSeries = function(oSeries)
		{
			getSeriesTargets().toggleSelect(oCategory, _this.isMultiSelectable());
			_super.fireChangedEvent(getSeriesTargets());
		}
		
		var getCategoryTargets = function()
		{
			if(!_oSelectedCategories)
			{
				_oSelectedCategories = new SelectedTargets();
				_oSelectedCategories.setExecutableValueGetter(
					function(oCategory)
					{
						return oCategory.getExecutableValue();
					});
				_oSelectedCategories.setDisplayValueGetter(
					function(oCategory)
					{
						return oCategory.getLabel();
					});
			}
			return _oSelectedCategories;
		}
		
		var getSeriesTargets = function()
		{
			if(!_oSelectedSeries)
			{
				_oSelectedSeries = new SelectedTargets();
				_oSelectedSeries.setExecutableValueGetter(
					function(oSeries)
					{
						return oSeries.getExecutableSeriesFieldValue();
					});
				_oSelectedSeries.setDisplayValueGetter(
					function(oSeries)
					{
						return oSeries.getSeriesFieldText();
					});
			}
			return _oSelectedSeries;
		}
	}
	SelectionModel.Mode_Category = 0x1;
	SelectionModel.Mode_Series = 0x2;
	
	//Category或Series的选中值（可以多选）抽象为一个SelectedTargets
	function SelectedTargets()
	{
		var _arrTarget = [];
		var _funExecutableValueGetter;
		var _funDisplayValueGetter;
		
		this.clear = function()
		{
			_arrTarget = [];
		}
		
		this.toggleSelect = function(oTarget, bMultiSelecting)
		{
			var iIdx = searchIndex(oTarget);
			if(bMultiSelecting)
			{
				if(iIdx >= 0)
				{
					_arrTarget.splice(iIdx, 1);
				}
				else
				{
					_arrTarget.push(oTarget);
				}
			}
			else
			{
				if(iIdx >= 0 && _arrTarget.length == 1)
				{
					_arrTarget.splice(iIdx, 1);
				}
				else
				{
					_arrTarget = [oTarget];
				}
			}
		}
		
		this.isSelected = function(oTarget)
		{
			return searchIndex(oTarget) >= 0;
		}
		
		this.isAnySelected = function()
		{
			return _arrTarget.length > 0;
		}
		
		var searchIndex = function(oTarget)
		{
			for(var i = 0; i < _arrTarget.length; i++)
			{
				if(_arrTarget[i] == oTarget)
				{
					return i;
				}
			}
			return -1;
		}
		
		this.setExecutableValueGetter = function(funGetter)
		{
			_funExecutableValueGetter = funGetter;
		}
		this.setDisplayValueGetter = function(funGetter)
		{
			_funDisplayValueGetter = funGetter;
		}
		this.getJsonSelectedValue = function()
		{
			var arrJsonSelected = [];
			for(var i = 0; i < _arrTarget.length; i++)
			{
				var oTarget = _arrTarget[i];
				var oJson = {};
				oJson["value"] = _funExecutableValueGetter(oTarget);
				oJson["text"] = _funDisplayValueGetter(oTarget);
				arrJsonSelected.push(oJson);
			}
			return arrJsonSelected;
		}
	}
})();