/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.formula;

import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.i18n.ErrorMessage;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DesigntimeFormulaDomain {
    private II18nContext _i18nContext;

    public void setI18nContext(II18nContext i18nCtx) {
        this._i18nContext = i18nCtx;
    }

    private II18nContext getI18nContext() {
        if (this._i18nContext == null) {
            this._i18nContext = new DefaultI18nContext();
        }
        return this._i18nContext;
    }

    public CheckingResponse checkFormula(CheckingRequest checkingRequest) {
        String propertyName = checkingRequest.getPropertyName();
        String formula = checkingRequest.getFormula();
        List<Property> properties = checkingRequest.getProperties();
        Property property = new Property();
        property.setName(propertyName);
        property.setAssociateName(propertyName);
        property.setFormula(formula);
        for (int i = properties.size() - 1; i >= 0; --i) {
            Property exist = properties.get(i);
            if (!exist.getName().equals(propertyName)) continue;
            properties.remove(i);
        }
        properties.add(0, property);
        FormulaParsingExceptionHandler exHandler = new FormulaParsingExceptionHandler(properties, property, this.getI18nContext());
        FormulaHelper.checkEditingFormula(properties, exHandler);
        CheckingResponse exInfo = exHandler.getExceptionInfo();
        if (exInfo == null) {
            return new CheckingResponse(property.getDataType());
        }
        return exInfo;
    }

    public CheckingAllResponse checkAllFormula(CheckingRequest checkingRequest) {
        CheckingAllResponse result = new CheckingAllResponse();
        List<Property> properties = checkingRequest.getProperties();
        FormulaHelper.handleAll(properties);
        for (int i = 0; i < properties.size(); ++i) {
            Property property = properties.get(i);
            if (!property.isCalculation()) continue;
            String key = property.getName();
            boolean isValid = property.isValidCalculation();
            DesigningDataType dataType = property.getDataType();
            result.add(key, new CheckingAllResponse.Each(isValid, dataType));
        }
        return result;
    }

    public static class CheckingAllResponse {
        private Map<String, Each> map = new HashMap<String, Each>();

        public void add(String name, Each each) {
            this.map.put(name, each);
        }

        public static class Each {
            private boolean valid;
            private DesigningDataType dataType;

            public Each(boolean valid, DesigningDataType dataType) {
                this.valid = valid;
                this.dataType = dataType;
            }

            public boolean getValid() {
                return this.valid;
            }

            public DesigningDataType getDataType() {
                return this.dataType;
            }
        }
    }

    public static class CheckingResponse {
        private boolean ok;
        private DesigningDataType dataType;
        private Integer errorPosition;
        private String errorPrompt;

        public CheckingResponse(DesigningDataType dataType) {
            this.ok = true;
            this.dataType = dataType;
        }

        public CheckingResponse(int position, String prompt) {
            this.ok = false;
            this.errorPosition = position;
            this.errorPrompt = prompt;
        }

        public boolean getCheckingResponseState() {
            return this.ok;
        }

        public DesigningDataType getDesigningDataType() {
            return this.dataType;
        }

        public Integer getErrorPosition() {
            return this.errorPosition;
        }

        public String getErrorPrompt() {
            return this.errorPrompt;
        }
    }

    public static class CheckingRequest {
        private String name;
        private String formula;
        private List<Property> properties;

        public String getPropertyName() {
            return this.name;
        }

        public String getFormula() {
            return this.formula;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }
    }

    private static class FormulaParsingExceptionHandler
    implements FormulaHelper.IFormulaParsingExceptionHandler {
        private List<Property> _properties;
        private Property _self;
        private CheckingResponse _info;
        private II18nContext _i18nContext;

        public FormulaParsingExceptionHandler(List<Property> properties, Property self, II18nContext i18nContext) {
            this._properties = properties;
            this._self = self;
            this._i18nContext = i18nContext;
        }

        public CheckingResponse getExceptionInfo() {
            return this._info;
        }

        @Override
        public boolean forParsing(Property property, ParserException ex) {
            if (property == this._self) {
                int position = ex.getCharacterIndex();
                String prompt = ErrorMessage.encodeParserException((ParserException)ex, (II18nContext)this._i18nContext);
                this._info = new CheckingResponse(position, prompt);
                return true;
            }
            property.setFormulaInvalid(true);
            return false;
        }

        @Override
        public boolean forChecking(Property property, FormulaHelper.AbstractFormulaException ex) {
            if (property == this._self) {
                this._info = this.createCheckingInfo(ex);
                return true;
            }
            property.setFormulaInvalid(true);
            return false;
        }

        private CheckingResponse createCheckingInfo(FormulaHelper.AbstractFormulaException ex) {
            String prompt;
            if (ex instanceof FormulaHelper.AbstractFormulaException.CycleRefException) {
                prompt = Messages.getMLS((II18nContext)this._i18nContext, (String)"formulaLoopReference", (String)"\u5faa\u73af\u5f15\u7528", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            } else if (ex instanceof FormulaHelper.AbstractFormulaException.RefNotFoundException) {
                prompt = Messages.getMLS((II18nContext)this._i18nContext, (String)"formulaFieldNotExists", (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            } else if (ex instanceof FormulaHelper.AbstractFormulaException.InvalidRefException) {
                prompt = Messages.getMLS((II18nContext)this._i18nContext, (String)"formulaFieldIncorrect", (String)"\u5b57\u6bb5\u4e0d\u6b63\u786e", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            } else {
                throw new RuntimeException("Unknown");
            }
            String name = ex.getPropertyName();
            Property property = FormulaHelper.list2Map(this._properties).get(name);
            String alias = property == null ? null : property.getAlias();
            prompt = prompt + (alias == null || "".equals(alias) ? "" : ": [" + alias + "]");
            return new CheckingResponse(ex.getPosition(), prompt);
        }
    }
}

