/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.source.IDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.DBSQLMacroExecuteException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import java.util.List;

public class DBSourceDelegateDomain {
    private AbstractDBSourceDomain dbSourceDomain;
    private DBSource dbSource;

    public DBSourceDelegateDomain(DBSource dbSource, IConnectionFactory connectionFactory) throws UnSupportDataSourceException {
        this.dbSource = dbSource;
        this.dbSourceDomain = AbstractDBSourceDomain.newInstance((AbstractSource)dbSource);
        this.dbSourceDomain.setConnectionFactory(connectionFactory);
    }

    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, String tableName) throws AbstractDBSourceException, AbstractMacroException {
        return this.dbSourceDomain.getDesigntimeDataObject(qingContext, (AbstractSource)this.dbSource, tableName);
    }

    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractDBSourceException, AbstractMacroException {
        runtimeEntity.setSource((AbstractSource)this.dbSource);
        return this.dbSourceDomain.getPreviewData(qingContext, runtimeEntity, rows);
    }

    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException, InterruptedException {
        runtimeEntity.setSource((AbstractSource)this.dbSource);
        return this.dbSourceDomain.extractData(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
    }

    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractDBSourceException, AbstractMacroException {
        runtimeEntity.setSource((AbstractSource)this.dbSource);
        return this.dbSourceDomain.getDataCount(qingContext, runtimeEntity);
    }

    public IDataSourceIterator createDataSourceIterator(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        runtimeEntity.setSource((AbstractSource)this.dbSource);
        return this.dbSourceDomain.createDataSourceIterator(qingContext, runtimeEntity);
    }

    public AbstractNode getUsableEntities(QingContext qingContext) throws AbstractSourceException, AbstractQingIntegratedException {
        return this.dbSourceDomain.getUsableEntities(qingContext, (AbstractSource)this.dbSource);
    }

    public AbstractNode getStoredProcedures(QingContext qingContext) throws AbstractSourceException {
        return this.dbSourceDomain.getStoredProcedures(qingContext, (AbstractSource)this.dbSource);
    }

    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, String storedProcedureName) throws AbstractSourceException {
        return this.dbSourceDomain.getStoredProcedureParameters(qingContext, (AbstractSource)this.dbSource, storedProcedureName);
    }

    public void checkEntityMacroValPermission(QingContext qingContext, Entity entity) throws DBSQLMacroExecuteException {
        this.dbSourceDomain.checkDBSourceMacroValPermission(qingContext, (AbstractSource)this.dbSource, entity);
    }
}

