/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.util.JsonUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class KylinSourceDomain
extends AbstractDBSourceDomain {
    public KylinSourceDomain(AbstractDBSourceJDBCAdapter jdbcAdapter) {
        super(jdbcAdapter);
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractDBSourceException, AbstractMacroException {
        PreviewDataModel previewData;
        try {
            previewData = super.getPreviewData(qingContext, runtimeEntity, rows);
        }
        catch (AbstractDBSourceException e) {
            throw this.parseKylinException(e);
        }
        catch (AbstractMacroException e) {
            throw new DBExcuseException((Exception)((Object)e));
        }
        return previewData;
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws AbstractDBSourceException, AbstractMacroException {
        DesigntimeDataObject designtimeDataObject;
        try {
            designtimeDataObject = super.getDesigntimeDataObject(qingContext, source, associateName);
        }
        catch (AbstractDBSourceException e) {
            throw this.parseKylinException(e);
        }
        catch (AbstractMacroException e) {
            throw new DBExcuseException((Exception)((Object)e));
        }
        return designtimeDataObject;
    }

    @Override
    protected void setRuntimeParams(PreparedStatement ps, int parameterIndex, Object param) throws SQLException {
        this.setParams(ps, parameterIndex, param);
    }

    @Override
    protected boolean isNeedReCountByResultSet(Object[] params) {
        boolean isNeedReCountData = false;
        if (params != null && params.length > 0) {
            for (Object param : params) {
                if (!(param instanceof Calendar) && !(param instanceof Timestamp) && !(param instanceof java.util.Date) && !(param instanceof Date)) continue;
                isNeedReCountData = true;
                break;
            }
        }
        return isNeedReCountData;
    }

    private DBExcuseException parseKylinException(AbstractDBSourceException e) {
        List<String> errors = Arrays.asList("CUBE_BLACK_OUT_REALIZATION", "CUBE_LIMIT_PRECEDE_AGGR", "CUBE_NOT_CONTAIN_ALL_COLUMN", "CUBE_NOT_CONTAIN_ALL_DIMENSION", "CUBE_NOT_CONTAIN_ALL_MEASURE", "CUBE_NOT_CONTAIN_TABLE", "CUBE_NOT_READY", "CUBE_OTHER_CUBE_INCAPABLE", "CUBE_UN_SUPPORT_MASSIN", "CUBE_UN_SUPPORT_RAWQUERY", "CUBE_UNMATCHED_AGGREGATION", "CUBE_UNMATCHED_DIMENSION", "MODEL_BAD_JOIN_SEQUENCE", "MODEL_FACT_TABLE_NOT_FOUND", "MODEL_JOIN_CONDITION_UNMATCHED", "MODEL_JOIN_NOT_FOUND", "MODEL_JOIN_TYPE_UNMATCHED", "MODEL_OTHER_MODEL_INCAPABLE", "MODEL_UNMATCHED_JOIN");
        String message = e.getMessage();
        for (String error : errors) {
            if (!message.contains(error)) continue;
            return new DBExcuseException("Realization Check Failed. Incapable Type: " + error, 0, "0");
        }
        return this.parseCommonException(e);
    }

    private DBExcuseException parseCommonException(AbstractDBSourceException e) {
        try {
            String start = "exception while executing query: java.io.IOException: POST failed, error code 500 and response: ";
            String end = "(ErrorCode:0,SQLState:null)";
            String message = e.getMessage();
            String substring = message.substring(message.indexOf(start) + start.length(), message.indexOf(end));
            ErrorResponse errorResponse = (ErrorResponse)JsonUtil.decodeFromString((String)substring, ErrorResponse.class);
            return new DBExcuseException("Kylin exception while executing query: " + errorResponse.getMsg(), 0, "0");
        }
        catch (Exception exception) {
            return new DBExcuseException((Exception)((Object)e));
        }
    }

    private void setParams(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param != null) {
            if (param instanceof Calendar) {
                Calendar calendar = (Calendar)param;
                Timestamp date = new Timestamp(calendar.getTimeInMillis());
                ps.setTimestamp(index, date);
            } else if (param instanceof Timestamp) {
                ps.setTimestamp(index, (Timestamp)param);
            } else if (param instanceof java.util.Date) {
                ps.setDate(index, new Date(((java.util.Date)param).getTime()));
            } else if (param instanceof Date) {
                ps.setDate(index, (Date)param);
            } else if (param instanceof Boolean) {
                ps.setBoolean(index, (Boolean)param);
            } else if (param instanceof Long) {
                ps.setLong(index, (Long)param);
            } else if (param instanceof BigDecimal) {
                ps.setBigDecimal(index, (BigDecimal)param);
            } else if (param instanceof Integer) {
                ps.setInt(index, (Integer)param);
            } else {
                ps.setString(index, param.toString());
            }
        }
    }

    private class ErrorResponse<T> {
        private String stacktrace;
        private String exception;
        private String url;
        private String code;
        private T data;
        private String msg;

        private ErrorResponse() {
        }

        public String getStacktrace() {
            return this.stacktrace;
        }

        public void setStacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
        }

        public String getException() {
            return this.exception;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

