/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.domain.source.file.FileResult;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.parser.CSVReaderExt;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.AbstractFileSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileAccessException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileNotFoundException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.TextSource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TextSourceDomain
extends AbstractFileSourceDomain {
    private static final String COLUMN = "column";
    private String suffix;

    public TextSourceDomain(String suffix) {
        this.suffix = suffix;
    }

    public Table getTable(TextSource fileSource, String tableName) throws AbstractFileSourceException {
        Table table = null;
        FileResult result = this.getColunms(fileSource);
        table = new Table();
        table.setName(tableName);
        table.setSource(fileSource.getName());
        int columnCount = result.getColIndexAndNameMap().size();
        for (int col = 0; col < columnCount; ++col) {
            Field field = new Field();
            String columnName = result.getColIndexAndNameMap().get(col);
            field.setName(columnName);
            String className = this.defineType(col, fileSource);
            field.setClassName(className);
            field.setDataType(DataTypeUtil.parseDataType((String)className));
            table.addField(field);
        }
        return table;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractFileSourceException {
        FolderNode root = new FolderNode();
        TextSource fileSource = (TextSource)source;
        LeafNode leafNode = new LeafNode();
        leafNode.setType("csv");
        if (this.suffix.equals(".txt")) {
            leafNode.setType("txt");
        }
        String fileName = fileSource.getFileName().substring(0, fileSource.getFileName().lastIndexOf(this.suffix));
        leafNode.setName(fileName);
        leafNode.setDisplayName(fileName);
        leafNode.setCommentInfo(fileName);
        root.addChild((AbstractNode)leafNode);
        return root;
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String tableName) throws AbstractFileSourceException {
        TextSource fs = (TextSource)source;
        Table table = this.getTable(fs, tableName);
        Entity entity = Entity.fromTable(table);
        entity.setAlias(fs.getFileName().substring(0, fs.getFileName().lastIndexOf(this.suffix)));
        return DesigntimeDataObject.createSingleDataObject(entity);
    }

    @Override
    public PreviewDataModel doGetPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rowCount) throws AbstractSourceException {
        TextSource fileSource = (TextSource)runtimeEntity.getSource();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return new PreviewDataModel(new ArrayList<Object[]>());
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        List<Object[]> result = Collections.emptyList();
        try {
            result = this.readAndFilter(null, rowCount, fileSource, true, iRuntimeFilter, runtimeEntity, null);
        }
        catch (AbstractDataSourceException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return new PreviewDataModel(result);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> readAndFilter(IDataSourceWriter dataSourceWriter, int rowCount, TextSource fileSource, boolean isPreview, IRuntimeFilter iRuntimeFilter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException, InterruptedException {
        block13: {
            block14: {
                fileResult = new FileResult();
                streamReader = null;
                previewResult = new ArrayList<Object[]>();
                ext = null;
                path = fileSource.getFileUrl();
                textLimitSign = fileSource.getTextLimitSign();
                ThreadCache.setIndex(0);
                ThreadCache.setRow(new HashMap<String, Object>());
                ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
                rc = new ResultContent();
                inputStream = this.getLocalFileInputStream(path);
                try {
                    streamReader = new InputStreamReader(inputStream, fileSource.getCharacterSet());
                    ext = new CSVReaderExt(streamReader, fileSource.getSplitSign().charAt(0), StringUtils.isBlank((CharSequence)textLimitSign) != false ? "\"".charAt(0) : textLimitSign.charAt(0));
                    rowIndex = 0;
                    row = new HashMap<String, String>();
lbl17:
                    // 3 sources

                    while (ext.isHasNext()) {
                        block15: {
                            ServerRequestInvokeContext.staticCheckInterrupt();
                            arr = ext.readNext();
                            if (previewResult.size() > rowCount && isPreview) break block13;
                            if (null == arr || arr.length == 0) continue;
                            if (rowIndex != 0) break block15;
                            for (n = 0; n < arr.length; ++n) {
                                colName = StringUtils.isBlank((CharSequence)arr[n]) != false ? "column" + n : arr[n];
                                colName = colName.replaceAll("\t", " ");
                                if (fileResult.getColIndexAndNameMap().containsValue(colName)) {
                                    j = ThreadCache.getIndex() + 1;
                                    colName = colName + "_" + j;
                                    ThreadCache.setIndex(j);
                                }
                                fileResult.getColIndexAndNameMap().put(n, colName);
                            }
                            fileResult.setColumnCount(arr.length);
                            ** GOTO lbl-1000
                        }
                        for (j = 0; j < arr.length; ++j) {
                            row.put(fileResult.getColIndexAndNameMap().get(j), arr[j]);
                        }
                        rowValueList = this.filterRow(rowIndex + 1, row, iRuntimeFilter, runtimeEntity, rc);
                        if (!CollectionUtils.isNotEmpty(rowValueList)) ** GOTO lbl-1000
                        for (Map<String, Object> rowValue : rowValueList) {
                            block16: {
                                objects = TextSourceDomain.getOutputData(rowValue, runtimeEntity, isPreview);
                                if (progressProcessor != null) {
                                    progressProcessor.dealOneRow();
                                }
                                if (!isPreview) break block16;
                                if (previewResult.size() <= rowCount) {
                                    previewResult.add(objects);
                                    continue;
                                }
                                ** GOTO lbl-1000
                            }
                            dataSourceWriter.writeData(objects);
                            if (progressProcessor == null) continue;
                            progressProcessor.writeOneRow();
                            if (!progressProcessor.isDataLimit()) continue;
                            var23_26 = previewResult;
                            break block14;
                        }
                        ** GOTO lbl-1000
                    }
                    break block13;
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        throw new FileSourceFileParseException(e);
                        catch (IOException e) {
                            throw new FileSourceFileParseException(e);
                        }
                    }
                    catch (Throwable var24_27) {
                        ThreadCache.removeIndex();
                        ThreadCache.removeRow();
                        ThreadCache.removeRowWithCalculate();
                        CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                        throw var24_27;
                    }
                }
            }
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
            CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
            return var23_26;
lbl-1000:
            // 4 sources

            {
                row.clear();
                ++rowIndex;
                ** GOTO lbl17
            }
        }
        ThreadCache.removeIndex();
        ThreadCache.removeRow();
        ThreadCache.removeRowWithCalculate();
        CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
        return previewResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doExtractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException, InterruptedException {
        TextSource fileSource;
        TraceSpan traceSpan;
        block3: {
            String string;
            traceSpan = null;
            try {
                traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"TXTDataTable", (String)"TXT\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
                traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
                traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
                traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
                fileSource = (TextSource)runtimeEntity.getSource();
                RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
                if (!prediction.isAlwaysFalse()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                TracerUtil.close(traceSpan);
                throw throwable;
            }
            TracerUtil.close((TraceSpan)traceSpan);
            return string;
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        this.readAndFilter(dataSourceWriter, -1, fileSource, false, iRuntimeFilter, runtimeEntity, progressProcessor);
        TracerUtil.close((TraceSpan)traceSpan);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileResult getColunms(TextSource textSource) throws AbstractFileSourceException {
        InputStreamReader streamReader = null;
        CSVReaderExt ext = null;
        FileResult fileResult = new FileResult();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        String filePathName = textSource.getFileUrl();
        int rowNo = textSource.getDefineTypeRowCount();
        String spliter = textSource.getSplitSign();
        String textLimitSign = textSource.getTextLimitSign();
        InputStream inputStream = this.getLocalFileInputStream(filePathName);
        try {
            streamReader = new InputStreamReader(inputStream, textSource.getCharacterSet());
            ext = new CSVReaderExt(streamReader, spliter.charAt(0), StringUtils.isBlank((CharSequence)textLimitSign) ? "\"".charAt(0) : textLimitSign.charAt(0));
            int i = 0;
            while (ext.isHasNext()) {
                String[] arr = ext.readNext();
                if (rowNo != i) {
                    if (null == arr) continue;
                    if (i == 0) {
                        for (int n = 0; n < arr.length; ++n) {
                            String colName;
                            String string = colName = null == arr[n] || StringUtils.isBlank((CharSequence)arr[n]) ? COLUMN + n : arr[n];
                            if (fileResult.getColIndexAndNameMap().containsValue(colName.trim())) {
                                Integer j = ThreadCache.getIndex() + 1;
                                colName = colName + "_" + j;
                                ThreadCache.setIndex(j);
                            }
                            fileResult.getColIndexAndNameMap().put(n, colName.replaceAll("\t", " ").trim());
                        }
                        fileResult.setColumnCount(arr.length);
                        ++i;
                        continue;
                    }
                }
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new FileSourceFileParseException(e);
                catch (IOException e2) {
                    throw new FileSourceFileParseException(e2);
                }
            }
            catch (Throwable throwable) {
                ThreadCache.removeIndex();
                CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                throw throwable;
            }
        }
        FileResult fileResult2 = fileResult;
        ThreadCache.removeIndex();
        CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
        return fileResult2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String defineType(int colIndex, TextSource textSource) throws AbstractFileSourceException {
        String string;
        HashSet<String> set;
        InputStream inputStream;
        CSVReaderExt ext;
        InputStreamReader streamReader;
        block12: {
            block11: {
                block10: {
                    streamReader = null;
                    ext = null;
                    String className = null;
                    String filePathName = textSource.getFileUrl();
                    int rowNo = textSource.getDefineTypeRowCount();
                    String spliter = textSource.getSplitSign();
                    String textLimitSign = textSource.getTextLimitSign();
                    inputStream = this.getLocalFileInputStream(filePathName);
                    streamReader = new InputStreamReader(inputStream, textSource.getCharacterSet());
                    ext = new CSVReaderExt(streamReader, spliter.charAt(0), StringUtils.isBlank((CharSequence)textLimitSign) ? "\"".charAt(0) : textLimitSign.charAt(0));
                    int i = 0;
                    set = new HashSet<String>();
                    while (ext.isHasNext()) {
                        String[] arr = ext.readNext();
                        if (rowNo == i) break;
                        if (null != arr && i != 0) {
                            String v = colIndex < arr.length ? arr[colIndex] : "";
                            v = v.trim();
                            className = this.calculateType2(v);
                        }
                        set.add(className);
                        ++i;
                        if (!"java.lang.String".equals(className)) continue;
                    }
                    if (!set.contains("java.lang.String")) break block10;
                    string = "java.lang.String";
                    CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                    return string;
                }
                if (set.size() <= 1) break block11;
                string = this.calculate(set);
                CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                return string;
            }
            if (set.toArray()[0] != null) break block12;
            string = "java.lang.String";
            CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
            return string;
        }
        try {
            string = set.size() > 0 ? set.toArray()[0].toString() : "java.lang.String";
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new FileSourceFileParseException(e);
                catch (IOException e2) {
                    throw new FileSourceFileParseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long doGetDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractFileSourceException {
        int rowCount;
        FileResult fileResult;
        CSVReaderExt ext;
        InputStreamReader streamReader;
        InputStream inputStream;
        block14: {
            inputStream = null;
            streamReader = null;
            ext = null;
            fileResult = new FileResult();
            TextSource textSource = (TextSource)runtimeEntity.getSource();
            String textLimitSign = textSource.getTextLimitSign();
            ThreadCache.setIndex(0);
            ThreadCache.setRow(new HashMap<String, Object>());
            ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
            rowCount = 0;
            inputStream = this.getLocalFileInputStream(textSource.getFileUrl());
            streamReader = new InputStreamReader(inputStream, textSource.getCharacterSet());
            ext = new CSVReaderExt(streamReader, textSource.getSplitSign().charAt(0), StringUtils.isBlank((CharSequence)textLimitSign) ? "\"".charAt(0) : textLimitSign.charAt(0));
            RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
            if (!prediction.isAlwaysFalse()) break block14;
            long l = 0L;
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
            CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
            return l;
        }
        try {
            IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
            int r = 0;
            HashMap<String, String> row = new HashMap<String, String>();
            ResultContent rc = new ResultContent();
            while (ext.isHasNext()) {
                if (!this.hasFilterOrColumnToRow(runtimeEntity) && r != 0) {
                    rowCount = (int)((long)rowCount + ext.count());
                    continue;
                }
                String[] arr = ext.readNext();
                if (null == arr || arr.length == 0) continue;
                if (r != 0) {
                    for (int j = 0; j < arr.length; ++j) {
                        row.put(fileResult.getColIndexAndNameMap().get(j), arr[j]);
                    }
                    List<Map<String, Object>> rowValue = this.filterRow(rowCount + 1, row, iRuntimeFilter, runtimeEntity, rc);
                    if (CollectionUtils.isNotEmpty(rowValue)) {
                        rowCount += rowValue.size();
                    }
                } else {
                    for (int n = 0; n < arr.length; ++n) {
                        String colName;
                        String string = colName = StringUtils.isBlank((CharSequence)arr[n]) ? COLUMN + n : arr[n];
                        if (fileResult.getColIndexAndNameMap().containsValue(colName)) {
                            colName = colName + n;
                        }
                        fileResult.getColIndexAndNameMap().put(n, colName);
                    }
                    fileResult.setColumnCount(arr.length);
                }
                ++r;
                row.clear();
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new FileSourceFileParseException(e);
                catch (IOException e2) {
                    throw new FileSourceFileParseException(e2);
                }
            }
            catch (Throwable throwable) {
                ThreadCache.removeIndex();
                ThreadCache.removeRow();
                ThreadCache.removeRowWithCalculate();
                CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
                throw throwable;
            }
        }
        ThreadCache.removeIndex();
        ThreadCache.removeRow();
        ThreadCache.removeRowWithCalculate();
        CloseUtil.close((Closeable[])new Closeable[]{streamReader, inputStream, ext});
        return rowCount;
    }

    private boolean hasFilterOrColumnToRow(RuntimeEntity runtimeEntity) {
        boolean isUnionColumnToRow = false;
        EntityExtractContext entityExtractContext = runtimeEntity.getEntityExtractContext();
        if (entityExtractContext != null && CollectionUtils.isNotEmpty(entityExtractContext.getColumnToRowProperties())) {
            isUnionColumnToRow = true;
        }
        return runtimeEntity.getUnPushdownableFilter() != null || runtimeEntity.getPushdownableFilter() != null || CollectionUtils.isNotEmpty(runtimeEntity.getOrinalEntity().getColumnToRowProperties()) || isUnionColumnToRow;
    }

    private InputStream getLocalFileInputStream(String filePathName) throws AbstractFileSourceException {
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)filePathName);
        if (!file.exists()) {
            file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePathName);
        }
        try {
            return file.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new FileSourceFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new FileSourceFileAccessException(e);
        }
    }
}

