/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07;

import com.kingdee.bos.qing.data.domain.source.file.excel07.Excel07SaxReaderContext;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.MergeCellRange;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.CElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.ElementHandlerAdapter;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.IElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.MergeElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.RowElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.TElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.VElementHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.IRowDataHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Excel07SaxReader
extends DefaultHandler {
    private Excel07SaxReaderContext context;
    private Map<String, IElementHandler> elementHandlerMap = new HashMap<String, IElementHandler>();
    private IElementHandler currentElementHandler;

    public static Excel07SaxReader newRowDatasReader(List<MergeCellRange> mergeCellRanges, IRowDataHandler rowDataHandler) {
        Excel07SaxReaderContext context = new Excel07SaxReaderContext();
        context.setRowDataHandler(rowDataHandler);
        context.setMergeCellRanges(mergeCellRanges);
        Excel07SaxReader contentSaxHandler = new Excel07SaxReader(context);
        contentSaxHandler.setElementHandlers(Arrays.asList(new CElementHandler(), new TElementHandler(), new VElementHandler(), new RowElementHandler()));
        return contentSaxHandler;
    }

    public static Excel07SaxReader newMergeCellReader(IRowDataHandler rowDataHandler) {
        Excel07SaxReaderContext context = new Excel07SaxReaderContext();
        context.setRowDataHandler(rowDataHandler);
        Excel07SaxReader contentSaxHandler = new Excel07SaxReader(context);
        contentSaxHandler.setElementHandlers(Arrays.asList(new MergeElementHandler(), new RowElementHandler()));
        return contentSaxHandler;
    }

    private Excel07SaxReader(Excel07SaxReaderContext context) {
        this.context = context;
    }

    private void setElementHandlers(List<ElementHandlerAdapter> elementHandlers) {
        for (IElementHandler iElementHandler : elementHandlers) {
            this.elementHandlerMap.put(iElementHandler.getElementFlag(), iElementHandler);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElementHandler = this.elementHandlerMap.get(qName);
        if (null != this.currentElementHandler) {
            this.currentElementHandler.handleStart(attributes, this.context);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (null != this.currentElementHandler) {
            String content = new String(ch, start, length);
            this.currentElementHandler.handleElementContent(content, this.context);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        IElementHandler elementHandler = this.elementHandlerMap.get(qName);
        if (elementHandler != null) {
            elementHandler.handleEnd(this.context);
        }
    }

    public Excel07SaxReaderContext getContext() {
        return this.context;
    }
}

