/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.MergeCellRange;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelFastMeta
implements ISessionCacheable {
    private Map<String, SheetMeta> metaMap = new HashMap<String, SheetMeta>();
    private List<String> sheetNames;
    private String originalExcelFileName;
    private transient boolean contentChanged = false;

    public void setMergeCellRanges(String sheetName, List<MergeCellRange> ranges) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        sheetMeta.setMergeCellRanges(ranges);
        this.contentChanged = true;
    }

    public String getOriginalExcelFileName() {
        return this.originalExcelFileName;
    }

    public void setOriginalExcelFileName(String originalExcelFileName) {
        this.originalExcelFileName = originalExcelFileName;
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public void setTotalCount(String sheetName, int totalCount) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        sheetMeta.setTotalCount(totalCount);
        this.contentChanged = true;
    }

    public int getTotalCount(String sheetName) {
        SheetMeta sheetMeta = this.metaMap.get(sheetName);
        if (null == sheetMeta) {
            return -1;
        }
        return sheetMeta.getTotalCount();
    }

    public Map<Integer, String> getColIndexMap(String sheetName) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        return sheetMeta.getColIndexMap();
    }

    public void setColIndexMap(String sheetName, Map<Integer, String> colIndexMap) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        sheetMeta.setColIndexMap(colIndexMap);
        this.contentChanged = true;
    }

    public void setColTypes(String sheetName, Map<Integer, String> types) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        sheetMeta.setColTypes(types);
        this.contentChanged = true;
    }

    public Map<Integer, String> getColTypes(String sheetName) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        return sheetMeta.getColTypes();
    }

    private SheetMeta getSheetMeta(String sheetName) {
        SheetMeta sheetMeta = this.metaMap.get(sheetName);
        if (null == sheetMeta) {
            sheetMeta = new SheetMeta();
            this.metaMap.put(sheetName, sheetMeta);
        }
        return sheetMeta;
    }

    public List<MergeCellRange> getMergeCellRanges(String sheetName) {
        SheetMeta sheetMeta = this.metaMap.get(sheetName);
        if (null == sheetMeta) {
            return null;
        }
        return sheetMeta.getMergeCellRanges();
    }

    public String getFilterMd5(String sheetName) {
        SheetMeta sheetMeta = this.getSheetMeta(sheetName);
        return sheetMeta.getFilterMd5();
    }

    public void setFilterMd5(String sheetName, String md5) {
        this.getSheetMeta(sheetName).setFilterMd5(md5);
        this.contentChanged = true;
    }

    public String getCacheKey() {
        return this.originalExcelFileName;
    }

    public String toJson() {
        return JsonUtil.encodeToString((Object)this);
    }

    public ISessionCacheable fromJson(String json) {
        return (ISessionCacheable)JsonUtil.decodeFromString((String)json, ExcelFastMeta.class);
    }

    public int getTimeoutSeconds() {
        return 172800;
    }

    public List<String> getSheetNames() {
        return this.sheetNames;
    }

    public void setSheetNames(List<String> sheetNames) {
        this.sheetNames = sheetNames;
    }

    private static class SheetMeta {
        private List<MergeCellRange> mergeCellRanges;
        private int totalCount;
        private Map<Integer, String> colTypes;
        private Map<Integer, String> colIndexMap;
        private String filterMd5;

        private SheetMeta() {
        }

        public String getFilterMd5() {
            return this.filterMd5;
        }

        public void setFilterMd5(String filterMd5) {
            this.filterMd5 = filterMd5;
        }

        public Map<Integer, String> getColIndexMap() {
            return this.colIndexMap;
        }

        public void setColIndexMap(Map<Integer, String> colIndexMap) {
            this.colIndexMap = colIndexMap;
        }

        public List<MergeCellRange> getMergeCellRanges() {
            return this.mergeCellRanges;
        }

        public void setMergeCellRanges(List<MergeCellRange> mergeCellRanges) {
            this.mergeCellRanges = mergeCellRanges;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public Map<Integer, String> getColTypes() {
            return this.colTypes;
        }

        public void setColTypes(Map<Integer, String> colTypes) {
            this.colTypes = colTypes;
        }
    }
}

