/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.Excel07SaxReaderContext;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.BooleanCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.DateCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.EmptyCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.FormulaCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.InlineStringCell;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.NumberCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.SstStringCellInfo;
import com.kingdee.bos.qing.data.util.ExcelDataUtil;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;

public class CellFactory {
    public static CellInfo createCellInfo(CellDataType cellDataType, Attributes attributes, Excel07SaxReaderContext context) {
        CellInfo cellInfo = null;
        switch (cellDataType) {
            case BOOL: {
                cellInfo = new BooleanCellInfo();
                break;
            }
            case FORMULA: {
                cellInfo = new FormulaCellInfo();
                break;
            }
            case NUMBER: {
                cellInfo = new NumberCellInfo();
                break;
            }
            case INLINESTR: {
                cellInfo = new InlineStringCell();
                break;
            }
            case SSTINDEX: {
                cellInfo = new SstStringCellInfo();
                break;
            }
            default: {
                cellInfo = new EmptyCellInfo();
            }
        }
        cellInfo.setCellAddress(attributes.getValue("r"));
        CellFactory.setCellFormatInfo(cellInfo, attributes, context);
        cellInfo = CellFactory.convertIfIsDateType(cellInfo);
        return cellInfo;
    }

    private static void setCellFormatInfo(CellInfo cellInfo, Attributes attributes, Excel07SaxReaderContext context) {
        String xfIndexStr = attributes.getValue("s");
        if (xfIndexStr != null) {
            XSSFCellStyle xssfCellStyle = context.getStylesTable().getStyleAt(Integer.parseInt(xfIndexStr));
            short numFmtIndex = xssfCellStyle.getDataFormat();
            String numFmtString = CellFactory.getFmtString(xssfCellStyle, numFmtIndex);
            cellInfo.setNumFmtIndex(numFmtIndex);
            cellInfo.setNumFmtString(numFmtString);
        }
    }

    private static String getFmtString(XSSFCellStyle xssfCellStyle, int numFmtIndex) {
        String numFmtString = xssfCellStyle.getDataFormatString();
        if (numFmtString == null) {
            numFmtString = BuiltinFormats.getBuiltinFormat((int)numFmtIndex);
        }
        return numFmtString;
    }

    private static CellInfo convertIfIsDateType(CellInfo cellInfo) {
        if (ExcelDataUtil.isDateCell(cellInfo)) {
            DateCellInfo dateCellInfo = new DateCellInfo();
            dateCellInfo.setLocation(cellInfo.getRow(), cellInfo.getCol());
            dateCellInfo.setNumFmtIndex(cellInfo.getNumFmtIndex());
            dateCellInfo.setNumFmtString(cellInfo.getNumFmtString());
            dateCellInfo.setCellDataType(CellDataType.DATE);
            return dateCellInfo;
        }
        return cellInfo;
    }
}

