/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.IRowDataHandler;
import com.kingdee.bos.qing.data.exception.file.sax.InterruptedSAXException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;
import shaded.com.google.common.collect.Maps;

public class ColumnTypeHandler
implements IRowDataHandler<Map<String, Set<String>>> {
    private int limitRow = 50;
    private Map<Integer, String> colIndexAndNameMap;
    private Map<String, Set<String>> columnTypeMap = Maps.newHashMap();

    public ColumnTypeHandler(Map<Integer, String> colIndexAndNameMap, int limitRow) {
        this.colIndexAndNameMap = colIndexAndNameMap;
        this.limitRow = limitRow;
    }

    @Override
    public void handle(int rowNum, List<CellInfo> cellInfos) throws SAXException {
        if (rowNum == 1) {
            return;
        }
        if (rowNum > this.limitRow && this.limitRow != -1) {
            throw new InterruptedSAXException();
        }
        for (CellInfo cellInfo : cellInfos) {
            int col = cellInfo.getCol();
            String colName = this.colIndexAndNameMap.get(col);
            Set<String> colTypeSets = this.getOrCreateColTypeSets(colName);
            String type = cellInfo.getDataTypeClassName();
            if (null == type) continue;
            colTypeSets.add(type);
        }
    }

    private Set<String> getOrCreateColTypeSets(String colName) {
        Set<String> colTypeSets = this.columnTypeMap.get(colName);
        if (null == colTypeSets) {
            colTypeSets = new HashSet<String>();
            this.columnTypeMap.put(colName, colTypeSets);
        }
        return colTypeSets;
    }

    @Override
    public Map<String, Set<String>> getHandleResult() {
        return this.columnTypeMap;
    }
}

