/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.exception.file.hssf.ExcelReadEndException;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import shaded.com.google.common.collect.Maps;

public class XlsColumnNameHandler
extends ResultContent
implements XlsSheetContentsHandler {
    private Map<Integer, String> colIndexAndNameMap = Maps.newHashMap();
    public static final int CAL_COL_READ_ROW_SIZE = 50;
    private int currentMaxColSize;

    public Map<Integer, String> getColIndexAndNameMap() {
        return this.colIndexAndNameMap;
    }

    @Override
    public void endRow(int thisRow) throws HSSFUserException {
        if (thisRow == 50) {
            this.removeExtraCol();
            throw new ExcelReadEndException();
        }
    }

    @Override
    public void cell(int thisRow, int thisColumn, String comment) {
        if (thisRow == 0) {
            if (this.colIndexAndNameMap.containsValue(comment)) {
                Integer i = ThreadCache.getIndex() + 1;
                comment = comment + "_" + i;
                ThreadCache.setIndex(i);
            }
            comment = comment.replaceAll("[\t\r\n]+", " ");
            this.colIndexAndNameMap.put(thisColumn, StringUtils.isBlank((CharSequence)comment) ? "column" + thisColumn : comment);
        }
    }

    private void removeExtraCol() {
        int size = this.colIndexAndNameMap.size();
        for (int i = this.currentMaxColSize; i < size; ++i) {
            this.colIndexAndNameMap.remove(i);
        }
    }

    public int getCurrentMaxColSize() {
        return this.currentMaxColSize;
    }

    public void setCurrentMaxColSize(int currentMaxColSize) {
        this.currentMaxColSize = currentMaxColSize;
    }
}

