/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.file.hssf.DataSourceExceptionHSSFUserException;
import com.kingdee.bos.qing.data.exception.file.hssf.ExcelReadEndException;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import shaded.com.google.common.collect.Maps;

public class XlsSheetContentsHandlerImpl
extends ResultContent
implements XlsSheetContentsHandler {
    private ProgressProcessor progressProcessor;
    private RunningTimeParams params;
    private Map<String, String> row = Maps.newHashMap();
    private Map<String, String> mergeCellsIndex;
    private Map<Integer, String> colIndexAndNameMap;
    private Map<Integer, Map<String, String>> cacheRows = Maps.newHashMap();
    private Map<Integer, Map<String, Object>> filteredRow = Maps.newHashMap();
    private int topN;

    public Map<Integer, Map<String, Object>> getFilteredRow() {
        return this.filteredRow;
    }

    public XlsSheetContentsHandlerImpl(RunningTimeParams params, Map<Integer, String> colIndexAndNameMap, Map<String, String> mergeCellsIndex, ProgressProcessor progressProcessor) {
        this.params = params;
        this.topN = params.getTopN();
        this.colIndexAndNameMap = colIndexAndNameMap;
        this.mergeCellsIndex = mergeCellsIndex;
        this.progressProcessor = progressProcessor;
    }

    @Override
    public void endRow(int thisRow) throws HSSFUserException {
        int limit = this.getPreviewResultSize();
        if (this.topN == limit && this.params.getRuntimeFilter() == null) {
            throw new ExcelReadEndException();
        }
        if (this.topN == limit && this.params.getRuntimeFilter() != null) {
            throw new ExcelReadEndException();
        }
        List<Map<String, Object>> filterRowList = null;
        try {
            if (null != this.params.getRuntimeEntity() && thisRow != 0 && CollectionUtils.isNotEmpty(filterRowList = this.params.getFileSourceDomain().filterRow(thisRow, this.row, this.params.getRuntimeFilter(), this.params.getRuntimeEntity(), this))) {
                for (Map<String, Object> filterRow : filterRowList) {
                    Object[] objects = AbstractDataSourceDomain.getOutputData(filterRow, this.params.getRuntimeEntity(), this.params.isPreview());
                    if (this.progressProcessor != null) {
                        this.progressProcessor.dealOneRow();
                    }
                    if (this.params.isPreview()) {
                        if (this.getPreviewResultSize() >= this.topN) {
                            break;
                        }
                        this.addPreviewResult(objects);
                        continue;
                    }
                    this.params.getDataSourceWriter().writeData(objects);
                    if (this.progressProcessor == null) continue;
                    this.progressProcessor.writeOneRow();
                    if (!this.progressProcessor.isDataLimit()) continue;
                    throw new ExcelReadEndException();
                }
            }
        }
        catch (DataSourcePersistenceException e) {
            throw new DataSourceExceptionHSSFUserException(e);
        }
        catch (InterruptedException e) {
            throw new HSSFUserException((Throwable)e);
        }
        finally {
            this.row.clear();
            ThreadCache.getRow().clear();
            this.cacheRows.remove(thisRow);
        }
    }

    @Override
    public void cell(int thisRow, int thisColumn, String comment) {
        if (thisColumn > -1) {
            String value;
            Map<String, String> cacheRow = this.cacheRows.get(thisRow);
            if (cacheRow != null) {
                this.row = cacheRow;
            }
            if (!this.row.containsKey(this.colIndexAndNameMap.get(thisColumn))) {
                this.row.put(this.colIndexAndNameMap.get(thisColumn), comment);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = this.mergeCellsIndex.get(thisRow + "-" + thisColumn)))) {
                String[] arr = value.split("-");
                int maxR = Integer.parseInt(arr[0]);
                int maxC = Integer.parseInt(arr[1]);
                for (int r = thisRow; r <= maxR && thisRow != 0; ++r) {
                    for (int c = thisColumn; c <= maxC; ++c) {
                        if (thisRow != r) {
                            HashMap row = this.cacheRows.get(r);
                            if (row == null) {
                                row = Maps.newHashMap();
                            }
                            row.put(this.colIndexAndNameMap.get(c), comment);
                            this.cacheRows.put(r, row);
                            continue;
                        }
                        this.row.put(this.colIndexAndNameMap.get(c), comment);
                    }
                }
            }
        }
    }
}

