/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.model.XmlParseDataModel;
import com.kingdee.bos.qing.data.util.DataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlColTypeHandler
extends DefaultHandler {
    private List<String> levelList = new ArrayList<String>(10);
    private int rowCount;
    private int recordIndex = -1;
    private String[] xPath;
    private int limitCount;
    private Map<Integer, String> colIndexNameMap;
    private Map<String, Set<String>> colTypeMap;
    private Map<String, String> collectTypeMap = new HashMap<String, String>(16);

    public XmlColTypeHandler(String[] xPath, int limitCount, Map<Integer, String> colIndexNameMap, Map<String, Set<String>> colTypeMap) {
        this.xPath = xPath;
        this.limitCount = limitCount;
        this.colIndexNameMap = colIndexNameMap;
        this.colTypeMap = colTypeMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.rowCount > this.limitCount && this.limitCount > 0) {
            return;
        }
        this.levelList.add(qName);
        if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
            this.recordIndex = this.colIndexNameMap.containsValue(qName) ? XmlParseDataModel.getKey(this.colIndexNameMap, qName) : -1;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recordIndex > -1) {
            String text = new String(ch, start, length);
            String colName = this.colIndexNameMap.get(this.recordIndex);
            text = text.trim();
            String className = DataTypeUtils.getDataTypeClassName(text);
            this.collectTypeMap.put(colName, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (XmlParseDataModel.isRecordWrapTag(this.levelList, this.xPath)) {
                this.fixColType();
                for (Map.Entry<String, String> entry : this.collectTypeMap.entrySet()) {
                    String colName = entry.getKey();
                    String className = entry.getValue();
                    if (this.colTypeMap.containsKey(colName)) {
                        this.colTypeMap.get(colName).add(className);
                        continue;
                    }
                    HashSet<String> classSet = new HashSet<String>();
                    classSet.add(className);
                    this.colTypeMap.put(colName, classSet);
                }
                ++this.rowCount;
                this.collectTypeMap.clear();
            } else if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
                this.recordIndex = -1;
            }
        }
        finally {
            if (!this.levelList.isEmpty()) {
                this.levelList.remove(this.levelList.size() - 1);
            }
        }
    }

    private void fixColType() {
        if (this.collectTypeMap.size() != this.colIndexNameMap.size()) {
            for (String colName : this.colIndexNameMap.values()) {
                if (this.collectTypeMap.containsKey(colName)) continue;
                this.collectTypeMap.put(colName, "java.lang.String");
            }
        }
    }
}

