/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.source.file.model.XmlParseDataModel;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlTopNRowHandler
extends DefaultHandler {
    private List<String> levelList = new ArrayList<String>(10);
    private int rowCount;
    private int recordIndex = -1;
    private String[] xPath;
    private int topN;
    private boolean isPreview;
    private IRuntimeFilter iRuntimeFilter;
    private RuntimeEntity runtimeEntity;
    private IDataSourceWriter dataSourceWriter;
    private ProgressProcessor progressProcessor;
    private Map<String, String> row = new HashMap<String, String>(16);
    private ResultContent rc = new ResultContent();
    private Map<Integer, String> colIndexNameMap;
    private XmlParseDataModel xmlParseDataModel;
    private StringBuilder characters;
    private ResultContent resultContent = new ResultContent();

    public XmlTopNRowHandler(RunningTimeParams params, ProgressProcessor progressProcessor, String[] xPath, Map<Integer, String> colIndexNameMap, XmlParseDataModel xmlParseDataModel) {
        this.topN = params.getTopN();
        this.isPreview = params.isPreview();
        this.runtimeEntity = params.getRuntimeEntity();
        this.iRuntimeFilter = params.getRuntimeFilter();
        this.dataSourceWriter = params.getDataSourceWriter();
        this.progressProcessor = progressProcessor;
        this.xPath = xPath;
        this.colIndexNameMap = colIndexNameMap;
        this.xmlParseDataModel = xmlParseDataModel;
    }

    public ResultContent getResultContent() {
        return this.resultContent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.resultContent.getPreviewResult().size() > this.topN && this.isPreview) {
            return;
        }
        this.levelList.add(qName);
        if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
            this.recordIndex = this.colIndexNameMap.containsValue(qName) ? XmlParseDataModel.getKey(this.colIndexNameMap, qName) : -1;
        }
        this.characters = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.recordIndex > -1) {
            String value = this.characters.toString();
            if (this.row.get(this.colIndexNameMap.get(this.recordIndex)) != null) {
                value = this.row.get(this.colIndexNameMap.get(this.recordIndex)) + "," + value;
            }
            this.row.put(this.colIndexNameMap.get(this.recordIndex), value);
        }
        try {
            if (XmlParseDataModel.isRecordWrapTag(this.levelList, this.xPath)) {
                ++this.rowCount;
                List<Map<String, Object>> rowValueList = this.xmlParseDataModel.getFileSourceDomain().filterRow(this.rowCount + 1, this.row, this.iRuntimeFilter, this.runtimeEntity, this.rc);
                if (CollectionUtils.isNotEmpty(rowValueList)) {
                    for (Map<String, Object> rowValue : rowValueList) {
                        Object[] objects = AbstractDataSourceDomain.getOutputData(rowValue, this.runtimeEntity, this.isPreview);
                        if (this.progressProcessor != null) {
                            this.progressProcessor.dealOneRow();
                        }
                        if (this.isPreview) {
                            if (this.resultContent.getPreviewResult().size() > this.topN) break;
                            this.resultContent.addPreviewResult(objects);
                            continue;
                        }
                        this.dataSourceWriter.writeData(objects);
                        if (this.progressProcessor == null) continue;
                        this.progressProcessor.writeOneRow();
                        if (!this.progressProcessor.isDataLimit()) continue;
                        break;
                    }
                }
                this.row.clear();
            } else if (XmlParseDataModel.needReadRecord(this.levelList, this.xPath)) {
                this.recordIndex = -1;
            }
        }
        catch (DataSourcePersistenceException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!this.levelList.isEmpty()) {
                this.levelList.remove(this.levelList.size() - 1);
            }
            this.characters.setLength(0);
        }
    }
}

