/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.visitor;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.data.domain.visitor.AbstractEntityDataSourceVisitor;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEntityDirectModelDataSourceVisitor
extends AbstractEntityDataSourceVisitor {
    protected QingContext qingContext;
    protected AbstractSource source;
    protected Set<String> whitePropertySet;
    protected String ownerId;

    public AbstractEntityDirectModelDataSourceVisitor(QingContext qingContext, AbstractSource source, AbstractEntity entity, DSMetaEntity dsMetaEntity, Set<String> whitePropertySet, String ownerId) {
        super(entity, dsMetaEntity);
        this.qingContext = qingContext;
        this.source = source;
        this.whitePropertySet = whitePropertySet;
        this.ownerId = ownerId;
    }

    public abstract IDataIterator iterator() throws AbstractDataSourceException;

    public void doCollectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, List<DSFieldKey> exsitField, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        AbstractEntityDirectModelDataSourceVisitor.collectDistinctValueWithIterator((IDataIterator)this.iterator(), (IDistinctValueCollecter)valueCollecter, fields, exsitField, filters);
    }

    public final Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        Calendar maxCalendar = null;
        Calendar minCalendar = null;
        String fieldName = field.getPropertyName();
        int fieldNameIndex = this.metaInfo.getFieldNameIndex(fieldName);
        if (fieldNameIndex >= 0) {
            HashSet<DSFieldKey> selectedDSFieldKey = new HashSet<DSFieldKey>();
            selectedDSFieldKey.add(field);
            IDataIterator dataIterator = this.iterator();
            dataIterator.init(selectedDSFieldKey, null, null);
            while (dataIterator.hasNextRow()) {
                Map oneRowData = dataIterator.nextRow();
                Object value = oneRowData.get(field.toFullName());
                Calendar calendarValue = null;
                if (value instanceof Calendar) {
                    calendarValue = (Calendar)value;
                } else if (value instanceof Date) {
                    Date date = (Date)value;
                    calendarValue = Calendar.getInstance();
                    calendarValue.setTimeInMillis(date.getTime());
                } else if (value instanceof Long) {
                    Long longValue = (Long)value;
                    calendarValue = Calendar.getInstance();
                    calendarValue.setTimeInMillis(longValue);
                }
                if (maxCalendar == null) {
                    maxCalendar = calendarValue;
                } else if (calendarValue != null && calendarValue.compareTo(maxCalendar) > 0) {
                    maxCalendar = calendarValue;
                }
                if (minCalendar == null) {
                    minCalendar = calendarValue;
                    continue;
                }
                if (calendarValue == null || calendarValue.compareTo(minCalendar) >= 0) continue;
                minCalendar = calendarValue;
            }
        }
        return new Calendar[]{minCalendar, maxCalendar};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData()) {
            return null;
        }
        String fieldName = field.getPropertyName();
        int fieldNameIndex = this.metaInfo.getFieldNameIndex(fieldName);
        DataType dataType = this.metaInfo.getFieldDataType(fieldNameIndex);
        if (dataType == null || DataType.INT != dataType && DataType.NUMBER != dataType) {
            return null;
        }
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        IDataIterator iterator = this.iterator();
        try {
            HashSet<DSFieldKey> keys = new HashSet<DSFieldKey>();
            keys.add(field);
            iterator.init(keys, null, null);
            while (iterator.hasNextRow()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                Map row = iterator.nextRow();
                Object value = row.get(field.toFullName());
                if (value == null) continue;
                BigDecimal comparingValue = null;
                comparingValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value));
                minValue = minValue == null ? comparingValue : minValue.min(comparingValue);
                if (maxValue == null) {
                    maxValue = comparingValue;
                    continue;
                }
                maxValue = maxValue.max(comparingValue);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new BigDecimal[]{minValue, maxValue};
    }
}

