/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowPropertyItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ColumnToRowProperty {
    private Property fieldNameProperty;
    private List<Property> fieldValueProperties;
    private List<ColumnToRowPropertyItem> columnToRowPropertyItems;

    public Property getFieldNameProperty() {
        return this.fieldNameProperty;
    }

    public List<Property> getFieldValueProperties() {
        return this.fieldValueProperties;
    }

    public List<ColumnToRowPropertyItem> getColumnToRowPropertyItems() {
        return this.columnToRowPropertyItems;
    }

    public List<String> getUsedColumnToRowPropertyNames() {
        ArrayList<String> resultList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.columnToRowPropertyItems)) {
            for (ColumnToRowPropertyItem columnToRowPropertyItem : this.columnToRowPropertyItems) {
                resultList.addAll(columnToRowPropertyItem.getPropertyValues());
            }
        }
        return resultList;
    }

    public List<String> getFieldValueNames() {
        ArrayList<String> resultList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.fieldValueProperties)) {
            for (Property property : this.fieldValueProperties) {
                resultList.add(property.getName());
            }
        }
        return resultList;
    }

    public Element toXml() {
        Element root = new Element("ColumnToRowProperty");
        if (this.fieldNameProperty != null) {
            Element fieldValueNamesNode = new Element("FieldNameProperty");
            fieldValueNamesNode.addContent((Content)this.fieldNameProperty.toXml());
            root.addContent((Content)fieldValueNamesNode);
        }
        if (CollectionUtils.isNotEmpty(this.fieldValueProperties)) {
            Element fieldValuePropertiesNode = new Element("FieldValueProperties");
            for (Property fieldValueProperty : this.fieldValueProperties) {
                Element element = fieldValueProperty.toXml();
                fieldValuePropertiesNode.addContent((Content)element);
            }
            root.addContent((Content)fieldValuePropertiesNode);
        }
        if (CollectionUtils.isNotEmpty(this.columnToRowPropertyItems)) {
            Element columnToRowPropertyItemsNode = new Element("ColumnToRowPropertyItems");
            for (ColumnToRowPropertyItem columnToRowPropertyItem : this.columnToRowPropertyItems) {
                columnToRowPropertyItemsNode.addContent((Content)columnToRowPropertyItem.toXml());
            }
            root.addContent((Content)columnToRowPropertyItemsNode);
        }
        return root;
    }

    public void fromXml(Element columnToRowPropertyElement) throws ModelParseException {
        Iterator iterator;
        Element nodeFieldNameProperty = columnToRowPropertyElement.getChild("FieldNameProperty");
        if (nodeFieldNameProperty != null && (iterator = nodeFieldNameProperty.getChildren().iterator()).hasNext()) {
            Element nodeProperty = (Element)iterator.next();
            this.fieldNameProperty = new Property();
            this.fieldNameProperty.fromXml(nodeProperty);
        }
        Element fieldValuePropertiesElement = columnToRowPropertyElement.getChild("FieldValueProperties");
        List fieldValuePropertiesChildren = fieldValuePropertiesElement.getChildren();
        Iterator fieldValuePropertiesIterator = fieldValuePropertiesChildren.iterator();
        this.fieldValueProperties = new ArrayList<Property>(fieldValuePropertiesChildren.size());
        while (fieldValuePropertiesIterator.hasNext()) {
            Element fieldValueNameElement = (Element)fieldValuePropertiesIterator.next();
            Property property = new Property();
            property.fromXml(fieldValueNameElement);
            this.fieldValueProperties.add(property);
        }
        Element columnToRowPropertyItemsElement = columnToRowPropertyElement.getChild("ColumnToRowPropertyItems");
        List columnToRowPropertyItemsChildren = columnToRowPropertyItemsElement.getChildren();
        this.columnToRowPropertyItems = new ArrayList<ColumnToRowPropertyItem>(columnToRowPropertyItemsChildren.size());
        for (Element columnToRowPropertyItemElement : columnToRowPropertyItemsChildren) {
            ColumnToRowPropertyItem columnToRowPropertyItem = new ColumnToRowPropertyItem();
            columnToRowPropertyItem.fromXml(columnToRowPropertyItemElement);
            this.columnToRowPropertyItems.add(columnToRowPropertyItem);
        }
    }

    public String toString() {
        StringBuilder sColumnToRowPropertyItems = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.columnToRowPropertyItems)) {
            sColumnToRowPropertyItems.append("[");
            for (ColumnToRowPropertyItem columnToRowPropertyItem : this.columnToRowPropertyItems) {
                sColumnToRowPropertyItems.append(columnToRowPropertyItem.toString());
            }
            sColumnToRowPropertyItems.append("]");
        }
        StringBuilder sFieldValueProperties = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.fieldValueProperties)) {
            sFieldValueProperties.append("[");
            for (Property property : this.fieldValueProperties) {
                sFieldValueProperties.append(property.getName()).append(",");
            }
            sFieldValueProperties = sFieldValueProperties.delete(sFieldValueProperties.length() - 1, sFieldValueProperties.length());
            sFieldValueProperties.append("]");
        }
        return "ColumnToRowProperty{fieldNameProperty=" + this.fieldNameProperty.getName() + ", fieldValueProperties=" + sFieldValueProperties.toString() + ", columnToRowPropertyItems=" + sColumnToRowPropertyItems.toString() + "}";
    }

    public Property getProperty(String propName) {
        if (propName.equals(this.fieldNameProperty.getName())) {
            return this.fieldNameProperty;
        }
        for (Property property : this.fieldValueProperties) {
            if (!property.getName().equals(propName)) continue;
            return property;
        }
        return null;
    }
}

