/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.domain.source.db.DataTypeToDesigningDataType;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.annotations.FieldPersistable;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.IEntityExtensionProvider;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.IPropertyFilter;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jdom2.Element;

public class Entity
extends AbstractEntity {
    private String source;
    private boolean isUnionUnit;
    private int unionLocation = -1;
    @FieldPersistable(value=false)
    private transient IEntityExtensionProvider<?> extensionProvider;

    public <T> T getExtension(Class<T> klass) {
        if (null == this.extensionProvider) {
            return null;
        }
        if (this.extensionProvider.getExtendObject() == null) {
            return null;
        }
        return klass.cast(this.extensionProvider.getExtendObject());
    }

    public void setExtensionProvider(IEntityExtensionProvider extension) {
        this.extensionProvider = extension;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUnionUnit(boolean isUnionUnit) {
        this.isUnionUnit = isUnionUnit;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.SINGLE;
    }

    public int getUnionLocation() {
        return this.unionLocation;
    }

    public void setUnionLocation(int unionLocation) {
        this.unionLocation = unionLocation;
    }

    @Override
    public boolean isRealDataEntity() {
        return true;
    }

    @Override
    public boolean isUnionUnitEntity() {
        return this.isUnionUnit;
    }

    @Override
    protected void subToXml(Element node) {
        node.setAttribute("source", this.source);
        if (this.isUnionUnit) {
            node.setAttribute("unionUnit", "true");
            if (this.unionLocation > -1) {
                node.setAttribute("unionLocation", String.valueOf(this.unionLocation));
            }
        }
    }

    @Override
    protected void subFromXml(Element node, Set<String> unknownSourceNames) throws ModelParseException {
        this.source = node.getAttributeValue("source");
        this.isUnionUnit = Boolean.parseBoolean(node.getAttributeValue("unionUnit"));
        String unionLocationValue = node.getAttributeValue("unionLocation");
        if (null != unionLocationValue) {
            this.unionLocation = Integer.parseInt(unionLocationValue);
        }
        if (this.source == null) {
            throw new ModelParseException("Entity's source info not found.");
        }
    }

    @Override
    public boolean isIgnore(Set<String> unknownSourceNames) {
        return unknownSourceNames.contains(this.source);
    }

    @Override
    public boolean isInvalid() {
        if (!this.isUnionUnit) {
            return !this.isPropertyExist() || this.existNullAttributeValue(new String[]{this.getName(), this.getAlias(), this.getAssociateName()});
        }
        return this.existNullAttributeValue(new String[]{this.getName(), this.getAlias(), this.getAssociateName()});
    }

    @Override
    public Property getProperties(IPropertyFilter filter) {
        Property matched = super.getProperties(filter);
        if (null != matched) {
            return matched;
        }
        for (TreeProperty treeProperty : this.getTreeNodeProperties()) {
            Property property = treeProperty.getProperties(filter);
            if (null == property) continue;
            return property;
        }
        return null;
    }

    public Entity copy() throws ModelParseException {
        Entity newEntity = new Entity();
        newEntity.fromXml(this.toXml(), null);
        newEntity.setExtensionProvider(this.extensionProvider);
        if (null != this.getTreeNodeProperties()) {
            newEntity.setTreeNodeProperties(Collections.unmodifiableList(this.getTreeNodeProperties()));
        }
        return newEntity;
    }

    public static Entity fromTable(Table table) {
        Entity entity = new Entity();
        entity.setName(NameUtil.getPureName((String)table.getName(), null));
        entity.setAssociateName(table.getName());
        entity.setAlias(table.getName());
        entity.setCommentInfo(table.getDisplayName() == null || table.getDisplayName().equals("") ? table.getName() : table.getDisplayName());
        entity.setSource(table.getSource());
        ArrayList<Property> properties = new ArrayList<Property>(table.getFieldNames().size());
        HashMap repeatedNameIndex = new HashMap();
        for (Field field : table.getFields()) {
            Property property = new Property();
            property.setAlias(field.getName());
            property.setName(NameUtil.getPureName((String)field.getName(), repeatedNameIndex));
            property.setAssociateName(field.getName());
            property.setCommentInfo(field.getDisplayName() == null || field.getDisplayName().equals("") ? field.getName() : field.getDisplayName());
            property.setHide(false);
            property.setDataType(DataTypeToDesigningDataType.runtimeToDesigntime(field.getDataType()));
            property.setAppointedDataType(property.getDataType());
            property.addExtensionData("COLUMN_CLASS_NAME", field.getClassName());
            properties.add(property);
        }
        entity.setProperties(properties);
        return entity;
    }
}

