/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.IPropertyFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeProperty {
    public static final int TREE_TYPE_FLEXFIELD = 0;
    public static final int TREE_TYPE_CUSTOM_COMPLEX_FIELD = 1;
    private List<Property> children;
    private Property me;
    private int treeType;
    private boolean isHideInAnalysis;
    private Map<String, String> propNameToFlexFieldKeyMap = new HashMap<String, String>();
    private transient Map<String, Property> subFlexFieldMap = new HashMap<String, Property>();

    public TreeProperty(Property root, List<Property> children, int treeType) {
        this.me = root;
        this.me.setHasChild(true);
        this.isHideInAnalysis = root.isHide();
        this.children = children;
        for (Property child : children) {
            child.setParent(this.me);
            child.setHide(this.isHideInAnalysis);
            String subFlexFieldOriginalkey = child.getExtensionValue("subFlexFieldKey", String.class);
            if (null == subFlexFieldOriginalkey) continue;
            this.subFlexFieldMap.put(subFlexFieldOriginalkey, child);
            this.propNameToFlexFieldKeyMap.put(child.getName(), subFlexFieldOriginalkey);
        }
        this.treeType = treeType;
    }

    public boolean isHideInAnalysis() {
        return this.isHideInAnalysis;
    }

    public void setHideInAnalysis(boolean hideInAnalysis) {
        this.isHideInAnalysis = hideInAnalysis;
    }

    public int getTreeType() {
        return this.treeType;
    }

    public String getName() {
        return this.me.getName();
    }

    public Property getInnerProp() {
        return this.me;
    }

    public List<Property> getChildren() {
        return this.children;
    }

    public Property getProperties(IPropertyFilter filter) {
        for (Property prop : this.children) {
            if (!filter.doFilter(prop)) continue;
            return prop;
        }
        return null;
    }

    public Property getProperty(String propName) {
        for (Property prop : this.children) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        return null;
    }

    public List<Property> createCopyChildren() {
        ArrayList<Property> properties = new ArrayList<Property>(10);
        for (Property property : this.children) {
            properties.add(property.createCopy());
        }
        return properties;
    }

    public void mergeSubProperty(List<Property> newChildren) {
        for (Property property : newChildren) {
            String key = property.getExtensionValue("subFlexFieldKey", String.class);
            if (null == key || this.subFlexFieldMap.containsKey(key)) continue;
            Property copy = property.createCopy();
            copy.setParent(this.me);
            copy.setHide(true);
            this.children.add(copy);
            this.subFlexFieldMap.put(key, copy);
            this.propNameToFlexFieldKeyMap.put(copy.getName(), key);
        }
    }

    public Property getSubFlexField(String subFlexFieldKey) {
        return this.subFlexFieldMap.get(subFlexFieldKey);
    }

    public Map<String, String> getPropNameToFlexFieldKeyMap() {
        return this.propNameToFlexFieldKeyMap;
    }
}

