/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.formula;

import com.kingdee.bos.qing.common.grammar.FunctionProvider;
import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.Parser;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.formula.FunctionRegister;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormulaHelper {
    private static final FunctionProvider functionProvider = new FunctionProvider();

    public static void handleAll(List<Property> properties) {
        Map<String, Property> propertiesMap = FormulaHelper.list2Map(properties);
        FormulaHelper.fixExpr(properties, propertiesMap, new FormulaParsingExceptionHandlerImpl());
    }

    public static void handleAll(List<Property> properties, Map<String, Property> propertiesMap) {
        FormulaHelper.fixExpr(properties, propertiesMap, new FormulaParsingExceptionHandlerImpl());
    }

    public static void checkEditingFormula(List<Property> properties, IFormulaParsingExceptionHandler exHandler) {
        Map<String, Property> propertiesMap = FormulaHelper.list2Map(properties);
        FormulaHelper.fixExpr(properties, propertiesMap, exHandler);
    }

    private static IExpr parse(String formula, IContextRelativedExprConfirmer refConfirmer) throws ParserException {
        Parser parser = new Parser();
        parser.setFunctionProvider(functionProvider);
        parser.setContextRelativedExprConfirmer(refConfirmer);
        return parser.parse(formula);
    }

    private static void fixExpr(List<Property> properties, Map<String, Property> propertiesMap, IFormulaParsingExceptionHandler exHandler) {
        ContextRelativedExprConfirmer refConfirmer = new ContextRelativedExprConfirmer(propertiesMap);
        for (Property property : properties) {
            IExpr expr;
            String formula;
            if (!property.isCalculation() || (formula = property.getFormula().trim()).isEmpty()) continue;
            try {
                expr = FormulaHelper.parse(formula, refConfirmer);
            }
            catch (ParserException ex) {
                if (!exHandler.forParsing(property, ex)) continue;
                return;
            }
            property.setParsedFormula(expr);
            property.setDataType(FormulaHelper.confirmDesigningDataType(expr));
        }
        for (Property property : properties) {
            IExpr expr;
            block6: {
                if (!property.isValidCalculation()) continue;
                expr = property.getParsedFormula();
                ArrayList<String> refQueue = new ArrayList<String>();
                refQueue.add(property.getName());
                try {
                    FormulaHelper.checkCycleReference(expr, propertiesMap, refQueue);
                }
                catch (AbstractFormulaException ex) {
                    if (!exHandler.forChecking(property, ex)) break block6;
                    return;
                }
            }
            if (!property.isValidCalculation()) continue;
            HashSet<String> dependences = new HashSet<String>();
            FormulaHelper.collectDependence(expr, propertiesMap, dependences);
            property.setDependences(dependences);
        }
    }

    private static void checkCycleReference(IExpr root, Map<String, Property> propertiesMap, List<String> refQueue) throws AbstractFormulaException.CycleRefException, AbstractFormulaException.RefNotFoundException, AbstractFormulaException.InvalidRefException {
        ArrayList<IExpr> queue = new ArrayList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr[] subs;
            IExpr node = (IExpr)queue.remove(0);
            if (node instanceof RefExpr) {
                String propertyName = ((RefExpr)node).getName();
                if (refQueue.contains(propertyName)) {
                    throw new AbstractFormulaException.CycleRefException(propertyName, node.getCharIndexAtFormula());
                }
                Property property = propertiesMap.get(propertyName);
                if (property == null) {
                    throw new AbstractFormulaException.RefNotFoundException(propertyName, node.getCharIndexAtFormula());
                }
                if (property.isFormulaInvalid()) {
                    throw new AbstractFormulaException.InvalidRefException(propertyName, node.getCharIndexAtFormula());
                }
                IExpr expr = property.getParsedFormula();
                if (expr == null) continue;
                refQueue.add(propertyName);
                try {
                    FormulaHelper.checkCycleReference(property.getParsedFormula(), propertiesMap, refQueue);
                }
                catch (AbstractFormulaException.CycleRefException ex) {
                    property.setFormulaInvalid(true);
                    throw new AbstractFormulaException.CycleRefException(propertyName, node.getCharIndexAtFormula(), ex);
                }
                catch (AbstractFormulaException.RefNotFoundException ex) {
                    property.setFormulaInvalid(true);
                    throw new AbstractFormulaException.RefNotFoundException(propertyName, node.getCharIndexAtFormula(), ex);
                }
                refQueue.remove(refQueue.size() - 1);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(sub);
            }
        }
    }

    private static void collectDependence(IExpr root, Map<String, Property> propertiesMap, Set<String> collector) {
        ArrayList<IExpr> queue = new ArrayList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr[] subs;
            IExpr node = (IExpr)queue.remove(0);
            if (node instanceof RefExpr) {
                String fieldName = ((RefExpr)node).getName();
                Property property = propertiesMap.get(fieldName);
                if (property == null) {
                    throw new RuntimeException("Impossible here");
                }
                if (property.isCalculation()) {
                    Set<String> dependence = property.getDependences();
                    if (dependence == null) {
                        dependence = new HashSet<String>();
                        FormulaHelper.collectDependence(property.getParsedFormula(), propertiesMap, dependence);
                        property.setDependences(dependence);
                    }
                    collector.add(fieldName);
                    collector.addAll(dependence);
                    continue;
                }
                collector.add(fieldName);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(sub);
            }
        }
    }

    public static Map<String, Property> list2Map(List<Property> properties) {
        HashMap<String, Property> map = new HashMap<String, Property>(properties.size());
        for (Property property : properties) {
            map.put(property.getName(), property);
        }
        return map;
    }

    private static DesigningDataType confirmDesigningDataType(IExpr expr) {
        switch (expr.getReturnDataType()) {
            case 2: {
                return DesigningDataType.NUMBER;
            }
            case 4: {
                return DesigningDataType.DATE;
            }
            case 3: 
            case 5: {
                return DesigningDataType.DATETIME;
            }
            case 6: {
                return DesigningDataType.BOOLEAN;
            }
        }
        return DesigningDataType.STRING;
    }

    private static int confirmExprDataType(Property property) {
        if (property.getOutputDataType() == null) {
            return 0;
        }
        switch (property.getOutputDataType()) {
            case NUMBER: 
            case INT: {
                return 2;
            }
            case DATE: {
                return 4;
            }
            case DATETIME: {
                return 3;
            }
            case BOOLEAN: {
                return 6;
            }
        }
        return 1;
    }

    static {
        FunctionRegister.regist(functionProvider);
    }

    public static abstract class AbstractFormulaException
    extends Exception {
        protected String _propertyName;
        protected int _position;

        protected AbstractFormulaException(String message) {
            super(message);
        }

        public final String getPropertyName() {
            return this._propertyName;
        }

        public final int getPosition() {
            return this._position;
        }

        public static class CycleRefException
        extends AbstractFormulaException {
            public CycleRefException(String referencedPropertyName, int position) {
                super("[" + referencedPropertyName + "] is cycled.");
                this._propertyName = referencedPropertyName;
                this._position = position;
            }

            public CycleRefException(String referencedPropertyName, int position, Throwable cause) {
                super("[" + referencedPropertyName + "] is cycled.");
                this._propertyName = referencedPropertyName;
                this._position = position;
            }
        }

        public static class InvalidRefException
        extends AbstractFormulaException {
            public InvalidRefException(String referencedPropertyName, int position) {
                super("[" + referencedPropertyName + "] is invalid.");
                this._propertyName = referencedPropertyName;
                this._position = position;
            }
        }

        public static class RefNotFoundException
        extends AbstractFormulaException {
            public RefNotFoundException(String referencedPropertyName, int position) {
                super("[" + referencedPropertyName + "] not found.");
                this._propertyName = referencedPropertyName;
                this._position = position;
            }

            public RefNotFoundException(String referencedPropertyName, int position, Throwable cause) {
                super("[" + referencedPropertyName + "] not found.");
                this._propertyName = referencedPropertyName;
                this._position = position;
            }
        }
    }

    private static class ContextRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private Map<String, Property> _propertiesMap;

        public ContextRelativedExprConfirmer(Map<String, Property> propertiesMap) {
            this._propertiesMap = propertiesMap;
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            Property property = this._propertiesMap.get(expr.getName());
            if (property == null) {
                throw new ParserException(11, expr.getCharIndexAtFormula());
            }
            if (property.isFormulaInvalid()) {
                throw new ParserException(12, expr.getCharIndexAtFormula());
            }
            expr.setReturnDataType(FormulaHelper.confirmExprDataType(property));
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
            throw new ParserException(17, expr.getCharIndexAtFormula());
        }
    }

    private static class FormulaParsingExceptionHandlerImpl
    implements IFormulaParsingExceptionHandler {
        private FormulaParsingExceptionHandlerImpl() {
        }

        @Override
        public boolean forParsing(Property property, ParserException ex) {
            property.setFormulaInvalid(true);
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)("Parser formula error: " + property.getFormula()), (Throwable)ex);
            }
            return false;
        }

        @Override
        public boolean forChecking(Property property, AbstractFormulaException ex) {
            property.setFormulaInvalid(true);
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)("Check formula error: " + property.getParsedFormula().encode()), (Throwable)ex);
            }
            return false;
        }
    }

    public static interface IFormulaParsingExceptionHandler {
        public boolean forParsing(Property var1, ParserException var2);

        public boolean forChecking(Property var1, AbstractFormulaException var2);
    }
}

