/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.CompareType;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.ValueMode;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.IComparator;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.compare.ComparatorRuntimeApiSupplierFactory;
import com.kingdee.bos.qing.data.model.runtime.compare.IComapratorRuntimeApiSupplier;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.IEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.SimpleEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.compare.supplier.AbstractComparatorRuntimeApiSupplier;
import com.kingdee.bos.qing.data.model.runtime.compare.valueconvert.ComparePrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.model.runtime.compare.valueconvert.KylinDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.OutputDataTypeUtils;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompareFilter
implements IRuntimeFilter {
    private String _fieldName;
    private FilterItem.CompareOp _op;
    private String _comparedValue;
    private RelativeDateRange _relativeDateRange;
    private ValueMode _valueMode;
    private boolean _isInvalid;
    private AbstractSource _source;
    protected RuntimeEntity _runtimeEntity;
    protected String _associateName;
    protected DataType _dataType;
    protected DataType _rawDataType;
    protected Object _runtimeComparedValue;
    private RuntimeProperty _runtimeProperty;
    private AbstractComparatorRuntimeApiSupplier _comparatorRuntimeApiSupplier;
    private QingContext _qingContext;
    private CompareType _compareType;
    private IComparator _comparator;

    public final void init(FilterItem filterItem) {
        this._fieldName = filterItem.getProprety();
        this._op = filterItem.getCompareOp();
        this._comparedValue = filterItem.getValue();
        this._compareType = filterItem.getCompareType();
        this._relativeDateRange = filterItem.getRelativeDateRange();
        this._valueMode = filterItem.getValueMode();
        this._comparatorRuntimeApiSupplier = (AbstractComparatorRuntimeApiSupplier)ComparatorRuntimeApiSupplierFactory.select(this._op);
        this._comparatorRuntimeApiSupplier.setCompareFilter(this);
    }

    protected IComapratorRuntimeApiSupplier getComparatorRuntimeApiSupplier() {
        return this._comparatorRuntimeApiSupplier;
    }

    @Override
    public void bindRuntimeInfo(QingContext qingContext, RuntimeEntity runtimeEntity, Map<String, RuntimeProperty> allProperties) {
        this._qingContext = qingContext;
        this._runtimeEntity = runtimeEntity;
        this._runtimeProperty = allProperties.get(this.getFieldName());
        this._dataType = this.isCompareWithRawType() ? this._runtimeProperty.getInputDataType() : this._runtimeProperty.getOutputDataType();
        this._associateName = this._runtimeProperty.getAssociateName();
        this._runtimeComparedValue = this.getComparedValueObject();
        this._rawDataType = this._runtimeProperty.getInputDataType();
    }

    protected boolean isCompareWithRawType() {
        if (this._runtimeProperty.getInputDataType().equals((Object)this._runtimeProperty.getOutputDataType())) {
            return true;
        }
        return CompareType.RAW == this._compareType;
    }

    public Object getRuntimeComparedValue() {
        return this._runtimeComparedValue;
    }

    public final QingContext getQingContext() {
        return this._qingContext;
    }

    public ValueMode getValueMode() {
        return this._valueMode;
    }

    @Override
    public void collectProperties(List<RuntimeProperty> properties) {
        if (this.isCalculationalFilter() && this._runtimeProperty.getDependences() != null) {
            properties.addAll(this._runtimeProperty.getDependences());
        }
        properties.add(this._runtimeProperty);
    }

    public String getFilterName() {
        return this.getAssociateName();
    }

    public final String getFieldName() {
        return this._fieldName;
    }

    public String getTableName() {
        return this._runtimeEntity.getAssociateName();
    }

    public final void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public final String getAssociateName() {
        return this._associateName;
    }

    public final FilterItem.CompareOp getCompareOp() {
        return this._op;
    }

    public final void setCompareOp(FilterItem.CompareOp op) {
        this._op = op;
    }

    public final Object getComparedValue() {
        if (this._op == FilterItem.CompareOp.RELATIVE_DATE_RANGE) {
            return this._relativeDateRange;
        }
        return this._comparedValue;
    }

    public RuntimeProperty getRuntimeProperty() {
        return this._runtimeProperty;
    }

    public final RuntimeEntity getRuntimeEntity() {
        return this._runtimeEntity;
    }

    public final void setComparedValue(String value) {
        this._comparedValue = value;
    }

    public final DataType getDataType() {
        return this._dataType;
    }

    public final DataType getRawDataType() {
        return this._rawDataType;
    }

    @Override
    public void check(Set<String> fields) {
        this._isInvalid = !fields.contains(this._fieldName);
    }

    @Override
    public boolean isInvalid() {
        return this._isInvalid;
    }

    @Override
    public void collectPushDownFilter(List<IRuntimeFilter> pushDownFilters) {
        if (!this.isUnPushdownableFilter()) {
            pushDownFilters.add(this);
        }
    }

    public boolean supportEmptyStrFilter() {
        return this._dataType == DataType.STRING;
    }

    public boolean supportEmptyOrNotExistFilter() {
        return false;
    }

    public IEntityFilter getEmptyStrFilter() {
        return new SimpleEntityFilter(this.getFilterName(), "=", "");
    }

    public IEntityFilter getNotEmptyStrFilter() {
        return new SimpleEntityFilter(this.getFilterName(), "!=", "");
    }

    public IEntityFilter getEmptyOrNotExistFilter() {
        return new SimpleEntityFilter(this.getFilterName(), "empty or not exist", "");
    }

    @Override
    public void collectUnPushdownableFilter(List<IRuntimeFilter> filtersCollected) {
        if (this.isUnPushdownableFilter()) {
            filtersCollected.add(this);
        }
    }

    @Override
    public boolean isCalculationalFilter() {
        return this._runtimeProperty.isCalculation();
    }

    @Override
    public boolean isUnPushdownableFilter() {
        return this.isCalculationalFilter() || this._op != FilterItem.CompareOp.NOT_NULL && this._op != FilterItem.CompareOp.NULL && !this.isCompareWithRawType() || this._runtimeProperty.isInvalid4Union() || !this._runtimeProperty.isSelectProperty();
    }

    private Object getComparedValueObject() {
        if (this.isInvalid()) {
            return null;
        }
        try {
            return this._comparatorRuntimeApiSupplier.getValueHandler().toRuntimeValue(this.getComparedValue());
        }
        catch (IllegalArgumentException e) {
            LogUtil.warn((String)("convert runtime value error,dataType:" + this._dataType.name()));
            return null;
        }
    }

    public CompareType getCompareType() {
        return this._compareType;
    }

    public RelativeDateRange getRelativeDateRange() {
        return this._relativeDateRange;
    }

    private IComparator getComparator() {
        if (this._comparator == null) {
            this._comparator = this._comparatorRuntimeApiSupplier.getComparator();
            if (this.getEnumValue(this._runtimeComparedValue) != null) {
                this._comparator.setCompareValue(this.getEnumValue(this._runtimeComparedValue));
            } else {
                this._comparator.setCompareValue(this._runtimeComparedValue);
            }
        }
        return this._comparator;
    }

    private Object getEnumValue(Object enumKey) {
        String enumValue = null;
        Map<String, String> enumMap = this._runtimeProperty.getEnumValue();
        if (null != enumMap) {
            enumValue = enumMap.get(enumKey);
        }
        return enumValue;
    }

    public String getFieldFullName(String leftDelimiter, String rightDelimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append(leftDelimiter);
        sb.append(this.getTableName());
        sb.append(rightDelimiter);
        sb.append(".");
        sb.append(leftDelimiter);
        sb.append(this.getAssociateName());
        sb.append(rightDelimiter);
        return sb.toString();
    }

    public boolean needConvertFilterValueToString() {
        return false;
    }

    public PrimaryDataValueHandlerDelegate getPrimaryDataValueHandler() {
        DBSource.DBType dbType;
        AbstractSource source;
        RuntimeEntity runtimeEntity = this.getRuntimeEntity();
        if (runtimeEntity != null && (source = runtimeEntity.getSource()) instanceof DBSource && DBSource.DBType.KYLIN == (dbType = ((DBSource)source).getDbType())) {
            return new KylinDataValueHandlerDelegate(this._dataType, this._op, this._runtimeProperty.getProperty());
        }
        return new ComparePrimaryDataValueHandlerDelegate(this._dataType, this._op);
    }

    @Override
    public boolean innerExcuteFilterWtihRawValue(Map<String, Object> primaryRowData) {
        if (this.isCompareWithRawType()) {
            Object otherValue = primaryRowData.get(this.getFieldName());
            Object comparaValue = OutputDataTypeUtils.handle(this._dataType, otherValue);
            return this.getComparator().excute(comparaValue);
        }
        Object otherValue = primaryRowData.get(this.getFieldName());
        return this.getComparator().excute(otherValue);
    }

    @Override
    public final boolean innerExcuteFilter(Map<String, Object> primaryRowData, Map<String, Object> outputRowData) {
        Object otherValue = null;
        otherValue = this.isCompareWithRawType() ? primaryRowData.get(this.getFieldName()) : outputRowData.get(this.getFieldName());
        Object comparaValue = OutputDataTypeUtils.handle(this._dataType, otherValue);
        return this.getComparator().excute(comparaValue);
    }

    @Override
    public void setSource(AbstractSource source) {
        this._source = source;
    }

    public AbstractSource getSource() {
        return this._source;
    }

    public DBSource.DBType getDbType() {
        if (null == this._source) {
            return null;
        }
        if (this._source.getType() == SourceType.DB) {
            return ((DBSource)this._source).getDbType();
        }
        return null;
    }

    public void setRelativeDateRange(RelativeDateRange relativeDateRange) {
        this._relativeDateRange = relativeDateRange;
    }

    @Override
    public String getUnpushdownFilterExpress() {
        return this.formatSqlExpressFromObject(this._dataType, this._runtimeProperty.getAlias(), this._op, this.getComparedValue());
    }

    private String formatSqlExpressFromObject(DataType propertyType, String propertyName, FilterItem.CompareOp opt, Object propertyValue) {
        StringBuilder formatSql = new StringBuilder();
        formatSql.append(propertyName).append(" ");
        Timestamp relativeStartDate = null;
        Timestamp relativeEndDate = null;
        if ((propertyType == DataType.DATE || propertyType == DataType.DATETIME) && propertyValue != null) {
            if (propertyValue instanceof RelativeDateRange) {
                RelativeDateRange relativeDateRange = (RelativeDateRange)propertyValue;
                RuntimeRelativeDateRange runtimeRelativeDateRange = new RuntimeRelativeDateRange(relativeDateRange);
                runtimeRelativeDateRange.parseRange();
                relativeStartDate = new Timestamp(runtimeRelativeDateRange.getDateStart());
                relativeEndDate = new Timestamp(runtimeRelativeDateRange.getDateEnd());
            } else {
                propertyValue = new Timestamp(Long.parseLong(propertyValue.toString()));
            }
        }
        switch (opt) {
            case EQUAL: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            case NOT_EQUAL: {
                formatSql.append("<> ").append(propertyValue);
                break;
            }
            case GREATER: {
                formatSql.append("> ").append(propertyValue);
                break;
            }
            case GREATER_EQUAL: {
                formatSql.append(">= ").append(propertyValue);
                break;
            }
            case LESS: {
                formatSql.append("< ").append(propertyValue);
                break;
            }
            case LESS_EQUAL: {
                formatSql.append("<= ").append(propertyValue);
                break;
            }
            case INCLUDE: {
                formatSql.append("LIKE '%").append(propertyValue).append("%'");
                break;
            }
            case NOT_INCLUDE: {
                formatSql.append("NOT LIKE '%").append(propertyValue).append("%'");
                break;
            }
            case START_WITH: {
                formatSql.append("LIKE '").append(propertyValue).append("%'");
                break;
            }
            case END_WITH: {
                formatSql.append("LIKE '%").append(propertyValue).append("'");
                break;
            }
            case NULL: {
                formatSql.append(" IS NULL ");
                break;
            }
            case NOT_NULL: {
                formatSql.append(" IS NOT NULL ");
                break;
            }
            case IN: {
                formatSql.append("IN ").append(propertyValue);
                break;
            }
            case NOT_IN: {
                formatSql.append("NOT IN ").append(propertyValue);
                break;
            }
            case RELATIVE_DATE_RANGE: {
                formatSql.append(">= ").append(relativeStartDate).append(" AND ").append(propertyName).append(" < ").append(relativeEndDate);
                break;
            }
            case VARIABALE_MATCH: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            case CUSTOM_VARIABALE_MATCH: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            default: {
                formatSql.append((Object)opt).append(" ").append(propertyValue);
            }
        }
        return formatSql.toString();
    }
}

