/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.db.DataTypeToDesigningDataType;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.LogicalFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeParild;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuntimeEntity {
    private QingContext qingContext;
    private String ownerId;
    private RuntimeEntity parentEntity;
    private Set<String> parentEntityAssociateNameSet;
    private AbstractSource source;
    private AbstractEntity designtimeDataObject;
    private List<RuntimeProperty> allProperties;
    private List<RuntimeParild> allParilds;
    private Map<String, RuntimeParild> allParildMap;
    private Map<String, String> allAssociateNameMap;
    private Map<String, RuntimeProperty> allPropertiesMap;
    private Map<String, DataType> allInputDataTypeMap;
    private List<RuntimeProperty> allPriProperties;
    private Map<String, RuntimeProperty> allPriPropertyMap;
    private List<RuntimeProperty> selectedPriProperties;
    private Map<String, RuntimeProperty> selectedPriPropertyMap;
    private Map<String, RuntimeProperty> selectedPriAssociatePropertyMap;
    private List<RuntimeProperty> outputProperties;
    private List<RuntimeProperty> outputCalculateProperties;
    private List<RuntimeProperty> needToChangeTypeSelectedPriProperties;
    private MetaInfo metaInfo;
    private Set<String> whitePropertySet;
    private QSDataSourceWriter dataSourcePersistentWriter;
    private RuntimeEntity sourceRuntimeEntity;
    private EntityExtractContext entityExtractContext;
    private AbstractEntity rootEntity;
    private Map<String, Set<String>> invalidBaseDataProp = new HashMap<String, Set<String>>();
    private IRuntimeFilter pushdownableFilter = null;
    private IRuntimeFilter unPushdownableFilter = null;
    private Map<String, RuntimeProperty> calculatePropertiesMap;

    public EntityExtractContext getEntityExtractContext() {
        return this.entityExtractContext;
    }

    public void setEntityExtractContext(EntityExtractContext entityExtractContext) {
        this.entityExtractContext = entityExtractContext;
    }

    public QingContext getQingContext() {
        return this.qingContext;
    }

    public RuntimeEntity getSourceRuntimeEntity() {
        return this.sourceRuntimeEntity;
    }

    public void setSourceRuntimeEntity(RuntimeEntity sourceRuntimeEntity) {
        this.sourceRuntimeEntity = sourceRuntimeEntity;
    }

    public AbstractEntity getRootEntity() {
        return this.rootEntity;
    }

    public void setRootEntity(AbstractEntity rootEntity) {
        this.rootEntity = rootEntity;
    }

    public RuntimeEntity getSubRuntimeEntity(String subEntityName, Set<String> whitePropertySet) {
        return null;
    }

    public QSDataSourceWriter getDataSourcePersistentWriter() {
        return this.dataSourcePersistentWriter;
    }

    public void setDataSourcePersistentWriter(QSDataSourceWriter dataSourcePersistentWriter) {
        this.dataSourcePersistentWriter = dataSourcePersistentWriter;
    }

    public Map<String, RuntimeProperty> getOutputPropertyMap() {
        HashMap<String, RuntimeProperty> resultMap = new HashMap<String, RuntimeProperty>();
        if (CollectionUtils.isNotEmpty(this.outputProperties)) {
            for (RuntimeProperty runtimeProperty : this.outputProperties) {
                resultMap.put(runtimeProperty.getAssociateName(), runtimeProperty);
            }
        }
        return resultMap;
    }

    public RuntimeEntity(AbstractEntity designtimeDataObject, Set<String> whitePropertySet, AbstractSource source, QingContext qingContext, String ownerId) {
        this.whitePropertySet = whitePropertySet;
        this.designtimeDataObject = designtimeDataObject;
        this.source = source;
        this.qingContext = qingContext;
        this.ownerId = ownerId;
        this.allParilds = new ArrayList<RuntimeParild>();
        this.allParildMap = new HashMap<String, RuntimeParild>();
        List<Parild> parilds = designtimeDataObject.getParilds();
        if (parilds != null && !parilds.isEmpty()) {
            for (Parild parild : parilds) {
                RuntimeParild runtimeParild = new RuntimeParild(parild);
                this.allParilds.add(runtimeParild);
                this.allParildMap.put(runtimeParild.getName(), runtimeParild);
            }
        }
        List<Property> allPropertyList = this.getPropertyList();
        FormulaHelper.handleAll(allPropertyList);
        this.allProperties = new ArrayList<RuntimeProperty>(10);
        this.allPriProperties = new ArrayList<RuntimeProperty>(10);
        this.allPropertiesMap = new HashMap<String, RuntimeProperty>(16);
        this.allPriPropertyMap = new HashMap<String, RuntimeProperty>(16);
        this.allInputDataTypeMap = new HashMap<String, DataType>(16);
        this.allAssociateNameMap = new HashMap<String, String>(16);
        for (Property property : allPropertyList) {
            String propertyName = property.getName();
            DataType outputDataType = DataTypeToDesigningDataType.designtimeToRuntime(property.getOutputDataType());
            DataType inputDataType = DataTypeToDesigningDataType.designtimeToRuntime(property.getDataType());
            RuntimeProperty runtimeProperty = new RuntimeProperty(property);
            runtimeProperty.setEntityName(designtimeDataObject.getName());
            runtimeProperty.setInputDataType(inputDataType);
            runtimeProperty.setOutputDataType(outputDataType);
            if (null != whitePropertySet) {
                runtimeProperty.setWhiteProperty(this.whitePropertySet.contains(propertyName));
            }
            this.allProperties.add(runtimeProperty);
            this.allInputDataTypeMap.put(propertyName, inputDataType);
            this.allAssociateNameMap.put(propertyName, property.getAssociateName());
            this.allPropertiesMap.put(propertyName, runtimeProperty);
            if (runtimeProperty.isCalculation() || runtimeProperty.isInvalid4Union()) continue;
            this.allPriProperties.add(runtimeProperty);
            this.allPriPropertyMap.put(propertyName, runtimeProperty);
        }
        this.buildPropDependency(allPropertyList);
    }

    private List<Property> getPropertyList() {
        return this.getAllPropertyToConvert();
    }

    protected List<Property> getAllPropertyToConvert() {
        return this.designtimeDataObject.getProperties();
    }

    public void init(Set<String> outputPropertySetFromDataSource) {
        this.metaInfo = new MetaInfo();
        this.selectedPriProperties = new ArrayList<RuntimeProperty>();
        this.selectedPriPropertyMap = new HashMap<String, RuntimeProperty>();
        this.selectedPriAssociatePropertyMap = new HashMap<String, RuntimeProperty>();
        this.needToChangeTypeSelectedPriProperties = new ArrayList<RuntimeProperty>();
        this.outputCalculateProperties = new ArrayList<RuntimeProperty>();
        this.calculatePropertiesMap = new HashMap<String, RuntimeProperty>();
        this.outputProperties = new ArrayList<RuntimeProperty>();
        for (RuntimeProperty runtimeProperty : this.allProperties) {
            String columnName = runtimeProperty.getName();
            if (outputPropertySetFromDataSource != null && !outputPropertySetFromDataSource.isEmpty() && !outputPropertySetFromDataSource.contains(columnName)) continue;
            DataType outputDataType = runtimeProperty.getOutputDataType();
            if (!runtimeProperty.isCalculation() && !runtimeProperty.isInvalid4Union()) {
                DataType inputDataType;
                Map<String, String> enumValueMap;
                if (runtimeProperty.isSelectProperty()) {
                    this.selectedPriProperties.add(runtimeProperty);
                    this.selectedPriPropertyMap.put(runtimeProperty.getName(), runtimeProperty);
                    this.selectedPriAssociatePropertyMap.put(runtimeProperty.getAssociateName(), runtimeProperty);
                }
                if ((enumValueMap = runtimeProperty.getEnumValue()) != null) {
                    this.needToChangeTypeSelectedPriProperties.add(runtimeProperty);
                }
                if (!(inputDataType = runtimeProperty.getInputDataType()).equals((Object)outputDataType)) {
                    this.needToChangeTypeSelectedPriProperties.add(runtimeProperty);
                }
            }
            if (runtimeProperty.getExpr() != null) {
                this.outputCalculateProperties.add(runtimeProperty);
                this.calculatePropertiesMap.put(columnName, runtimeProperty);
            }
            if (runtimeProperty.isInvalid4Parent() || !runtimeProperty.isDataModelSupported() || !runtimeProperty.isOutputSupported()) continue;
            this.metaInfo.addField(columnName, runtimeProperty.getAlias(), outputDataType);
            this.outputProperties.add(runtimeProperty);
        }
    }

    private void buildPropDependency(List<Property> properties) {
        for (Property property : properties) {
            Set<String> dependences;
            if (!property.isValidCalculation() || (dependences = property.getDependences()) == null || dependences.isEmpty()) continue;
            String propertyName = property.getName();
            RuntimeProperty runtimeProperty = this.allPropertiesMap.get(propertyName);
            ArrayList<RuntimeProperty> dependencePropertys = new ArrayList<RuntimeProperty>(10);
            for (String refPropertyName : dependences) {
                dependencePropertys.add(this.allPropertiesMap.get(refPropertyName));
            }
            runtimeProperty.setDependences(dependencePropertys);
        }
    }

    public <T extends CompareFilter, K extends LogicalFilter> void initFilter(Class<T> compareFilterClass, Class<K> logicalFilterClass, RuntimeFilterUtil.Prediction prediction) {
        IRuntimeFilter filter = RuntimeFilterUtil.parseFilter(this.designtimeDataObject.getFilters(), compareFilterClass, logicalFilterClass, prediction);
        if (prediction.isAlwaysFalse()) {
            return;
        }
        if (prediction.isAlwaysTrue()) {
            return;
        }
        ArrayList<IRuntimeFilter> pushDownFilters = new ArrayList<IRuntimeFilter>();
        ArrayList<IRuntimeFilter> unPushDownFilters = new ArrayList<IRuntimeFilter>();
        if (filter != null) {
            filter.check(this.allPropertiesMap.keySet());
            if (!filter.isInvalid()) {
                LogicalFilter logicalFilter2;
                int index;
                LogicalFilter logicalFilter;
                filter.setSource(this.source);
                filter.bindRuntimeInfo(this.qingContext, this, this.allPropertiesMap);
                filter.collectPushDownFilter(pushDownFilters);
                filter.collectUnPushdownableFilter(unPushDownFilters);
                this.pushdownableFilter = null;
                if (!pushDownFilters.isEmpty()) {
                    if (pushDownFilters.size() == 1) {
                        this.pushdownableFilter = (IRuntimeFilter)pushDownFilters.get(0);
                    } else if (pushDownFilters.size() >= 2) {
                        try {
                            logicalFilter = (LogicalFilter)logicalFilterClass.newInstance();
                            logicalFilter.setLeft((IRuntimeFilter)pushDownFilters.get(0));
                            logicalFilter.setOp(FilterItem.LogicOp.AND);
                            logicalFilter.setRight((IRuntimeFilter)pushDownFilters.get(1));
                            for (index = 2; index < pushDownFilters.size(); ++index) {
                                logicalFilter2 = (LogicalFilter)logicalFilterClass.newInstance();
                                logicalFilter2.setLeft(logicalFilter);
                                logicalFilter2.setOp(FilterItem.LogicOp.AND);
                                logicalFilter2.setRight((IRuntimeFilter)pushDownFilters.get(index));
                                logicalFilter = logicalFilter2;
                            }
                            this.pushdownableFilter = logicalFilter;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                this.unPushdownableFilter = null;
                if (!unPushDownFilters.isEmpty()) {
                    if (unPushDownFilters.size() == 1) {
                        this.unPushdownableFilter = (IRuntimeFilter)unPushDownFilters.get(0);
                    } else if (unPushDownFilters.size() >= 2) {
                        try {
                            logicalFilter = (LogicalFilter)logicalFilterClass.newInstance();
                            logicalFilter.setLeft((IRuntimeFilter)unPushDownFilters.get(0));
                            logicalFilter.setOp(FilterItem.LogicOp.AND);
                            logicalFilter.setRight((IRuntimeFilter)unPushDownFilters.get(1));
                            for (index = 2; index < unPushDownFilters.size(); ++index) {
                                logicalFilter2 = (LogicalFilter)logicalFilterClass.newInstance();
                                logicalFilter2.setLeft(logicalFilter);
                                logicalFilter2.setOp(FilterItem.LogicOp.AND);
                                logicalFilter2.setRight((IRuntimeFilter)unPushDownFilters.get(index));
                                logicalFilter = logicalFilter2;
                            }
                            this.unPushdownableFilter = logicalFilter;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    public IRuntimeFilter getPushdownableFilter() {
        return this.pushdownableFilter;
    }

    public IRuntimeFilter getUnPushdownableFilter() {
        return this.unPushdownableFilter;
    }

    public AbstractSource getSource() {
        return this.source;
    }

    public RuntimeEntity getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(RuntimeEntity parentEntity) {
        this.parentEntity = parentEntity;
    }

    public Set<String> getParentEntityAssociateNameSet() {
        if (this.parentEntityAssociateNameSet == null) {
            this.parentEntityAssociateNameSet = new HashSet<String>();
            RuntimeEntity tempEntity = this;
            for (RuntimeEntity parentEntity = tempEntity.getParentEntity(); parentEntity != null; parentEntity = parentEntity.getParentEntity()) {
                String parentEntityAssociateName = parentEntity.getAssociateName();
                this.parentEntityAssociateNameSet.add(parentEntityAssociateName);
            }
            return this.parentEntityAssociateNameSet;
        }
        return this.parentEntityAssociateNameSet;
    }

    public String getRootEntityAssociateName() {
        if (this.parentEntity == null) {
            return this.getAssociateName();
        }
        return this.parentEntity.getRootEntityAssociateName();
    }

    public void setSource(AbstractSource source) {
        this.source = source;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public List<RuntimeParild> getAllParilds() {
        return this.allParilds;
    }

    public Map<String, RuntimeParild> getAllParildMap() {
        return this.allParildMap;
    }

    public List<RuntimeProperty> getAllProperties() {
        return this.allProperties;
    }

    public Map<String, RuntimeProperty> getAllPropertiesMap() {
        return this.allPropertiesMap;
    }

    public Map<String, String> getAllAssociateNameMap() {
        return this.allAssociateNameMap;
    }

    public Map<String, DataType> getAllInputDataTypeMap() {
        return this.allInputDataTypeMap;
    }

    public List<RuntimeProperty> getAllPriProperties() {
        return this.allPriProperties;
    }

    public Map<String, RuntimeProperty> getAllPriPropertyMap() {
        return this.allPriPropertyMap;
    }

    public Map<String, RuntimeProperty> getSelectedPriPropertyMap() {
        return this.selectedPriPropertyMap;
    }

    public Map<String, RuntimeProperty> getSelectedPriAssociatePropertyMap() {
        return this.selectedPriAssociatePropertyMap;
    }

    public List<RuntimeProperty> getSelectedPriProperties() {
        return this.selectedPriProperties;
    }

    public List<RuntimeProperty> getNeedToChangeTypeSelectedPriProperties() {
        return this.needToChangeTypeSelectedPriProperties;
    }

    public List<RuntimeProperty> getOutputProperties() {
        return this.outputProperties;
    }

    public List<RuntimeProperty> getOutputCalculateProperties() {
        return this.outputCalculateProperties;
    }

    public Map<String, RuntimeProperty> getCalculatePropertiesMap() {
        return this.calculatePropertiesMap;
    }

    public Set<String> getWhitePropertySet() {
        return this.whitePropertySet;
    }

    public AbstractEntity getOrinalEntity() {
        return this.designtimeDataObject;
    }

    public String getAssociateName() {
        return this.designtimeDataObject.getAssociateName();
    }

    public String getName() {
        return this.designtimeDataObject.getName();
    }

    public String getAlias() {
        return this.designtimeDataObject.getAlias();
    }

    public Map<String, Set<String>> getInvalidBaseFlexDatas() {
        return this.invalidBaseDataProp;
    }

    public int getColumnSize() {
        return this.designtimeDataObject.getProperties().size();
    }

    public boolean isUnionUnitEntity() {
        return this.designtimeDataObject.isUnionUnitEntity();
    }

    public List<FilterItem> getFilters() {
        return this.designtimeDataObject.getFilters();
    }

    public <T> T getExtension(Class<T> tClass) {
        if (this.designtimeDataObject instanceof Entity) {
            Entity entity = (Entity)this.designtimeDataObject;
            return entity.getExtension(tClass);
        }
        return null;
    }
}

