/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition;

import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.SqlConditionBuilder;

public class NotInSqlConditionBuilder
extends SqlConditionBuilder {
    private int paramNum;
    public static final int MAX_IN_PARAM_NUM = 256;

    public NotInSqlConditionBuilder(int paramNum) {
        this.paramNum = paramNum;
    }

    @Override
    public String build(String fieldName) {
        int inCount = this.paramNum / 256 + 1;
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName).append(" is null ");
        sb.append(" OR ");
        sb.append(" ( ");
        for (int i = 0; i < inCount; ++i) {
            int paramSize = this.getParamSize(inCount, i);
            String inCondition = this.buildInConditionString(fieldName, paramSize);
            if (i == inCount - 1) {
                sb.append(inCondition);
                continue;
            }
            sb.append(inCondition).append(" AND ");
        }
        sb.append(" ) ");
        sb.insert(0, " ( ");
        sb.append(" ) ");
        return sb.toString();
    }

    private int getParamSize(int inCount, int i) {
        if (i == inCount - 1) {
            return this.paramNum - (inCount - 1) * 256;
        }
        return 256;
    }

    private String buildInConditionString(String fieldName, int paramSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName).append(" not in ( ");
        for (int i = 0; i < paramSize; ++i) {
            if (i < paramSize - 1) {
                sb.append(" ? ").append(',');
                continue;
            }
            sb.append(" ? ");
        }
        sb.append(" ) ");
        return sb.toString();
    }
}

